import * as React from 'react';
export interface ImageRendererProps {
    src: string;
    loading?: React.ReactNode;
    loaded?: React.ReactNode;
    errored?: React.ReactNode;
    children?: (status: {
        image?: HTMLImageElement;
        loaded: boolean;
        errored: boolean;
    }) => React.ReactNode;
    onLoad?: () => void;
    onError?: () => void;
}
export declare enum ImageRendererStatus {
    LOADING = 0,
    LOADED = 1,
    ERRORED = 2
}
declare const ImageRenderer: React.FC<ImageRendererProps>;
export default ImageRenderer;
