# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](http://keepachangelog.com/en/1.0.0/)
and this project adheres to [Semantic Versioning](http://semver.org/spec/v2.0.0.html).

Generated by [`auto-changelog`](https://github.com/CookPete/auto-changelog).

## [Unreleased](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.47...HEAD)

## [v3.1.47](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.46...v3.1.47) - 2019-02-11

### Commits

- issue#309: Fix tests for swipe direction [`04fb23b`](https://github.com/leandrowd/react-responsive-carousel/commit/04fb23b8d1d6ad9ae8bff02d51cfa364ae8366e0)
- issue#309: Fix swipe direction [`77b6fb5`](https://github.com/leandrowd/react-responsive-carousel/commit/77b6fb595816724fc603b116f5085f8c4ffb9306)

## [v3.1.46](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.45...v3.1.46) - 2019-01-23

### Commits

- issue #303: Fixing autoplay when swipeable is turned off [`1b3712e`](https://github.com/leandrowd/react-responsive-carousel/commit/1b3712e39b35d17f1d4f96fa0a5801db53771bb7)
- Remove unused variables noted by LGTM.com [`9a29716`](https://github.com/leandrowd/react-responsive-carousel/commit/9a297161edd415f8e50e7142933ebb3e373b61dd)
- Add missing semicolons [`453ab3e`](https://github.com/leandrowd/react-responsive-carousel/commit/453ab3ef4c7c2d9f1e71948fd88693256f1b7b46)

## [v3.1.45](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.44...v3.1.45) - 2018-12-15

## [v3.1.44](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.43...v3.1.44) - 2018-12-14

### Commits

- accessibility: allow dots to be accessible via keyboard [`b061c2e`](https://github.com/leandrowd/react-responsive-carousel/commit/b061c2eede8eab8c46b0da1df5de60a2aa5a0908)
- accessibility: allow thumbnails to be navigable via keyboard [`51eaa62`](https://github.com/leandrowd/react-responsive-carousel/commit/51eaa625462f916cc7d938da12bc9d4dbad83d84)
- #267: update snapshot [`46e529b`](https://github.com/leandrowd/react-responsive-carousel/commit/46e529ba8f7a613b6867a508a3ddacfb4ace7adb)

## [v3.1.43](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.42...v3.1.43) - 2018-10-05

### Commits

- add infinite scrolling from end to start [`b45e57b`](https://github.com/leandrowd/react-responsive-carousel/commit/b45e57b906fd6fc338d4da10bc8b776d7888b6ca)
- use setstate cb with nested raf for animation [`4ac6c4f`](https://github.com/leandrowd/react-responsive-carousel/commit/4ac6c4f4b1750f91986b6bfa9e6a255086955271)
- major refactor implementation [`ce23364`](https://github.com/leandrowd/react-responsive-carousel/commit/ce23364f0b9ba5eb6b5906fbb1332acec0990dfa)

## [v3.1.42](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.41...v3.1.42) - 2018-09-17

### Commits

- Restore resetPosition but place on componentDidUpdate so it resets position to the NEW slide in the case where a change just occurred [`821ed17`](https://github.com/leandrowd/react-responsive-carousel/commit/821ed175c154d29e3e493dac25283683fc2107b4)
- Update README.md [`b86091e`](https://github.com/leandrowd/react-responsive-carousel/commit/b86091ebbaad2864984724e43f1cc5a395feeb3d)
- css file added in usage (README.md) [`9b1b22a`](https://github.com/leandrowd/react-responsive-carousel/commit/9b1b22ac556408ba8aef21c3696c5bd9c141d0f1)

## [v3.1.41](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.40...v3.1.41) - 2018-06-20

### Commits

- Removing package-lock.json [`cfc2238`](https://github.com/leandrowd/react-responsive-carousel/commit/cfc2238400157be54911e83debe096ff709c956d)

## [v3.1.40](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.39...v3.1.40) - 2018-06-16

### Commits

- add built files [`c320208`](https://github.com/leandrowd/react-responsive-carousel/commit/c32020842a2809ede7a1f91400ee8206097fe76a)
- add autoPlay to state and update upon props change [`48390bd`](https://github.com/leandrowd/react-responsive-carousel/commit/48390bd2175b362d3868caa55445fa42118fb32b)
- fix: remove resetPosition() on swipe end [`d483950`](https://github.com/leandrowd/react-responsive-carousel/commit/d483950f73b9eafe0977cfc5c7041d56e5a2aa28)

## [v3.1.39](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.38...v3.1.39) - 2018-05-22

### Commits

- Fix typeof comparison [`4ec3232`](https://github.com/leandrowd/react-responsive-carousel/commit/4ec32325f0ca15916c5af8028228c5f5b0a60209)
- Fix itemsList ref [`71f5710`](https://github.com/leandrowd/react-responsive-carousel/commit/71f57107195b2f0c20747cdc94379ddd2a18822b)

## [v3.1.38](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.37...v3.1.38) - 2018-05-21

### Commits

- Fix wrapperSize init [`95eef5b`](https://github.com/leandrowd/react-responsive-carousel/commit/95eef5b80f2e02de0e3afbeeeb76cb2c4dd07658)
- Updating react-easy-swipe [`1e3bcf1`](https://github.com/leandrowd/react-responsive-carousel/commit/1e3bcf1600053f0a16aadd1ff4077ba7e730c8f0)

## [v3.1.37](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.35...v3.1.37) - 2018-04-24

### Commits

- Updated to refs callback [`7707995`](https://github.com/leandrowd/react-responsive-carousel/commit/77079959008c240710841c1934d794e19b9702f2)
- Minor changes based on code review [`e463bbf`](https://github.com/leandrowd/react-responsive-carousel/commit/e463bbf163a6693cec4721c17e9c0c052780ca25)
- Updated tests [`3463f4a`](https://github.com/leandrowd/react-responsive-carousel/commit/3463f4ab8d375c36d92a66dfdf4972fe879f2e10)

## [v3.1.35](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.34...v3.1.35) - 2018-03-31

## [v3.1.34](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.33...v3.1.34) - 2018-03-29

### Commits

- remove .idea/ directory; remove package-lock.json [`149d4a1`](https://github.com/leandrowd/react-responsive-carousel/commit/149d4a1910eb72afd42bd9e9b7cfa11fa08ad58c)
- make carousel work with only 1 child passed in [`7a20cd9`](https://github.com/leandrowd/react-responsive-carousel/commit/7a20cd9674b7a665a5e49144b5e9781a7e015ef3)
- import Children from React, other minor changes [`f908584`](https://github.com/leandrowd/react-responsive-carousel/commit/f9085844f69341074880ce29f4cd03452f387a0f)

## [v3.1.33](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.32...v3.1.33) - 2018-01-29

### Commits

- Updating example with external controls [`411cd50`](https://github.com/leandrowd/react-responsive-carousel/commit/411cd5044a56cae870bafd8a42d602e6cce1539c)
- fix: indentation in scss [`a36501a`](https://github.com/leandrowd/react-responsive-carousel/commit/a36501a66b834e93d3aa4a6aee3615f6f13cf0ae)

## [v3.1.32](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.31...v3.1.32) - 2018-01-29

## [v3.1.31](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.30...v3.1.31) - 2018-01-29

### Commits

- chore: add build /lib [`39184c9`](https://github.com/leandrowd/react-responsive-carousel/commit/39184c93a1e431f904ba18887e137a4ea815733d)
- fix: setting transform properties on swipe [`3303030`](https://github.com/leandrowd/react-responsive-carousel/commit/3303030a442764041e52e85c6c988a979982d89d)
- refactor: move style rules to not be applied to everying inside slide [`69fef99`](https://github.com/leandrowd/react-responsive-carousel/commit/69fef991fa2b9430394fb662e19b023e77e3fcec)

## [v3.1.30](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.29...v3.1.30) - 2017-12-01

### Commits

- BUGFIX - updates to arrow key navigation handler to work in IE/Edge. Changed match from e.key => e.keyCode. Updated Carousel tests to account for new methods. There are two tests that fail, but they were failing in the existing repo as well. [`d538ad3`](https://github.com/leandrowd/react-responsive-carousel/commit/d538ad38c7f41391bdaa1dab889e1e9680a911a7)
- Updates per requests from PR [`02a091a`](https://github.com/leandrowd/react-responsive-carousel/commit/02a091a7418c69d7ee50de6caaf1890054352a35)

## [v3.1.29](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.28...v3.1.29) - 2017-11-30

### Commits

- refactor: using ref as a callback instead of string to fix react ref error [`8a276f9`](https://github.com/leandrowd/react-responsive-carousel/commit/8a276f9eaa665d72f0290be32036ebde95663201)
- feat: add verticalSwipe property to deal with mobile vertical swipping. [`49a5d52`](https://github.com/leandrowd/react-responsive-carousel/commit/49a5d52bfc981f754ca03dbcca144b5bea88492a)
- refactor: using if else statement instead of ternary to avoid multiple elements with same ref in render [`fee17aa`](https://github.com/leandrowd/react-responsive-carousel/commit/fee17aa5073c2beecc2d3b969caad2ca53d43fbd)

## [v3.1.28](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.27...v3.1.28) - 2017-10-20

### Commits

- Add centerMode prop [`9a20609`](https://github.com/leandrowd/react-responsive-carousel/commit/9a20609c8c0bf8582ee28a4131c4db6afc2ded28)
- Add centerSlidePercentage [`2ba3e6a`](https://github.com/leandrowd/react-responsive-carousel/commit/2ba3e6a1b6759c313687fafbcbe7434bb6640132)
- Create CODE_OF_CONDUCT.md [`e49e7ec`](https://github.com/leandrowd/react-responsive-carousel/commit/e49e7ecc0bd318f6d99e5b818e4cb9ca507f42ad)

## [v3.1.27](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.26...v3.1.27) - 2017-09-26

### Commits

- #151: Autoplay keeps trying to transition after the component has been unmounted [`79c6167`](https://github.com/leandrowd/react-responsive-carousel/commit/79c616785b4496cd3134b550a9abf6b2835c02fa)

## [v3.1.26](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.25...v3.1.26) - 2017-09-22

### Commits

- Adding CONTRIBUTING.md [`e9e1cc1`](https://github.com/leandrowd/react-responsive-carousel/commit/e9e1cc123feccb09aa737829109cda6058ba2413)
- added Component and removed bracker from code example of README [`de7ac9b`](https://github.com/leandrowd/react-responsive-carousel/commit/de7ac9b240192d1fe587e514a1530a92571cb089)
- add thumbWidth prop to allow specifying thumbnail width [`f365fd5`](https://github.com/leandrowd/react-responsive-carousel/commit/f365fd5b82c4ab38b7baf22593ca7af8a83129ea)

## [v3.1.25](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.24...v3.1.25) - 2017-08-26

### Commits

- issue-159: Ignoring storybook when publishing to npm [`c852ece`](https://github.com/leandrowd/react-responsive-carousel/commit/c852ece695f306a946514abcd223c9b7959f3c43)
- #159: Updating css instructions [`4498f13`](https://github.com/leandrowd/react-responsive-carousel/commit/4498f137d5ccfa4cb81f7e0cabf390102e048bad)
- Update README.md [`4c40847`](https://github.com/leandrowd/react-responsive-carousel/commit/4c408475213a7f7cf2cf5785ad802b948cfaa2b5)

## [v3.1.24](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.23...v3.1.24) - 2017-07-04

### Commits

- #148 Autoplay and stop on hover causes a warning. [`ccf032d`](https://github.com/leandrowd/react-responsive-carousel/commit/ccf032de466a5a13dc6d4b9347c03daf1644df1c)
- #148 Autoplay and stop on hover causes a warning. [`2ba4249`](https://github.com/leandrowd/react-responsive-carousel/commit/2ba4249885a3f6b1f64264f7cf3926904b0f0c63)
- #148 Autoplay and stop on hover causes a warning. [`dd74844`](https://github.com/leandrowd/react-responsive-carousel/commit/dd748444d9ca28a3e73f1c6fece74fca2fd805b6)

## [v3.1.23](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.22...v3.1.23) - 2017-07-04

### Commits

- #148 Autoplay and stop on hover causes a warning. [`c3a147e`](https://github.com/leandrowd/react-responsive-carousel/commit/c3a147e5f61ef38adcdf056fc0f896e3169a162e)
- Types author header added. [`28bb050`](https://github.com/leandrowd/react-responsive-carousel/commit/28bb0503b9200ec89011b749d13a887ff2b2b435)

## [v3.1.22](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.21...v3.1.22) - 2017-07-03

### Commits

- TypeScript types definitions file added. [`8e5441a`](https://github.com/leandrowd/react-responsive-carousel/commit/8e5441aba8bdb940bec4c9c9bbec96af288889e5)
- `children` prop added. [`6443f73`](https://github.com/leandrowd/react-responsive-carousel/commit/6443f73fedb6fc017f55761d06ba5982636547e1)

## [v3.1.21](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.20...v3.1.21) - 2017-06-25

### Commits

- #134: Using move to on componentWillReceiveProps so the carousel respects its boundaries when changed through external controls [`eaba563`](https://github.com/leandrowd/react-responsive-carousel/commit/eaba5630e1304ce4965c15aaca9831afddd7d7c7)

## [v3.1.20](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.19...v3.1.20) - 2017-06-24

### Commits

- #140: Revert to initial position when movement is less than tolerance [`2fa8a61`](https://github.com/leandrowd/react-responsive-carousel/commit/2fa8a61ec934dbe35ba489ac828f27c7e3385de2)
- Adding license [`aa5ac14`](https://github.com/leandrowd/react-responsive-carousel/commit/aa5ac14bb001b6abc866a145e921cf66bfdb9735)
- Update changelog and changelog whitelist [`e304469`](https://github.com/leandrowd/react-responsive-carousel/commit/e30446969483fedb07aeab8eac18a083fb694e22)

## [v3.1.19](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.18...v3.1.19) - 2017-05-29

### Commits

- #131: Removing old unused files [`1d4a623`](https://github.com/leandrowd/react-responsive-carousel/commit/1d4a623d90427a6f6523bfe04d241e57bd9cc2e2)
- #131: Add story and docs about the custom formatter [`da5e4f2`](https://github.com/leandrowd/react-responsive-carousel/commit/da5e4f23e7c4a0be18332f300da343a6093e0286)
- #131: Allow user to pass a custom formatter for status [`c696a50`](https://github.com/leandrowd/react-responsive-carousel/commit/c696a5030f0018ebd2409684aa837d1c8c582351)

## [v3.1.18](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.17...v3.1.18) - 2017-05-29

### Commits

- #129: Allow only right and left keys when axis is horizontal [`52a922c`](https://github.com/leandrowd/react-responsive-carousel/commit/52a922c5a1de25337f36406b3649df04436d8303)

## [v3.1.17](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.16...v3.1.17) - 2017-05-22

### Commits

- #118: Fixing jank swipe on mobile [`42aede5`](https://github.com/leandrowd/react-responsive-carousel/commit/42aede54eafe53974f7b40dbf369dde50128e310)

## [v3.1.16](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.15...v3.1.16) - 2017-05-11

### Commits

- #118: Adding support to swipe tolerance [`a3aaa12`](https://github.com/leandrowd/react-responsive-carousel/commit/a3aaa12bfb731ee428288728fbaaaaa60f69cb3e)

## [v3.1.15](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.14...v3.1.15) - 2017-04-30

### Commits

- #97: Fixing issue with auto play and swipe on mobile [`c7ac56c`](https://github.com/leandrowd/react-responsive-carousel/commit/c7ac56ca2e74db81225535d610c46ce684a340cf)
- #97: Updating react-easy-swipe [`4341692`](https://github.com/leandrowd/react-responsive-carousel/commit/434169220c9f8676959f2b67205f9d8330e489c5)

## [v3.1.14](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.13...v3.1.14) - 2017-04-29

### Commits

- #112: Fix emulateTouch [`5d5b712`](https://github.com/leandrowd/react-responsive-carousel/commit/5d5b7122c6c6500c584d1370433bd15b46b67038)

## [v3.1.13](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.12...v3.1.13) - 2017-04-29

### Commits

- #112: Fix auto play [`f74e1a8`](https://github.com/leandrowd/react-responsive-carousel/commit/f74e1a8c1001442b1237fd5fc0f4e730029aa340)

## [v3.1.12](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.11...v3.1.12) - 2017-04-29

### Commits

- #112: Converting source to es6 [`8f0588d`](https://github.com/leandrowd/react-responsive-carousel/commit/8f0588d873118f500ad40b8bcefb955ae242fa89)
- #98: Fixing bug where the Thumbs component would throw an error if a custom component was rendered inside it [`97029bc`](https://github.com/leandrowd/react-responsive-carousel/commit/97029bcbf8cf4e1c99e7808722d1108682d57870)
- Creating changelog [`aaac793`](https://github.com/leandrowd/react-responsive-carousel/commit/aaac79365857e987db03a596ac519c5845b039d0)

## [v3.1.11](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.10...v3.1.11) - 2017-04-26

### Commits

- #98: Adding snapshot tests [`0d74a56`](https://github.com/leandrowd/react-responsive-carousel/commit/0d74a56168d4a043f723a8eb1f10c5a353c412bd)
- #98: Delay rendering of thumbs when children is not provided [`b3ac415`](https://github.com/leandrowd/react-responsive-carousel/commit/b3ac41531fe8fead406b2a0b008b927b051e8176)
- #98: Testing only component source, not storybook [`bc2ed3c`](https://github.com/leandrowd/react-responsive-carousel/commit/bc2ed3c3c6d82ef63a2d7950ed714e5e3834ba10)

## [v3.1.10](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.9...v3.1.10) - 2017-04-24

### Commits

- #109: Move create-react-class to dependencies instead of devDependencies [`b738ff4`](https://github.com/leandrowd/react-responsive-carousel/commit/b738ff4794a157b6090ec869b3dc1a5b11cbebd9)

## [v3.1.9](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.8...v3.1.9) - 2017-04-24

### Commits

- #98: Allow carousel slides to be lazy loaded [`aa7df89`](https://github.com/leandrowd/react-responsive-carousel/commit/aa7df89a12efc2e65611f485627bccf1b4f6ae9f)

## [v3.1.8](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.7...v3.1.8) - 2017-04-24

### Commits

- Adding changelog [`76c7822`](https://github.com/leandrowd/react-responsive-carousel/commit/76c782261ffda411a289d1c9a3db8804e0375424)
- Updating react and tests [`41d1199`](https://github.com/leandrowd/react-responsive-carousel/commit/41d11993b73e867938da71567fb558aeb57d9f1f)
- Simplify demos [`a019726`](https://github.com/leandrowd/react-responsive-carousel/commit/a01972652b165e6c0cef9f822aa13b31c7fc42ea)

## [v3.1.7](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.6...v3.1.7) - 2017-04-23

### Fixed

- Fix #102 [`#102`](https://github.com/leandrowd/react-responsive-carousel/issues/102)

### Commits

- #104 - Fixes problem where arrows were not appearing after carousel was loaded [`b7b10f3`](https://github.com/leandrowd/react-responsive-carousel/commit/b7b10f328d8dc715e8613c429b9b3a82e9825bc5)

## [v3.1.6](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.5...v3.1.6) - 2017-04-19

### Commits

- #99: Fixing bug with infinite loop and showArrows=false [`eef9597`](https://github.com/leandrowd/react-responsive-carousel/commit/eef9597936609cb13dab8d29edf798e070980fab)
- #99: Removing node 4 for incompatibility problems with yarn [`81b154c`](https://github.com/leandrowd/react-responsive-carousel/commit/81b154c7157edfab9f6cd036c1bbc5b2fc11d5ad)

## [v3.1.5](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.4...v3.1.5) - 2017-03-26

### Commits

- #63: Stoping autoplay on touch events or manual actions [`c5c5c0b`](https://github.com/leandrowd/react-responsive-carousel/commit/c5c5c0b6ef77e38222b5219c473181bb22ee4f8f)

## [v3.1.4](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.3...v3.1.4) - 2017-03-26

### Commits

- #91: Removing check for has3d as all modern browsers support this capability [`105c45b`](https://github.com/leandrowd/react-responsive-carousel/commit/105c45bc1c175c2557adee64f897e3ebea904f50)

## [v3.1.3](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.2...v3.1.3) - 2017-03-11

### Commits

- #71: Adding custom transition duration [`593d846`](https://github.com/leandrowd/react-responsive-carousel/commit/593d8465d0575ea30210a6863f1b87b6356f913c)
- Adding extra info [`0eb3902`](https://github.com/leandrowd/react-responsive-carousel/commit/0eb39026d59a3132128a701d8ac8c41dbfe61163)

## [v3.1.2](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.1...v3.1.2) - 2017-02-26

### Commits

- #86: Removing unnecessary has3d check [`3d449d2`](https://github.com/leandrowd/react-responsive-carousel/commit/3d449d27c3521655edd041e864262da4af52f65c)

## [v3.1.1](https://github.com/leandrowd/react-responsive-carousel/compare/v3.1.0...v3.1.1) - 2017-02-26

### Commits

- #85: Moving event binding to componentDidMount to fix SSR [`1efa37b`](https://github.com/leandrowd/react-responsive-carousel/commit/1efa37be1aa3869b07dd43371739b0aabaca4a03)

## [v3.1.0](https://github.com/leandrowd/react-responsive-carousel/compare/v3.0.23...v3.1.0) - 2017-02-10

## [v3.0.23](https://github.com/leandrowd/react-responsive-carousel/compare/v3.0.22...v3.0.23) - 2017-02-10

### Commits

- #81: Adding support to mouse swipe: [`2829f4b`](https://github.com/leandrowd/react-responsive-carousel/commit/2829f4b136fa944ffb8f30474539d77b9a39b8cd)

## [v3.0.22](https://github.com/leandrowd/react-responsive-carousel/compare/v3.0.21...v3.0.22) - 2017-01-29

### Commits

- Fixing issue #70 - Adding dynamicHeight prop to adjust when required [`77b1eeb`](https://github.com/leandrowd/react-responsive-carousel/commit/77b1eeba376fc976a8fc0721a991fcbaf7eb5711)
- Fixing issue #72 - changes to autoplay property in runtime wouldn't apply [`4d42076`](https://github.com/leandrowd/react-responsive-carousel/commit/4d4207631c69ec1cb87e40e2088db65d5be15c1e)
- Removing properties from html as it was outdated [`80ad1ac`](https://github.com/leandrowd/react-responsive-carousel/commit/80ad1ac66d6e334487f61ce30d2224c4d8a00521)

## [v3.0.21](https://github.com/leandrowd/react-responsive-carousel/compare/v3.0.20...v3.0.21) - 2016-09-26

## [v3.0.20](https://github.com/leandrowd/react-responsive-carousel/compare/v3.0.19...v3.0.20) - 2016-09-25

### Commits

- Refactoring tests to use es6 features [`5cc8ac2`](https://github.com/leandrowd/react-responsive-carousel/commit/5cc8ac255e5ff934f7a96041bf07de9ba14a454e)
- Adding tests for auto play [`0d30188`](https://github.com/leandrowd/react-responsive-carousel/commit/0d30188748600816fb9eaff42b10aa4099041cd4)
- Adding tolerance for swipe scroll behaviour [`55c0e5c`](https://github.com/leandrowd/react-responsive-carousel/commit/55c0e5c29924f78b702b714a9c0ec116d35526e4)

## [v3.0.19](https://github.com/leandrowd/react-responsive-carousel/compare/v3.0.18...v3.0.19) - 2016-09-24

### Commits

- Adding support to auto play [`b40643d`](https://github.com/leandrowd/react-responsive-carousel/commit/b40643d883aa4785fd4cbe31d646e6d824c29ff8)
- Updating react-easy-swipe [`732d3de`](https://github.com/leandrowd/react-responsive-carousel/commit/732d3de5535047727e82c502399a83d85f0a810c)

## [v3.0.18](https://github.com/leandrowd/react-responsive-carousel/compare/v3.0.17...v3.0.18) - 2016-09-16

### Commits

- Adding more tests for Carousel [`087a6d6`](https://github.com/leandrowd/react-responsive-carousel/commit/087a6d6b99d4bf4271492753d50a9f7a8141f58d)
- Comment tests [`80a2dfa`](https://github.com/leandrowd/react-responsive-carousel/commit/80a2dfa651a03f946ac5efe019d06b416a3ac721)
- Add build files [`d4af717`](https://github.com/leandrowd/react-responsive-carousel/commit/d4af717cee3e225ffc86e9b2ddd5bfdc0a3f43b3)

## [v3.0.17](https://github.com/leandrowd/react-responsive-carousel/compare/v3.0.16...v3.0.17) - 2016-09-14

### Commits

- Deploying storybook demos [`5d8e841`](https://github.com/leandrowd/react-responsive-carousel/commit/5d8e84173761bcfe2fc74f45d0c4a71bc8a1d5f8)
- Adding example with videos [`a046c27`](https://github.com/leandrowd/react-responsive-carousel/commit/a046c27c330ce3f319727a6c0be6ae86473acea3)
- Replacing the deprecated package reactify with babelify [`62ad401`](https://github.com/leandrowd/react-responsive-carousel/commit/62ad401d99c9ed37864b4a638372447cf22625aa)

## [v3.0.16](https://github.com/leandrowd/react-responsive-carousel/compare/v3.0.15...v3.0.16) - 2016-09-10

### Commits

- Adding presentation mode [`38139e7`](https://github.com/leandrowd/react-responsive-carousel/commit/38139e7a9906680cc4de04aa5d0f2d22aae595e0)
- Updating editor config properties and reformatting files [`3713d68`](https://github.com/leandrowd/react-responsive-carousel/commit/3713d68f1fc5d4af66469d5d66a18d28a0fd6616)
- Replacing icons by pure css arrows [`48290ec`](https://github.com/leandrowd/react-responsive-carousel/commit/48290ec2e7913b85170cf6ea0959c61497289c40)

## [v3.0.15](https://github.com/leandrowd/react-responsive-carousel/compare/v3.0.14...v3.0.15) - 2016-09-07

### Commits

- Updating package task to include the fonts [`f10a739`](https://github.com/leandrowd/react-responsive-carousel/commit/f10a739e081e83275b362a1e60f5e729a8403742)
- Updating docs with example [`6feaeb4`](https://github.com/leandrowd/react-responsive-carousel/commit/6feaeb40b520e830f04b060262f509ac8feee53e)
- Removing release branch from publish step [`c10616d`](https://github.com/leandrowd/react-responsive-carousel/commit/c10616de82c8f7cef760f325c39737e11994010b)

## [v3.0.14](https://github.com/leandrowd/react-responsive-carousel/compare/v3.0.13...v3.0.14) - 2016-09-07

### Commits

- Fixing gh-pages task [`5da8b4d`](https://github.com/leandrowd/react-responsive-carousel/commit/5da8b4ddbfab6dbf079350b9ad6aaf07001d871d)
- Adding editorConfig [`0f95c6f`](https://github.com/leandrowd/react-responsive-carousel/commit/0f95c6f2206e12e81c65b07616168a729a0d85ab)
- Updated gulp-uglify, gulp-streamify, gulp-notify, gulp-if, gulp-connect [`886641d`](https://github.com/leandrowd/react-responsive-carousel/commit/886641d4d766c98b4651d18790a0706641f31193)

## [v3.0.13](https://github.com/leandrowd/react-responsive-carousel/compare/v1.0.2...v3.0.13) - 2016-08-27

### Commits

- Updating dependencies and tasks: [`7fd718c`](https://github.com/leandrowd/react-responsive-carousel/commit/7fd718cd73624aac21fc6ea796761530f2cebd28)
- Removing dev folder [`df709f9`](https://github.com/leandrowd/react-responsive-carousel/commit/df709f93ff096a9a46ff634527d7bb8bb6d49455)
- Adding copy task to generate all the assets in dev folder [`ec2227a`](https://github.com/leandrowd/react-responsive-carousel/commit/ec2227ad75880c989181cffc166b9cbafb28d365)

## [3.0.9](https://github.com/leandrowd/react-responsive-carousel/compare/3.0.7...3.0.9) - 2016-01-19

### Commits

- Fixing vertical carousel size [`4a90da2`](https://github.com/leandrowd/react-responsive-carousel/commit/4a90da2a8c75b7109e8672ef7ab0cbf96da41a68)
- Fixing propTypes typo (was propsTypes) [`dad89b6`](https://github.com/leandrowd/react-responsive-carousel/commit/dad89b6f539648c8611c4c20ac384febc89eed96)
- Publishing to npm [`edc64f2`](https://github.com/leandrowd/react-responsive-carousel/commit/edc64f2c6624101c4e8317cf589837c361b339e9)

## [3.0.7](https://github.com/leandrowd/react-responsive-carousel/compare/v1.0.1...3.0.7) - 2016-01-15

### Commits

- Updating readme [`c5c72b9`](https://github.com/leandrowd/react-responsive-carousel/commit/c5c72b981713c68f8b13e140e16b50dc1af47b8d)
- Server rendering in strict mode can't find window [`2902cb1`](https://github.com/leandrowd/react-responsive-carousel/commit/2902cb1f99a0eeef106d5ae5ab1c1fb18619e477)
- Updating npm package [`621a207`](https://github.com/leandrowd/react-responsive-carousel/commit/621a207a29721d19fe9e760cf8238e662d3aae4a)

## [3.0.4](https://github.com/leandrowd/react-responsive-carousel/compare/3.0.2...3.0.4) - 2016-01-07

### Commits

- Adding CNAME [`26eb839`](https://github.com/leandrowd/react-responsive-carousel/commit/26eb8394eb09a82db61c7ddb9830beab651e1b66)
- Bumping versions [`51caa42`](https://github.com/leandrowd/react-responsive-carousel/commit/51caa4252adc2f232c74d06c48bf71eaeb81bd75)

## [3.0.2](https://github.com/leandrowd/react-responsive-carousel/compare/v1.0.0...3.0.2) - 2016-01-07

### Commits

- Updating npm package docs [`76aa2e7`](https://github.com/leandrowd/react-responsive-carousel/commit/76aa2e72b5b4dee56f75da3fda02d58bb0eec9c5)
- Updating dist files [`b1c2fd8`](https://github.com/leandrowd/react-responsive-carousel/commit/b1c2fd80e4d2a65eab4bfac44282df3ad26633fe)
- Releasing new npm package [`6637e47`](https://github.com/leandrowd/react-responsive-carousel/commit/6637e47eb0dfde970b22e1703ae37b53d973e9ec)

## [2.0.2](https://github.com/leandrowd/react-responsive-carousel/compare/2.0.1...2.0.2) - 2015-11-26

### Commits

- Issue #19 - fixing undef position [`4e7602e`](https://github.com/leandrowd/react-responsive-carousel/commit/4e7602e65ce742544c0979889dab6a1d395dc008)
- issue #17 - Calling onChange when selecting through the controls [`10470fe`](https://github.com/leandrowd/react-responsive-carousel/commit/10470fe533e4cabf908acf95d5ccf9bc585b486c)

## [2.0.1](https://github.com/leandrowd/react-responsive-carousel/compare/2.0.0...2.0.1) - 2015-11-21

### Commits

- #17 - Calling onChange when selecting through the controls [`0d2368f`](https://github.com/leandrowd/react-responsive-carousel/commit/0d2368fb3b1579a457225121a2fb7c11aefb46cf)

## [2.0.0](https://github.com/leandrowd/react-responsive-carousel/compare/0.1.6...2.0.0) - 2015-11-21

### Commits

- Updating react to 0.14 and fixing all the warnings [`87fe13d`](https://github.com/leandrowd/react-responsive-carousel/commit/87fe13db8f3e71b073dbc0269165d06cbf0f2d08)
- Fixing dependencies and preparing package for distribution [`2377fde`](https://github.com/leandrowd/react-responsive-carousel/commit/2377fded11f9a301f03f8884a7374f3132b18a0b)
- Updating docs [`68ab271`](https://github.com/leandrowd/react-responsive-carousel/commit/68ab27107d8bec25b1745fc4f04588b66fa96235)

## [v1.0.2](https://github.com/leandrowd/react-responsive-carousel/compare/3.0.9...v1.0.2) - 2016-03-17

### Commits

- Publishig to npm [`2d40b85`](https://github.com/leandrowd/react-responsive-carousel/commit/2d40b85593f0cb2d4397b973ae842fc15cd25608)
- Updating dependencies [`73cd874`](https://github.com/leandrowd/react-responsive-carousel/commit/73cd874239f165d29363bfde29ed943c5b8af990)
- Specify version of node to run app [`8a4c519`](https://github.com/leandrowd/react-responsive-carousel/commit/8a4c519708a8478e39dccbe3e6a8936813e2c37c)

## [v1.0.1](https://github.com/leandrowd/react-responsive-carousel/compare/3.0.4...v1.0.1) - 2016-01-13

### Commits

- Removing unneded file [`9d7f7cb`](https://github.com/leandrowd/react-responsive-carousel/commit/9d7f7cbf93abbd3cee691380a6365e684c45c523)
- Adding missing dependency [`bb2e2fb`](https://github.com/leandrowd/react-responsive-carousel/commit/bb2e2fbaa5f794855c24e55671e7cbcac24da142)

## [v1.0.0](https://github.com/leandrowd/react-responsive-carousel/compare/2.0.2...v1.0.0) - 2016-01-07

### Commits

- Replacing refs [`cfa023e`](https://github.com/leandrowd/react-responsive-carousel/commit/cfa023eea5038d38b466ab9db525d31a01c0e736)
- Adding CNAME for js.org [`59e81c2`](https://github.com/leandrowd/react-responsive-carousel/commit/59e81c24f819dbb808c6693d6c62631aaa225fb2)
- Cleaning-up the mess [`3fdaf10`](https://github.com/leandrowd/react-responsive-carousel/commit/3fdaf10c9c5c69d7bff21fbe3593dfaabc93351c)

## [0.1.6](https://github.com/leandrowd/react-responsive-carousel/compare/0.1.1...0.1.6) - 2015-08-08

### Commits

- update demo page with gulp [`fb450aa`](https://github.com/leandrowd/react-responsive-carousel/commit/fb450aaa4626615f4cb03bbc488a4a591f408360)
- Merging PR and publishing npm package [`748b878`](https://github.com/leandrowd/react-responsive-carousel/commit/748b8784e0863cc572c275fedcf195023e50bc5c)
- fix default selected class [`8021573`](https://github.com/leandrowd/react-responsive-carousel/commit/80215733b0a663af5898c7882761331f32be178a)

## [0.1.1](https://github.com/leandrowd/react-responsive-carousel/compare/0.1.0...0.1.1) - 2015-05-17

### Commits

- Updating to react 0.13.3 [`5726925`](https://github.com/leandrowd/react-responsive-carousel/commit/5726925e8f9157be06a53f53285208e8a6703b31)
- Generating version 0.1.1 for NPN [`72fc98a`](https://github.com/leandrowd/react-responsive-carousel/commit/72fc98aa6af06ee98907029e45a9016e1f04a026)

## [0.1.0](https://github.com/leandrowd/react-responsive-carousel/compare/0.0.11...0.1.0) - 2015-03-11

### Commits

- New version without touch lib [`5d7f735`](https://github.com/leandrowd/react-responsive-carousel/commit/5d7f7359c4b98773bbf8c544d6c3d2cd19b0e4f9)
- Clean up [`4914ea8`](https://github.com/leandrowd/react-responsive-carousel/commit/4914ea8f9f0d1d11d2ba212c930cb5f7f63b8713)
- Adding styles to the package [`1a487cd`](https://github.com/leandrowd/react-responsive-carousel/commit/1a487cd23a37dc483dab5be588f9f08c9761f376)

## [0.0.11](https://github.com/leandrowd/react-responsive-carousel/compare/0.0.9...0.0.11) - 2015-02-10

### Commits

- Fixing tests, adding more infos to README.md and removing unnecessary files [`1363c42`](https://github.com/leandrowd/react-responsive-carousel/commit/1363c429ecfd13730318925a38507fbb52c4a448)
- Fixing require rule on README.md and publishing [`d2c44b2`](https://github.com/leandrowd/react-responsive-carousel/commit/d2c44b2d63032a4daa69d3addec11e7585d23d08)
- Adding README.md to npm [`966d949`](https://github.com/leandrowd/react-responsive-carousel/commit/966d9492b28e3211705637b2a0321b9d9b8fab41)

## 0.0.9 - 2015-02-09

### Commits

- Updating infos [`f730af8`](https://github.com/leandrowd/react-responsive-carousel/commit/f730af855e6ad942b88c94fda47fdb5a9317168c)
- Publishing npm module: [`0630739`](https://github.com/leandrowd/react-responsive-carousel/commit/06307390a637d925131edf97d03876f0805b26b6)
- Fixing package for distribuion [`cb9fac8`](https://github.com/leandrowd/react-responsive-carousel/commit/cb9fac82f812048e40916ddd4decf276478d8fa2)
- Generating dist version [`04055a3`](https://github.com/leandrowd/react-responsive-carousel/commit/04055a3248c7241d6082d4b470d26ea73e8fbf0b)
- Adding README.md [`292ca5d`](https://github.com/leandrowd/react-responsive-carousel/commit/292ca5dd6dd60197f2c08499d9e34c4fada36c7f)
- Adding better transitions [`48ebe3c`](https://github.com/leandrowd/react-responsive-carousel/commit/48ebe3c72cef1cdcff7b275257fc3c54afb19e21)
- Removing swipe component and add behaviour through another lib [`8fe3efd`](https://github.com/leandrowd/react-responsive-carousel/commit/8fe3efdcd811cf464efab7420ffe85f41f1ef3c3)
- ADding docs [`06d93db`](https://github.com/leandrowd/react-responsive-carousel/commit/06d93db04bd838f53372e2a5aa4df0004050d430)
- First commit [`272de1d`](https://github.com/leandrowd/react-responsive-carousel/commit/272de1d4ea25d4c64cf9a11f3d49a9ab0daa90cf)
