# Contributing

Found a bug? Want a new feature? Don't like the docs? Please send a pull request or raise an issue. 


## Creating Pull Requests

Pull requests are always welcome. In order to send a Pull Request, you will need to setup your environment;

Fork and clone the repo:
- `git clone git@github.com:leandrowd/react-responsive-carousel.git`

Install dependencies:
- `npm install`

Start the dev server:
- `npm start`

Open your favourite browser on `localhost:8000` - livereload will be enabled and tests will run on each change.

### Guidelines
- Make sure your editor supports [editorConfig](http://editorconfig.org/) so the code formatting is consistent;
- Add a descriptive commit message;
- Add tests to cover your changes;
- If needed, add a story (storybook);
- DO NOT change files in the /lib folder;


## Raising issues
When raising an issue, please add as much details as possible. Screenshots, video recordings, or anything else that can make it easier to reproduce the bug you are reporting.

* A new option is to create a code pen with the code that causes the bug. Fork this [example](https://www.webpackbin.com/bins/-Kxr6IEf5zXSQvGCgKBR) and add your code there, then fork and add the new link to the issue.

