'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var _getFormData = require('get-form-data');

var _getFormData2 = _interopRequireDefault(_getFormData);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

/**
 * <Form> components are used to create a <form> element that submits its input
 * data to a route.
 *
 * For example, assuming you have the following route:
 *
 *   <Route path="/topics/:topicId/add-post" onEnter={handleAddPost}/>
 *
 * You could use the following component to submit a form's input data to that
 * route as location state:
 *
 *   <Form to={`/topics/${topicId}/add-post`} method="POST">
 */
var Form = _react2['default'].createClass({
  displayName: 'Form',

  contextTypes: {
    history: _react2['default'].PropTypes.object
  },

  propTypes: {
    component: _react2['default'].PropTypes.any,
    dataKey: _react2['default'].PropTypes.string,
    extractFormData: _react2['default'].PropTypes.func,
    methodKey: _react2['default'].PropTypes.string,
    onSubmit: _react2['default'].PropTypes.func,
    query: _react2['default'].PropTypes.object,
    state: _react2['default'].PropTypes.object,
    to: _react2['default'].PropTypes.string.isRequired
  },

  getDefaultProps: function getDefaultProps() {
    return {
      component: 'form',
      dataKey: 'body',
      extractFormData: _getFormData2['default'],
      method: 'GET',
      methodKey: 'method'
    };
  },

  handleSubmit: function handleSubmit(event) {
    var formData = this.props.extractFormData(event.target);
    var allowTransition = true;
    var submitResult = undefined;

    if (this.props.onSubmit) {
      submitResult = this.props.onSubmit(event, formData);
    }

    if (submitResult === false || event.defaultPrevented === true) {
      allowTransition = false;
    }

    event.preventDefault();

    if (allowTransition) {
      var _props = this.props;
      var dataKey = _props.dataKey;
      var method = _props.method;
      var methodKey = _props.methodKey;
      var query = _props.query;
      var state = _props.state;
      var to = _props.to;

      if (method === 'GET') {
        // GET submissions use the query string, so just merge form data into it
        query = _extends({}, query || {}, formData);
      } else {
        var _extends2;

        state = _extends({}, state, (_extends2 = {}, _defineProperty(_extends2, methodKey, method), _defineProperty(_extends2, dataKey, formData), _extends2));
      }
      this.context.history.pushState(state, to, query);
    }
  },

  render: function render() {
    var _props2 = this.props;
    var component = _props2.component;
    var dataKey = _props2.dataKey;
    var extractFormData = _props2.extractFormData;
    var methodKey = _props2.methodKey;
    var onSubmit = _props2.onSubmit;
    var query = _props2.query;
    var state = _props2.state;
    var to = _props2.to;

    var props = _objectWithoutProperties(_props2, ['component', 'dataKey', 'extractFormData', 'methodKey', 'onSubmit', 'query', 'state', 'to']);

    var history = this.context.history;

    props.onSubmit = this.handleSubmit;

    if (history) {
      props.action = history.createHref(to, query);
    }

    return _react2['default'].createElement(this.props.component, props);
  }
});

exports['default'] = Form;
module.exports = exports['default'];