'use strict';

exports.__esModule = true;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Broadcasts = require('./Broadcasts');

var _PropTypes = require('./PropTypes');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Link = function (_React$Component) {
  _inherits(Link, _React$Component);

  function Link() {
    var _temp, _this, _ret;

    _classCallCheck(this, Link);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, _React$Component.call.apply(_React$Component, [this].concat(args))), _this), _this.handleClick = function (event) {
      if (_this.props.onClick) _this.props.onClick(event);

      if (!event.defaultPrevented && // onClick prevented default
      !_this.props.target && // let browser handle "target=_blank" etc.
      !isModifiedEvent(event) && isLeftClickEvent(event)) {
        event.preventDefault();
        _this.handleTransition();
      }
    }, _this.handleTransition = function () {
      var router = _this.context.router;
      var _this$props = _this.props,
          to = _this$props.to,
          replace = _this$props.replace;

      var navigate = replace ? router.replaceWith : router.transitionTo;
      navigate(to);
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  Link.prototype.render = function render() {
    var _this2 = this;

    var router = this.context.router;

    var _props = this.props,
        to = _props.to,
        style = _props.style,
        activeStyle = _props.activeStyle,
        className = _props.className,
        activeClassName = _props.activeClassName,
        getIsActive = _props.isActive,
        activeOnlyWhenExact = _props.activeOnlyWhenExact,
        replace = _props.replace,
        children = _props.children,
        rest = _objectWithoutProperties(_props, ['to', 'style', 'activeStyle', 'className', 'activeClassName', 'isActive', 'activeOnlyWhenExact', 'replace', 'children']);

    return _react2.default.createElement(
      _Broadcasts.LocationSubscriber,
      null,
      function (location) {
        var isActive = getIsActive(location, createLocationDescriptor(to), _this2.props);

        // If children is a function, we are using a Function as Children Component
        // so useful values will be passed down to the children function.
        if (typeof children == 'function') {
          return children({
            isActive: isActive,
            location: location,
            href: router ? router.createHref(to) : to,
            onClick: _this2.handleClick,
            transition: _this2.handleTransition
          });
        }

        // Maybe we should use <Match> here? Not sure how the custom `isActive`
        // prop would shake out, also, this check happens a LOT so maybe its good
        // to optimize here w/ a faster isActive check, so we'd need to benchmark
        // any attempt at changing to use <Match>
        return _react2.default.createElement('a', _extends({}, rest, {
          href: router ? router.createHref(to) : to,
          onClick: _this2.handleClick,
          style: isActive ? _extends({}, style, activeStyle) : style,
          className: isActive ? [className, activeClassName].join(' ').trim() : className,
          children: children
        }));
      }
    );
  };

  return Link;
}(_react2.default.Component);

Link.defaultProps = {
  replace: false,
  activeOnlyWhenExact: false,
  className: '',
  activeClassName: '',
  style: {},
  activeStyle: {},
  isActive: function isActive(location, to, props) {
    return pathIsActive(to.pathname, location.pathname, props.activeOnlyWhenExact) && queryIsActive(to.query, location.query);
  }
};
Link.contextTypes = {
  router: _PropTypes.routerContext.isRequired
};


if (process.env.NODE_ENV !== 'production') {
  Link.propTypes = {
    to: _react.PropTypes.oneOfType([_react.PropTypes.string, _react.PropTypes.object]).isRequired,
    replace: _react.PropTypes.bool,
    activeStyle: _react.PropTypes.object,
    activeClassName: _react.PropTypes.string,
    activeOnlyWhenExact: _react.PropTypes.bool,
    isActive: _react.PropTypes.func,
    children: _react.PropTypes.oneOfType([_react.PropTypes.node, _react.PropTypes.func]),

    // props we have to deal with but aren't necessarily
    // part of the Link API
    style: _react.PropTypes.object,
    className: _react.PropTypes.string,
    target: _react.PropTypes.string,
    onClick: _react.PropTypes.func
  };
}

// we should probably use LocationUtils.createLocationDescriptor
var createLocationDescriptor = function createLocationDescriptor(to) {
  return (typeof to === 'undefined' ? 'undefined' : _typeof(to)) === 'object' ? to : { pathname: to };
};

var pathIsActive = function pathIsActive(to, pathname, activeOnlyWhenExact) {
  return activeOnlyWhenExact ? pathname === to : pathname.indexOf(to) === 0;
};

var queryIsActive = function queryIsActive(query, activeQuery) {
  if (activeQuery == null) return query == null;

  if (query == null) return true;

  return deepEqual(query, activeQuery);
};

var isLeftClickEvent = function isLeftClickEvent(event) {
  return event.button === 0;
};

var isModifiedEvent = function isModifiedEvent(event) {
  return !!(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey);
};

var deepEqual = function deepEqual(a, b) {
  if (a == b) return true;

  if (a == null || b == null) return false;

  if (Array.isArray(a)) {
    return Array.isArray(b) && a.length === b.length && a.every(function (item, index) {
      return deepEqual(item, b[index]);
    });
  }

  if ((typeof a === 'undefined' ? 'undefined' : _typeof(a)) === 'object') {
    for (var p in a) {
      if (!Object.prototype.hasOwnProperty.call(a, p)) {
        continue;
      }

      if (a[p] === undefined) {
        if (b[p] !== undefined) {
          return false;
        }
      } else if (!Object.prototype.hasOwnProperty.call(b, p)) {
        return false;
      } else if (!deepEqual(a[p], b[p])) {
        return false;
      }
    }

    return true;
  }

  return String(a) === String(b);
};

exports.default = Link;