'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _warning = require('warning');

var _warning2 = _interopRequireDefault(_warning);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _matchPath = require('./matchPath');

var _matchPath2 = _interopRequireDefault(_matchPath);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var computeMatch = function computeMatch(router, _ref) {
  var computedMatch = _ref.computedMatch,
      path = _ref.path,
      exact = _ref.exact,
      strict = _ref.strict;
  return computedMatch || (0, _matchPath2.default)(router.location.pathname, path, { exact: exact, strict: strict });
};

/**
 * The public API for matching a single path and rendering.
 */

var Route = function (_React$Component) {
  _inherits(Route, _React$Component);

  function Route() {
    _classCallCheck(this, Route);

    return _possibleConstructorReturn(this, _React$Component.apply(this, arguments));
  }

  /**
   * Low-level public API for rendering using the various "render props"
   * provided to a <Route>. This is mainly useful when wrapping <Route>s.
   */
  Route.prototype.getChildContext = function getChildContext() {
    return {
      router: this.router
    };
  };

  Route.prototype.componentWillMount = function componentWillMount() {
    var _this2 = this;

    var parentRouter = this.context.router;

    this.router = _extends({}, parentRouter, {
      match: computeMatch(parentRouter, this.props)
    });

    // Start listening here so we can <Redirect> on the initial render.
    this.unlisten = parentRouter.listen(function () {
      _extends(_this2.router, parentRouter, {
        match: computeMatch(parentRouter, _this2.props)
      });

      _this2.forceUpdate();
    });
  };

  Route.prototype.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
    _extends(this.router, {
      match: computeMatch(this.router, nextProps)
    });
  };

  Route.prototype.componentWillUnmount = function componentWillUnmount() {
    this.unlisten();
  };

  Route.prototype.render = function render() {
    return Route.render(_extends({}, this.props, this.router));
  };

  return Route;
}(_react2.default.Component);

Route.render = function (props) {
  // TODO: eslint-plugin-react thinks this is a missing propType. File a bug.
  var component = props.component,
      render = props.render,
      match = props.match; // eslint-disable-line react/prop-types

  var children = props.children; // eslint-disable-line react/prop-types

  if (Array.isArray(children) && !children.length) children = null;

  (0, _warning2.default)(!(component && render), 'You should not use <Route component> and <Route render> in the same route; <Route render> will be ignored');

  (0, _warning2.default)(!(component && children), 'You should not use <Route component> and <Route children> in the same route; <Route children> will be ignored');

  (0, _warning2.default)(!(render && children), 'You should not use <Route render> and <Route children> in the same route; <Route children> will be ignored');

  return component ? // component prop gets first priority, only called if there's a match
  match ? _react2.default.createElement(component, props) : null : render ? // render prop is next, only called if there's a match
  match ? render(props) : null : children ? // children come last, always called
  typeof children === 'function' ? children(props) : _react2.default.Children.only(children) : null;
};

Route.contextTypes = {
  router: _react.PropTypes.shape({
    listen: _react.PropTypes.func.isRequired
  }).isRequired
};
Route.propTypes = {
  computedMatch: _react.PropTypes.object, // private, from <Switch>
  path: _react.PropTypes.string,
  exact: _react.PropTypes.bool,
  strict: _react.PropTypes.bool,
  component: _react.PropTypes.func,
  render: _react.PropTypes.func,
  children: _react.PropTypes.oneOfType([_react.PropTypes.func, _react.PropTypes.node])
};
Route.childContextTypes = {
  router: _react.PropTypes.object.isRequired
};
exports.default = Route;