function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import React, { PropTypes } from 'react';

/**
 * The public API for updating the location programatically
 * with a component.
 */

var Redirect = function (_React$Component) {
  _inherits(Redirect, _React$Component);

  function Redirect() {
    _classCallCheck(this, Redirect);

    return _possibleConstructorReturn(this, _React$Component.apply(this, arguments));
  }

  Redirect.prototype.componentWillMount = function componentWillMount() {
    if (this.context.router.staticContext) this.perform();
  };

  Redirect.prototype.componentDidMount = function componentDidMount() {
    if (!this.context.router.staticContext) this.perform();
  };

  Redirect.prototype.perform = function perform() {
    var router = this.context.router;
    var _props = this.props,
        push = _props.push,
        to = _props.to;


    if (push) {
      router.push(to);
    } else {
      router.replace(to);
    }
  };

  Redirect.prototype.render = function render() {
    return null;
  };

  return Redirect;
}(React.Component);

Redirect.contextTypes = {
  router: PropTypes.shape({
    push: PropTypes.func.isRequired,
    replace: PropTypes.func.isRequired,
    staticContext: PropTypes.object
  }).isRequired
};
Redirect.propTypes = {
  push: PropTypes.bool,
  to: PropTypes.oneOfType([PropTypes.string, PropTypes.object])
};
Redirect.defaultProps = {
  push: false
};


export default Redirect;