function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import React, { PropTypes } from 'react';
import matchPath from './matchPath';

/**
 * The public API for rendering the first <Route> that matches.
 */

var Switch = function (_React$Component) {
  _inherits(Switch, _React$Component);

  function Switch() {
    var _temp, _this, _ret;

    _classCallCheck(this, Switch);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, _React$Component.call.apply(_React$Component, [this].concat(args))), _this), _this.state = {
      location: null
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  Switch.prototype.componentWillMount = function componentWillMount() {
    var _this2 = this;

    var router = this.context.router;


    this.setState({
      location: router.location
    });

    // Start listening here so we can <Redirect> on the initial render.
    this.unlisten = router.listen(function () {
      _this2.setState({
        location: router.location
      });
    });
  };

  Switch.prototype.componentWillUnmount = function componentWillUnmount() {
    this.unlisten();
  };

  Switch.prototype.render = function render() {
    var children = this.props.children;
    var location = this.state.location;

    var routes = React.Children.toArray(children);

    var route = void 0,
        match = void 0;
    for (var i = 0, length = routes.length; match == null && i < length; ++i) {
      route = routes[i];
      match = matchPath(location.pathname, route.props.path, route.props);
    }

    return match ? React.cloneElement(route, { computedMatch: match }) : null;
  };

  return Switch;
}(React.Component);

Switch.contextTypes = {
  router: PropTypes.shape({
    listen: PropTypes.func.isRequired
  }).isRequired
};
Switch.propTypes = {
  children: PropTypes.node
};


export default Switch;