var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import React, { PropTypes } from 'react';

/**
 * A public higher-order component for re-rendering as the
 * location changes. Also, passes ...context.router as props.
 */
var withRouter = function withRouter(component) {
  var _class, _temp;

  return _temp = _class = function (_React$Component) {
    _inherits(_class, _React$Component);

    function _class() {
      _classCallCheck(this, _class);

      return _possibleConstructorReturn(this, _React$Component.apply(this, arguments));
    }

    _class.prototype.componentWillMount = function componentWillMount() {
      var _this2 = this;

      // Start listening here so we can <Redirect> on the initial render.
      this.unlisten = this.context.router.listen(function () {
        return _this2.forceUpdate();
      });
    };

    _class.prototype.componentWillUnmount = function componentWillUnmount() {
      this.unlisten();
    };

    _class.prototype.render = function render() {
      return React.createElement(component, _extends({}, this.props, this.context.router));
    };

    return _class;
  }(React.Component), _class.displayName = 'withRouter(' + (component.displayName || component.name) + ')', _class.contextTypes = {
    router: PropTypes.shape({
      listen: PropTypes.func.isRequired
    }).isRequired
  }, _temp;
};

export default withRouter;