'use strict';

exports.__esModule = true;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * The public API for updating the location programatically
 * with a component.
 */
var Redirect = function (_React$Component) {
  _inherits(Redirect, _React$Component);

  function Redirect() {
    _classCallCheck(this, Redirect);

    return _possibleConstructorReturn(this, _React$Component.apply(this, arguments));
  }

  Redirect.prototype.componentWillMount = function componentWillMount() {
    if (this.context.history.staticContext) this.perform();
  };

  Redirect.prototype.componentDidMount = function componentDidMount() {
    if (!this.context.history.staticContext) this.perform();
  };

  Redirect.prototype.perform = function perform() {
    var history = this.context.history;
    var _props = this.props,
        push = _props.push,
        to = _props.to;


    if (push) {
      history.push(to);
    } else {
      history.replace(to);
    }
  };

  Redirect.prototype.render = function render() {
    return null;
  };

  return Redirect;
}(_react2.default.Component);

Redirect.contextTypes = {
  history: _react.PropTypes.shape({
    push: _react.PropTypes.func.isRequired,
    replace: _react.PropTypes.func.isRequired,
    staticContext: _react.PropTypes.object
  }).isRequired
};
Redirect.propTypes = {
  push: _react.PropTypes.bool,
  to: _react.PropTypes.oneOfType([_react.PropTypes.string, _react.PropTypes.object])
};
Redirect.defaultProps = {
  push: false
};
exports.default = Redirect;