var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import React from "react";
import PropTypes from "prop-types";
import invariant from "invariant";
import RouterContext from "./RouterContext";

/**
 * The public API for prompting the user before navigating away
 * from a screen with a component.
 */

var InnerPrompt = function (_React$Component) {
  _inherits(InnerPrompt, _React$Component);

  function InnerPrompt() {
    _classCallCheck(this, InnerPrompt);

    return _possibleConstructorReturn(this, _React$Component.apply(this, arguments));
  }

  InnerPrompt.prototype.enable = function enable(message) {
    if (this.unblock) this.unblock();

    this.unblock = this.props.router.history.block(message);
  };

  InnerPrompt.prototype.disable = function disable() {
    if (this.unblock) {
      this.unblock();
      this.unblock = null;
    }
  };

  InnerPrompt.prototype.componentWillMount = function componentWillMount() {
    invariant(this.props.router, "You should not use <Prompt> outside a <Router>");

    if (this.props.when) this.enable(this.props.message);
  };

  InnerPrompt.prototype.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
    if (nextProps.when) {
      if (!this.props.when || this.props.message !== nextProps.message) this.enable(nextProps.message);
    } else {
      this.disable();
    }
  };

  InnerPrompt.prototype.componentWillUnmount = function componentWillUnmount() {
    this.disable();
  };

  InnerPrompt.prototype.render = function render() {
    return null;
  };

  return InnerPrompt;
}(React.Component);

InnerPrompt.propTypes = {
  when: PropTypes.bool,
  message: PropTypes.oneOfType([PropTypes.func, PropTypes.string]).isRequired,
  router: PropTypes.shape({
    history: PropTypes.shape({
      block: PropTypes.func.isRequired
    }).isRequired
  }).isRequired
};
InnerPrompt.defaultProps = {
  when: true
};


var Prompt = function Prompt(props) {
  return React.createElement(
    RouterContext.Consumer,
    null,
    function (_ref) {
      var router = _ref.router;
      return React.createElement(InnerPrompt, _extends({}, props, { router: router }));
    }
  );
};

export default Prompt;