var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import React from "react";
import PropTypes from "prop-types";
import warning from "warning";
import invariant from "invariant";
import { createLocation, locationsAreEqual } from "history";
import RouterContext from "./RouterContext";
import generatePath from "./generatePath";

/**
 * The public API for updating the location programmatically
 * with a component.
 */

var InnerRedirect = function (_React$Component) {
  _inherits(InnerRedirect, _React$Component);

  function InnerRedirect() {
    _classCallCheck(this, InnerRedirect);

    return _possibleConstructorReturn(this, _React$Component.apply(this, arguments));
  }

  InnerRedirect.prototype.isStatic = function isStatic() {
    return this.props.router && this.props.router.staticContext;
  };

  InnerRedirect.prototype.componentWillMount = function componentWillMount() {
    invariant(this.props.router, "You should not use <Redirect> outside a <Router>");

    if (this.isStatic()) this.perform();
  };

  InnerRedirect.prototype.componentDidMount = function componentDidMount() {
    if (!this.isStatic()) this.perform();
  };

  InnerRedirect.prototype.componentDidUpdate = function componentDidUpdate(prevProps) {
    var prevTo = createLocation(prevProps.to);
    var nextTo = createLocation(this.props.to);

    if (locationsAreEqual(prevTo, nextTo)) {
      warning(false, "You tried to redirect to the same route you're currently on: " + ("\"" + nextTo.pathname + nextTo.search + "\""));
      return;
    }

    this.perform();
  };

  InnerRedirect.prototype.computeTo = function computeTo(_ref) {
    var computedMatch = _ref.computedMatch,
        to = _ref.to;

    if (computedMatch) {
      if (typeof to === "string") {
        return generatePath(to, computedMatch.params);
      } else {
        return _extends({}, to, {
          pathname: generatePath(to.pathname, computedMatch.params)
        });
      }
    }

    return to;
  };

  InnerRedirect.prototype.perform = function perform() {
    var _props = this.props,
        push = _props.push,
        history = _props.router.history;

    var to = this.computeTo(this.props);

    if (push) {
      history.push(to);
    } else {
      history.replace(to);
    }
  };

  InnerRedirect.prototype.render = function render() {
    return null;
  };

  return InnerRedirect;
}(React.Component);

InnerRedirect.propTypes = {
  computedMatch: PropTypes.object, // private, from <Switch>
  push: PropTypes.bool,
  from: PropTypes.string,
  to: PropTypes.oneOfType([PropTypes.string, PropTypes.object]).isRequired,
  router: PropTypes.shape({
    history: PropTypes.shape({
      push: PropTypes.func.isRequired,
      replace: PropTypes.func.isRequired
    }).isRequired,
    staticContext: PropTypes.object
  }).isRequired
};
InnerRedirect.defaultProps = {
  push: false
};


var Redirect = function Redirect(props) {
  return React.createElement(
    RouterContext.Consumer,
    null,
    function (_ref2) {
      var router = _ref2.router;
      return React.createElement(InnerRedirect, _extends({}, props, { router: router }));
    }
  );
};

export default Redirect;