var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import warning from "warning";
import invariant from "invariant";
import React from "react";
import PropTypes from "prop-types";
import RouterContext from "./RouterContext";
import matchPath from "./matchPath";

var isEmptyChildren = function isEmptyChildren(children) {
  return React.Children.count(children) === 0;
};

/**
 * The public API for matching a single path and rendering.
 */

var InnerRoute = function (_React$Component) {
  _inherits(InnerRoute, _React$Component);

  function InnerRoute() {
    var _temp, _this, _ret;

    _classCallCheck(this, InnerRoute);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, _React$Component.call.apply(_React$Component, [this].concat(args))), _this), _this.state = {
      match: _this.computeMatch(_this.props)
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  InnerRoute.prototype.getChildContext = function getChildContext() {
    return {
      router: _extends({}, this.props.router, {
        route: {
          location: this.props.location || this.props.router.route.location,
          match: this.state.match
        }
      })
    };
  };

  InnerRoute.prototype.computeMatch = function computeMatch(_ref) {
    var computedMatch = _ref.computedMatch,
        router = _ref.router,
        location = _ref.location,
        path = _ref.path,
        strict = _ref.strict,
        exact = _ref.exact,
        sensitive = _ref.sensitive;

    if (computedMatch) return computedMatch; // <Switch> already computed the match for us

    invariant(router, "You should not use <Route> or withRouter() outside a <Router>");

    var route = router.route;

    var pathname = (location || route.location).pathname;

    return matchPath(pathname, { path: path, strict: strict, exact: exact, sensitive: sensitive }, route.match);
  };

  InnerRoute.prototype.componentWillMount = function componentWillMount() {
    warning(!(this.props.component && this.props.render), "You should not use <Route component> and <Route render> in the same route; <Route render> will be ignored");

    warning(!(this.props.component && this.props.children && !isEmptyChildren(this.props.children)), "You should not use <Route component> and <Route children> in the same route; <Route children> will be ignored");

    warning(!(this.props.render && this.props.children && !isEmptyChildren(this.props.children)), "You should not use <Route render> and <Route children> in the same route; <Route children> will be ignored");
  };

  InnerRoute.prototype.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
    warning(!(nextProps.location && !this.props.location), '<Route> elements should not change from uncontrolled to controlled (or vice versa). You initially used no "location" prop and then provided one on a subsequent render.');

    warning(!(!nextProps.location && this.props.location), '<Route> elements should not change from controlled to uncontrolled (or vice versa). You provided a "location" prop initially but omitted it on a subsequent render.');

    this.setState({
      match: this.computeMatch(nextProps)
    });
  };

  InnerRoute.prototype.renderChildren = function renderChildren() {
    var match = this.state.match;
    var _props = this.props,
        children = _props.children,
        component = _props.component,
        render = _props.render,
        _props$router = _props.router,
        history = _props$router.history,
        route = _props$router.route,
        staticContext = _props$router.staticContext;

    var location = this.props.location || route.location;
    var props = { match: match, location: location, history: history, staticContext: staticContext };

    if (component) return match ? React.createElement(component, props) : null;

    if (render) return match ? render(props) : null;

    if (typeof children === "function") return children(props);

    if (children && !isEmptyChildren(children)) return React.Children.only(children);

    return null;
  };

  InnerRoute.prototype.render = function render() {
    return React.createElement(
      RouterContext.Provider,
      { value: this.getChildContext() },
      this.renderChildren()
    );
  };

  return InnerRoute;
}(React.Component);

InnerRoute.propTypes = {
  computedMatch: PropTypes.object, // private, from <Switch>
  path: PropTypes.string,
  exact: PropTypes.bool,
  strict: PropTypes.bool,
  sensitive: PropTypes.bool,
  component: PropTypes.func,
  render: PropTypes.func,
  children: PropTypes.oneOfType([PropTypes.func, PropTypes.node]),
  location: PropTypes.object,
  router: PropTypes.shape({
    history: PropTypes.object.isRequired,
    route: PropTypes.object.isRequired,
    staticContext: PropTypes.object
  })
};
InnerRoute.childContextTypes = {
  router: PropTypes.object.isRequired
};


var Route = function Route(props) {
  return React.createElement(
    RouterContext.Consumer,
    null,
    function (_ref2) {
      var router = _ref2.router;
      return React.createElement(InnerRoute, _extends({}, props, { router: router }));
    }
  );
};

export default Route;