(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports);
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports);
        global.sAlertStore = mod.exports;
    }
})(this, function (exports) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    function _toConsumableArray(arr) {
        if (Array.isArray(arr)) {
            for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
                arr2[i] = arr[i];
            }

            return arr2;
        } else {
            return Array.from(arr);
        }
    }

    // custom simple store based on a awesome Redux library https://github.com/rackt/redux

    var createSAlertStore = function createSAlertStore(reducer) {
        var state = void 0;
        var listeners = [];
        var getState = function getState() {
            return state;
        };
        var dispatch = function dispatch(action) {
            state = reducer(state, action);
            listeners.forEach(function (listener) {
                return listener();
            });
        };
        var subscribe = function subscribe(listener) {
            listeners.push(listener);
            return function () {
                listeners = listeners.filter(function (l) {
                    return l !== listener;
                });
            };
        };
        dispatch({});
        return {
            getState: getState, dispatch: dispatch, subscribe: subscribe
        };
    };

    var insert = function insert(state, action) {
        return [].concat(_toConsumableArray(state), [action.data]);
    };

    var remove = function remove(state, action) {
        var elemToRemoveArray = state.slice().filter(function (item) {
            return item.id === action.data.id;
        });
        if (Array.isArray(elemToRemoveArray)) {
            var elemToRemoveIndex = state.indexOf(elemToRemoveArray[0]);
            return [].concat(_toConsumableArray(state.slice(0, elemToRemoveIndex)), _toConsumableArray(state.slice(elemToRemoveIndex + 1)));
        }
        return state;
    };

    var alertsReducer = function alertsReducer() {
        var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
        var action = arguments[1];

        switch (action.type) {
            case 'INSERT':
                return insert(state, action);
            case 'REMOVE':
                return remove(state, action);
            case 'REMOVEALL':
                return [];
            default:
                return state;
        }
    };

    var sAlertStore = createSAlertStore(alertsReducer);

    exports.default = sAlertStore;
});