'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = saveRefs;

var _memoize = require('lodash/memoize');

var _memoize2 = _interopRequireDefault(_memoize);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var saversByMap = new WeakMap();

function saveRefs(m, key) {
  var saver = saversByMap.get(m);
  if (!saver) {
    saver = (0, _memoize2.default)(function (key) {
      return function (el) {
        if (el) {
          m.set(key, el);
        } else {
          saver.cache.delete(key);
          m.delete(key);
        }
      };
    });
    saversByMap.set(m, saver);
  }
  return saver(key);
}
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9pbmRleC5qcyJdLCJuYW1lcyI6WyJzYXZlUmVmcyIsInNhdmVyc0J5TWFwIiwiV2Vha01hcCIsIm0iLCJrZXkiLCJzYXZlciIsImdldCIsImVsIiwic2V0IiwiY2FjaGUiLCJkZWxldGUiXSwibWFwcGluZ3MiOiI7Ozs7O2tCQVF3QkEsUTs7QUFOeEI7Ozs7OztBQUlBLElBQU1DLGNBQTZELElBQUlDLE9BQUosRUFBbkU7O0FBRWUsU0FBU0YsUUFBVCxDQUFrQkcsQ0FBbEIsRUFBc0NDLEdBQXRDLEVBQXVEO0FBQ3BFLE1BQUlDLFFBQVFKLFlBQVlLLEdBQVosQ0FBZ0JILENBQWhCLENBQVo7QUFDQSxNQUFJLENBQUNFLEtBQUwsRUFBWTtBQUNWQSxZQUFRLHVCQUFRO0FBQUEsYUFBTyxjQUFNO0FBQzNCLFlBQUlFLEVBQUosRUFBUTtBQUNOSixZQUFFSyxHQUFGLENBQU1KLEdBQU4sRUFBV0csRUFBWDtBQUNELFNBRkQsTUFFTztBQUNKRixlQUFELENBQVlJLEtBQVosQ0FBa0JDLE1BQWxCLENBQXlCTixHQUF6QjtBQUNBRCxZQUFFTyxNQUFGLENBQVNOLEdBQVQ7QUFDRDtBQUNGLE9BUGU7QUFBQSxLQUFSLENBQVI7QUFRQUgsZ0JBQVlPLEdBQVosQ0FBZ0JMLENBQWhCLEVBQW1CRSxLQUFuQjtBQUNEO0FBQ0QsU0FBT0EsTUFBTUQsR0FBTixDQUFQO0FBQ0QiLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VzQ29udGVudCI6WyIvKiBAZmxvdyAqL1xuXG5pbXBvcnQgbWVtb2l6ZSBmcm9tICdsb2Rhc2gvbWVtb2l6ZSc7XG5cbnR5cGUgUmVmRm4gPSAoZWw6ID9PYmplY3QpID0+IHZvaWQ7XG5cbmNvbnN0IHNhdmVyc0J5TWFwOiBXZWFrTWFwPE1hcDxhbnksT2JqZWN0PiwgKGtleTogYW55KSA9PiBSZWZGbj4gPSBuZXcgV2Vha01hcCgpO1xuXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBzYXZlUmVmcyhtOiBNYXA8YW55LE9iamVjdD4sIGtleTogYW55KTogUmVmRm4ge1xuICBsZXQgc2F2ZXIgPSBzYXZlcnNCeU1hcC5nZXQobSk7XG4gIGlmICghc2F2ZXIpIHtcbiAgICBzYXZlciA9IG1lbW9pemUoa2V5ID0+IGVsID0+IHtcbiAgICAgIGlmIChlbCkge1xuICAgICAgICBtLnNldChrZXksIGVsKTtcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIChzYXZlcjphbnkpLmNhY2hlLmRlbGV0ZShrZXkpO1xuICAgICAgICBtLmRlbGV0ZShrZXkpO1xuICAgICAgfVxuICAgIH0pO1xuICAgIHNhdmVyc0J5TWFwLnNldChtLCBzYXZlcik7XG4gIH1cbiAgcmV0dXJuIHNhdmVyKGtleSk7XG59XG4iXX0=