'use strict';

var _interopRequireWildcard = function (obj) { return obj && obj.__esModule ? obj : { 'default': obj }; };

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(object, property, receiver) { var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _inherits = function (subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; };

Object.defineProperty(exports, '__esModule', {
    value: true
});

var _React = require('react');

var _React2 = _interopRequireWildcard(_React);

var _Scrollbar = require('./scrollBar.js');

var _Scrollbar2 = _interopRequireWildcard(_Scrollbar);

//TODO: change to ./scrollBar.js

var ScrollArea = (function (_React$Component) {
    function ScrollArea(props) {
        _classCallCheck(this, ScrollArea);

        _get(Object.getPrototypeOf(ScrollArea.prototype), 'constructor', this).call(this, props);
        this.state = {
            topPosition: 0,
            leftPosition: 0,
            realHeight: 0,
            containerHeight: 0,
            realWidth: 0,
            containerWidth: 0,
            scrollableX: false,
            scrollableY: false
        };

        this.bindedHandleWindowResize = this.handleWindowResize.bind(this);
    }

    _inherits(ScrollArea, _React$Component);

    _createClass(ScrollArea, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            window.addEventListener('resize', this.bindedHandleWindowResize);
            this.setSizesToState();
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            window.removeEventListener('resize', this.bindedHandleWindowResize);
        }
    }, {
        key: 'componentDidUpdate',
        value: function componentDidUpdate() {
            this.setSizesToState();
        }
    }, {
        key: 'render',
        value: function render() {
            var style = {
                marginTop: this.state.topPosition,
                marginLeft: this.state.leftPosition
            };

            var scrollbarY = this.canScrollY() ? _React2['default'].createElement(_Scrollbar2['default'], {
                realSize: this.state.realHeight,
                containerSize: this.state.containerHeight,
                position: -this.state.topPosition,
                onMove: this.handleMove.bind(this),
                type: 'vertical' }) : null;

            var scrollbarX = this.canScrollX() ? _React2['default'].createElement(_Scrollbar2['default'], {
                realSize: this.state.realWidth,
                containerSize: this.state.containerWidth,
                position: -this.state.leftPosition,
                onMove: this.handleMove.bind(this),
                type: 'horizontal' }) : null;

            var classes = 'scrollarea ' + this.props.className;
            var contentClasses = 'scrollarea-content ' + this.props.contentClassName;
            return _React2['default'].createElement(
                'div',
                { className: classes, onWheel: this.handleWheel.bind(this) },
                _React2['default'].createElement(
                    'div',
                    { ref: 'content', style: style, className: contentClasses },
                    this.props.children
                ),
                scrollbarY,
                scrollbarX
            );
        }
    }, {
        key: 'handleMove',
        value: function handleMove(deltaY, deltaX) {
            var newState = this.computeSizes();
            if (this.canScrollY(newState)) {
                newState.topPosition = this.computeTopPosition(deltaY, newState);
            }
            if (this.canScrollX(newState)) {
                newState.leftPosition = this.computeLeftPosition(deltaX, newState);
            }
            this.setState(newState);
        }
    }, {
        key: 'handleWheel',
        value: function handleWheel(e) {
            var newState = this.computeSizes();
            var deltaY = e.deltaY * this.props.speed;
            var deltaX = e.deltaX * this.props.speed;

            if (this.canScrollY(newState)) {
                newState.topPosition = this.computeTopPosition(-deltaY, newState);
            }

            if (this.canScrollX(newState)) {
                newState.leftPosition = this.computeLeftPosition(-deltaX, newState);
            }

            if (this.state.topPosition !== newState.topPosition || this.state.leftPosition !== newState.leftPosition) {
                e.preventDefault();
            }

            this.setState(newState);
        }
    }, {
        key: 'computeTopPosition',
        value: function computeTopPosition(deltaY, sizes) {
            var newTopPosition = this.state.topPosition + deltaY;

            if (-newTopPosition > sizes.realHeight - sizes.containerHeight) {
                newTopPosition = -(sizes.realHeight - sizes.containerHeight);
            }
            if (newTopPosition > 0) {
                newTopPosition = 0;
            }
            return newTopPosition;
        }
    }, {
        key: 'computeLeftPosition',
        value: function computeLeftPosition(deltaX, sizes) {
            var newLeftPosition = this.state.leftPosition + deltaX;
            if (-newLeftPosition > sizes.realWidth - sizes.containerWidth) {
                newLeftPosition = -(sizes.realWidth - sizes.containerWidth);
            } else if (newLeftPosition > 0) {
                newLeftPosition = 0;
            }

            return newLeftPosition;
        }
    }, {
        key: 'handleWindowResize',
        value: function handleWindowResize() {
            var newState = this.computeSizes();
            var bottomPosition = newState.realHeight - newState.containerHeight;
            if (-this.state.topPosition >= bottomPosition) {
                newState.topPosition = this.canScrollY(newState) ? -bottomPosition : 0;
            }

            var rightPosition = newState.realWidth - newState.containerWidth;
            if (-this.state.leftPosition >= rightPosition) {
                newState.leftPosition = this.canScrollX(newState) ? -rightPosition : 0;
            }

            this.setState(newState);
        }
    }, {
        key: 'computeSizes',
        value: function computeSizes() {
            var realHeight = _React2['default'].findDOMNode(this.refs.content).offsetHeight;
            var containerHeight = _React2['default'].findDOMNode(this).offsetHeight;
            var realWidth = _React2['default'].findDOMNode(this.refs.content).offsetWidth;
            var containerWidth = _React2['default'].findDOMNode(this).offsetWidth;
            var scrollableY = realHeight > containerHeight || this.state.topPosition != 0;
            var scrollableX = realWidth > containerWidth || this.state.leftPosition != 0;

            return {
                realHeight: realHeight,
                containerHeight: containerHeight,
                realWidth: realWidth,
                containerWidth: containerWidth,
                scrollableX: scrollableX,
                scrollableY: scrollableY
            };
        }
    }, {
        key: 'setSizesToState',
        value: function setSizesToState() {
            var sizes = this.computeSizes();
            if (sizes.realHeight !== this.state.realHeight || sizes.realWidth !== this.state.realWidth) {
                this.setState(sizes);
            }
        }
    }, {
        key: 'scrollTop',
        value: function scrollTop() {
            this.setState({ topPosition: 0 });
        }
    }, {
        key: 'scrollBottom',
        value: function scrollBottom() {
            this.setState({ topPosition: -(this.state.realHeight - this.state.containerHeight) });
        }
    }, {
        key: 'canScrollY',
        value: function canScrollY() {
            var state = arguments[0] === undefined ? this.state : arguments[0];

            return state.scrollableY && this.props.vertical;
        }
    }, {
        key: 'canScrollX',
        value: function canScrollX() {
            var state = arguments[0] === undefined ? this.state : arguments[0];

            return state.scrollableX && this.props.horizontal;
        }
    }]);

    return ScrollArea;
})(_React2['default'].Component);

ScrollArea.propTypes = {
    className: _React2['default'].PropTypes.string,
    speed: _React2['default'].PropTypes.number,
    contentClassName: _React2['default'].PropTypes.string,
    vertical: _React2['default'].PropTypes.bool,
    horizontal: _React2['default'].PropTypes.bool
};

ScrollArea.defaultProps = {
    speed: 1,
    vertical: true,
    horizontal: true
};

exports['default'] = ScrollArea;
module.exports = exports['default'];