/** @jsx jsx */
import { ComponentType, ReactNode } from 'react';
import { jsx } from '@emotion/react';
import { CommonPropsAndClassName, CSSObjectWithLabel, CX, GetStyles, GroupBase, OptionBase, Options, Theme } from '../types';
import { Props } from '../Select';
export interface ForwardedHeadingProps<Option extends OptionBase, Group extends GroupBase<Option>> {
    id: string;
    data: Group;
}
export interface GroupProps<Option extends OptionBase = OptionBase, IsMulti extends boolean = boolean, Group extends GroupBase<Option> = GroupBase<Option>> extends CommonPropsAndClassName<Option, IsMulti, Group> {
    /** The children to be rendered. */
    children: ReactNode;
    /** Component to wrap the label, receives headingProps. */
    Heading: ComponentType<GroupHeadingProps<Option, IsMulti, Group>>;
    /** Props to pass to Heading. */
    headingProps: ForwardedHeadingProps<Option, Group>;
    /** Props to be passed to the group element. */
    innerProps: JSX.IntrinsicElements['div'];
    /** Label to be displayed in the heading component. */
    label: ReactNode;
    /** The data of the group. */
    data: Group;
    options: Options<Option>;
}
export declare const groupCSS: <Option extends OptionBase, IsMulti extends boolean, Group extends GroupBase<Option>>({ theme: { spacing }, }: GroupProps<Option, IsMulti, Group>) => CSSObjectWithLabel;
declare const Group: <Option extends OptionBase, IsMulti extends boolean, Group extends GroupBase<Option>>(props: GroupProps<Option, IsMulti, Group>) => jsx.JSX.Element;
interface GroupHeadingPropsDefinedProps<Option extends OptionBase, IsMulti extends boolean, Group extends GroupBase<Option>> extends ForwardedHeadingProps<Option, Group> {
    className?: string | undefined;
    selectProps: Props<Option, IsMulti, Group>;
    theme: Theme;
    getStyles: GetStyles<Option, IsMulti, Group>;
    cx: CX;
}
export declare type GroupHeadingProps<Option extends OptionBase = OptionBase, IsMulti extends boolean = boolean, Group extends GroupBase<Option> = GroupBase<Option>> = GroupHeadingPropsDefinedProps<Option, IsMulti, Group> & JSX.IntrinsicElements['div'];
export declare const groupHeadingCSS: <Option extends OptionBase, IsMulti extends boolean, Group extends GroupBase<Option>>({ theme: { spacing }, }: GroupHeadingProps<Option, IsMulti, Group>) => CSSObjectWithLabel;
export declare const GroupHeading: <Option extends OptionBase, IsMulti extends boolean, Group extends GroupBase<Option>>(props: GroupHeadingProps<Option, IsMulti, Group>) => jsx.JSX.Element;
export default Group;
