import { ContainerProps, IndicatorsContainerProps, ValueContainerProps } from './components/containers';
import { ControlProps } from './components/Control';
import { GroupHeadingProps, GroupProps } from './components/Group';
import { ClearIndicatorProps, DropdownIndicatorProps, IndicatorSeparatorProps, LoadingIndicatorProps } from './components/indicators';
import { InputProps } from './components/Input';
import { PlaceholderProps } from './components/Placeholder';
import { OptionProps } from './components/Option';
import { NoticeProps, MenuProps, MenuListProps, PortalStyleArgs } from './components/Menu';
import { SingleValueProps } from './components/SingleValue';
import { MultiValueProps } from './components/MultiValue';
import { CSSObjectWithLabel, GroupBase, OptionBase } from './types';
export interface StylesProps<Option extends OptionBase, IsMulti extends boolean, Group extends GroupBase<Option>> {
    clearIndicator: ClearIndicatorProps<Option, IsMulti, Group>;
    container: ContainerProps<Option, IsMulti, Group>;
    control: ControlProps<Option, IsMulti, Group>;
    dropdownIndicator: DropdownIndicatorProps<Option, IsMulti, Group>;
    group: GroupProps<Option, IsMulti, Group>;
    groupHeading: GroupHeadingProps<Option, IsMulti, Group>;
    indicatorsContainer: IndicatorsContainerProps<Option, IsMulti, Group>;
    indicatorSeparator: IndicatorSeparatorProps<Option, IsMulti, Group>;
    input: InputProps<Option, IsMulti, Group>;
    loadingIndicator: LoadingIndicatorProps<Option, IsMulti, Group>;
    loadingMessage: NoticeProps<Option, IsMulti, Group>;
    menu: MenuProps<Option, IsMulti, Group>;
    menuList: MenuListProps<Option, IsMulti, Group>;
    menuPortal: PortalStyleArgs;
    multiValue: MultiValueProps<Option, IsMulti, Group>;
    multiValueLabel: MultiValueProps<Option, IsMulti, Group>;
    multiValueRemove: MultiValueProps<Option, IsMulti, Group>;
    noOptionsMessage: NoticeProps<Option, IsMulti, Group>;
    option: OptionProps<Option, IsMulti, Group>;
    placeholder: PlaceholderProps<Option, IsMulti, Group>;
    singleValue: SingleValueProps<Option, IsMulti, Group>;
    valueContainer: ValueContainerProps<Option, IsMulti, Group>;
}
declare type StylesFunction<Props> = (props: Props) => CSSObjectWithLabel;
export declare type StylesFunctions<Option extends OptionBase, IsMulti extends boolean, Group extends GroupBase<Option>> = {
    [K in keyof StylesProps<Option, IsMulti, Group>]: StylesFunction<StylesProps<Option, IsMulti, Group>[K]>;
};
export declare type StylesConfigFunction<Props> = (base: CSSObjectWithLabel, props: Props) => CSSObjectWithLabel;
export declare type StylesConfig<Option extends OptionBase = OptionBase, IsMulti extends boolean = boolean, Group extends GroupBase<Option> = GroupBase<Option>> = {
    [K in keyof StylesProps<Option, IsMulti, Group>]?: StylesConfigFunction<StylesProps<Option, IsMulti, Group>[K]>;
};
export declare const defaultStyles: StylesFunctions<OptionBase, boolean, GroupBase<OptionBase>>;
export declare function mergeStyles<Option extends OptionBase, IsMulti extends boolean, Group extends GroupBase<Option>>(source: StylesConfig<Option, IsMulti, Group>, target?: StylesConfig<Option, IsMulti, Group>): {
    clearIndicator?: StylesConfigFunction<ClearIndicatorProps<Option, IsMulti, Group>> | undefined;
    container?: StylesConfigFunction<ContainerProps<Option, IsMulti, Group>> | undefined;
    control?: StylesConfigFunction<ControlProps<Option, IsMulti, Group>> | undefined;
    dropdownIndicator?: StylesConfigFunction<DropdownIndicatorProps<Option, IsMulti, Group>> | undefined;
    group?: StylesConfigFunction<GroupProps<Option, IsMulti, Group>> | undefined;
    groupHeading?: StylesConfigFunction<GroupHeadingProps<Option, IsMulti, Group>> | undefined;
    indicatorsContainer?: StylesConfigFunction<IndicatorsContainerProps<Option, IsMulti, Group>> | undefined;
    indicatorSeparator?: StylesConfigFunction<IndicatorSeparatorProps<Option, IsMulti, Group>> | undefined;
    input?: StylesConfigFunction<InputProps<Option, IsMulti, Group>> | undefined;
    loadingIndicator?: StylesConfigFunction<LoadingIndicatorProps<Option, IsMulti, Group>> | undefined;
    loadingMessage?: StylesConfigFunction<NoticeProps<Option, IsMulti, Group>> | undefined;
    menu?: StylesConfigFunction<MenuProps<Option, IsMulti, Group>> | undefined;
    menuList?: StylesConfigFunction<MenuListProps<Option, IsMulti, Group>> | undefined;
    menuPortal?: StylesConfigFunction<PortalStyleArgs> | undefined;
    multiValue?: StylesConfigFunction<MultiValueProps<Option, IsMulti, Group>> | undefined;
    multiValueLabel?: StylesConfigFunction<MultiValueProps<Option, IsMulti, Group>> | undefined;
    multiValueRemove?: StylesConfigFunction<MultiValueProps<Option, IsMulti, Group>> | undefined;
    noOptionsMessage?: StylesConfigFunction<NoticeProps<Option, IsMulti, Group>> | undefined;
    option?: StylesConfigFunction<OptionProps<Option, IsMulti, Group>> | undefined;
    placeholder?: StylesConfigFunction<PlaceholderProps<Option, IsMulti, Group>> | undefined;
    singleValue?: StylesConfigFunction<SingleValueProps<Option, IsMulti, Group>> | undefined;
    valueContainer?: StylesConfigFunction<ValueContainerProps<Option, IsMulti, Group>> | undefined;
};
export {};
