'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp2;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _sortablejs = require('sortablejs');

var _sortablejs2 = _interopRequireDefault(_sortablejs);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var store = {
    nextSibling: null,
    activeComponent: null
};

module.exports = (_temp2 = _class = function (_React$Component) {
    _inherits(_class, _React$Component);

    function _class() {
        var _Object$getPrototypeO;

        var _temp, _this, _ret;

        _classCallCheck(this, _class);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_Object$getPrototypeO = Object.getPrototypeOf(_class)).call.apply(_Object$getPrototypeO, [this].concat(args))), _this), _this.sortable = null, _temp), _possibleConstructorReturn(_this, _ret);
    }

    _createClass(_class, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            var _this2 = this;

            var options = _extends({}, this.props.options);

            ['onStart', 'onEnd', 'onAdd', 'onSort', 'onUpdate', 'onRemove', 'onFilter', 'onMove'].forEach(function (name) {
                var eventHandler = options[name];

                options[name] = function (evt) {
                    if (name === 'onStart') {
                        store.nextSibling = evt.item.nextElementSibling;
                        store.activeComponent = _this2;
                    } else if ((name === 'onAdd' || name === 'onUpdate') && _this2.props.onChange) {
                        var items = _this2.sortable.toArray();
                        var remote = store.activeComponent;
                        var remoteItems = remote.sortable.toArray();

                        evt.from.insertBefore(evt.item, store.nextSibling);

                        if (remote !== _this2) {
                            var remoteOptions = remote.props.options || {};

                            if (_typeof(remoteOptions.group) === 'object' && remoteOptions.group.pull === 'clone') {
                                // Remove the node with the same data-reactid
                                evt.item.parentNode.removeChild(evt.item);
                            }

                            remote.props.onChange && remote.props.onChange(remoteItems, remote.sortable, evt);
                        }

                        _this2.props.onChange && _this2.props.onChange(items, _this2.sortable, evt);
                    }

                    setTimeout(function () {
                        eventHandler && eventHandler(evt);
                    }, 0);
                };
            });

            this.sortable = _sortablejs2.default.create(_reactDom2.default.findDOMNode(this), options);
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            if (this.sortable) {
                this.sortable.destroy();
                this.sortable = null;
            }
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props;
            var children = _props.children;
            var className = _props.className;
            var tag = _props.tag;

            return _react2.default.DOM[tag]({ className: className }, children);
        }
    }]);

    return _class;
}(_react2.default.Component), _class.propTypes = {
    options: _react2.default.PropTypes.object,
    onChange: _react2.default.PropTypes.func,
    tag: _react2.default.PropTypes.string
}, _class.defaultProps = {
    options: {},
    tag: 'div'
}, _temp2);