'use strict'

jest.dontMock('../cell');

const React = require('react');
const ReactDOM = require('react-dom');
const TestUtils = require('react-addons-test-utils');

const CellComponent = require('../cell');

const testVars =  {
  key: 'row_0000_cell_1',
  uid: [0, 0],
  val: 'test',
  spreadsheetId: '1',
  selected: false,
  editing: false
};

describe('Cell', function()  {
  it('Renders a cell', function()  {
    var cell = TestUtils.renderIntoDocument(
      React.createElement("table", null, 
        React.createElement("tbody", null, 
          React.createElement("tr", null, 
            React.createElement(CellComponent, {
              uid: testVars.uid, 
              key: testVars.key, 
              value: testVars.val, 
              spreadsheetId: testVars.spreadsheetId, 
              selected: testVars.selected, 
              editing: testVars.editing}
            )
          )
        )
      ) 
    );

    var cellNode = ReactDOM.findDOMNode(cell);
  });
});