'use strict'

jest.dontMock('../row');

const React = require('react');
const ReactDOM = require('react-dom');
const TestUtils = require('react-addons-test-utils');

const RowComponent = require('../cell');

const testVars = {
  cells: [],
  cellClasses: [],
  uid: 0,
  key: 'testkey',
  spreadsheetId: '0',
  className: 'cellComponent'
};

describe('Row', function()  {
  it('Renders a row', function()  {
    var row = TestUtils.renderIntoDocument(
      React.createElement("table", null, 
        React.createElement("tbody", null, 
            React.createElement(RowComponent, {
              cells: testVars.cells, 
              cellClasses: testVars.cellClasses, 
              uid: testVars.uid, 
              key: testVars.key, 
              spreadsheetId: testVars.spreadsheetId, 
              className: testVars.className}
            )
        )
      ) 
    );

    var rowNode = ReactDOM.findDOMNode(row);
    expect(rowNode).toBeDefined();
  });
});