"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _utilsUtils = require("./utils/utils");

var CanvasContainer = (function (_React$Component) {
	_inherits(CanvasContainer, _React$Component);

	function CanvasContainer() {
		_classCallCheck(this, CanvasContainer);

		_get(Object.getPrototypeOf(CanvasContainer.prototype), "constructor", this).apply(this, arguments);
	}

	_createClass(CanvasContainer, [{
		key: "getCanvasContexts",
		value: function getCanvasContexts() {
			var axesCanvasDOM = (0, _utilsUtils.isReactVersion14)() ? this.refs.canvas_axes : _react2["default"].findDOMNode(this.refs.canvas_axes);

			var mouseCoordDOM = (0, _utilsUtils.isReactVersion14)() ? this.refs.canvas_mouse_coordinates : _react2["default"].findDOMNode(this.refs.canvas_mouse_coordinates);

			var interactiveDOM = (0, _utilsUtils.isReactVersion14)() ? this.refs.canvas_interactive : _react2["default"].findDOMNode(this.refs.canvas_interactive);

			var bgDOM = (0, _utilsUtils.isReactVersion14)() ? this.refs.bg : _react2["default"].findDOMNode(this.refs.bg);

			if (this.refs.canvas_axes) {
				return {
					axes: axesCanvasDOM.getContext("2d"),
					mouseCoord: mouseCoordDOM.getContext("2d"),
					interactive: interactiveDOM.getContext("2d"),
					bg: bgDOM.getContext("2d")
				};
			}
		}
	}, {
		key: "render",
		value: function render() {
			var _props = this.props;
			var height = _props.height;
			var width = _props.width;
			var type = _props.type;
			var zIndex = _props.zIndex;

			if (type === "svg") return null;
			return _react2["default"].createElement(
				"div",
				{ style: { zIndex: zIndex } },
				_react2["default"].createElement("canvas", { ref: "bg", width: width, height: height,
					style: { position: "absolute", left: 0, top: 0 } }),
				_react2["default"].createElement("canvas", { ref: "canvas_axes", width: width, height: height,
					style: { position: "absolute", left: 0, top: 0 } }),
				_react2["default"].createElement("canvas", { ref: "canvas_mouse_coordinates", width: width, height: height,
					style: { position: "absolute", left: 0, top: 0 } }),
				_react2["default"].createElement("canvas", { ref: "canvas_interactive", width: width, height: height,
					style: { position: "absolute", left: 0, top: 0 } })
			);
		}
	}]);

	return CanvasContainer;
})(_react2["default"].Component);

CanvasContainer.propTypes = {
	width: _react2["default"].PropTypes.number.isRequired,
	height: _react2["default"].PropTypes.number.isRequired,
	type: _react2["default"].PropTypes.string.isRequired,
	zIndex: _react2["default"].PropTypes.number
};

exports["default"] = CanvasContainer;
module.exports = exports["default"];