"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _objectAssign = require("object-assign");

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _utilsPureComponent = require("./utils/PureComponent");

var _utilsPureComponent2 = _interopRequireDefault(_utilsPureComponent);

var _utilsUtils = require("./utils/utils");

var _utilsChartDataUtil = require("./utils/ChartDataUtil");

var Chart = (function (_PureComponent) {
	_inherits(Chart, _PureComponent);

	function Chart() {
		_classCallCheck(this, Chart);

		_get(Object.getPrototypeOf(Chart.prototype), "constructor", this).apply(this, arguments);
	}

	_createClass(Chart, [{
		key: "getChildContext",
		value: function getChildContext() {
			var _this = this;

			var chartData = this.context.chartData.filter(function (each) {
				return each.id === _this.props.id;
			})[0];

			var originX = 0.5 + chartData.config.origin[0] + this.context.margin.left;
			var originY = 0.5 + chartData.config.origin[1] + this.context.margin.top;

			// console.log(chartData.config.compareSeries);
			return {
				chartId: this.props.id,
				xScale: chartData.plot.scales.xScale,
				yScale: chartData.plot.scales.yScale,
				xAccessor: chartData.config.xAccessor,
				overlays: chartData.config.overlays,
				compareSeries: chartData.config.compareSeries,
				chartData: chartData,
				width: chartData.config.width,
				height: chartData.config.height,
				canvasOriginX: originX,
				canvasOriginY: originY
			};
		}
	}, {
		key: "render",
		value: function render() {
			var _this2 = this;

			var origin = (0, _utilsChartDataUtil.getChartOrigin)(this.props.origin, this.context.width, this.context.height);
			var children = _react2["default"].Children.map(this.props.children, function (child) {
				if (child === undefined || child === null) return child;
				var newChild = (0, _utilsUtils.isReactVersion13)() ? _react2["default"].withContext(_this2.getChildContext(), function () {
					return _react2["default"].createElement(child.type, (0, _objectAssign2["default"])({ key: child.key, ref: child.ref }, child.props));
				}) : child;
				return newChild;
			});
			var x = origin[0]; // + 0.5; // refer to http://www.rgraph.net/docs/howto-get-crisp-lines-with-no-antialias.html - similar fix for svg here
			var y = origin[1]; // + 0.5; // refer to http://www.rgraph.net/docs/howto-get-crisp-lines-with-no-antialias.html - similar fix for svg here
			return _react2["default"].createElement(
				"g",
				{ transform: "translate(" + x + ", " + y + ")" },
				children
			);
		}
	}]);

	return Chart;
})(_utilsPureComponent2["default"]);

Chart.propTypes = {
	height: _react2["default"].PropTypes.number,
	width: _react2["default"].PropTypes.number,
	origin: _react2["default"].PropTypes.oneOfType([_react2["default"].PropTypes.array, _react2["default"].PropTypes.func]).isRequired,
	id: _react2["default"].PropTypes.number.isRequired,
	xScale: _react2["default"].PropTypes.func,
	yScale: _react2["default"].PropTypes.func,
	xDomainUpdate: _react2["default"].PropTypes.bool,
	yDomainUpdate: _react2["default"].PropTypes.bool,
	yMousePointerDisplayLocation: _react2["default"].PropTypes.oneOf(["left", "right"]),
	yMousePointerDisplayFormat: _react2["default"].PropTypes.func,
	padding: _react2["default"].PropTypes.object.isRequired
};

Chart.defaultProps = {
	id: 0,
	namespace: "ReStock.Chart",
	transformDataAs: "none",
	yDomainUpdate: true,
	origin: [0, 0],
	padding: { top: 0, right: 0, bottom: 0, left: 0 }
};

Chart.contextTypes = {
	width: _react2["default"].PropTypes.number.isRequired,
	height: _react2["default"].PropTypes.number.isRequired,
	chartData: _react2["default"].PropTypes.array,
	margin: _react2["default"].PropTypes.object.isRequired,
	interactiveState: _react2["default"].PropTypes.array.isRequired
};

// adding here even when this is not used by Chart, refer to https://github.com/facebook/react/issues/2517
Chart.childContextTypes = {
	xScale: _react2["default"].PropTypes.func.isRequired,
	yScale: _react2["default"].PropTypes.func.isRequired,
	xAccessor: _react2["default"].PropTypes.func.isRequired,
	chartData: _react2["default"].PropTypes.object.isRequired,
	overlays: _react2["default"].PropTypes.array.isRequired,
	compareSeries: _react2["default"].PropTypes.array.isRequired,
	width: _react2["default"].PropTypes.number.isRequired,
	height: _react2["default"].PropTypes.number.isRequired,
	canvasOriginX: _react2["default"].PropTypes.number,
	canvasOriginY: _react2["default"].PropTypes.number,
	chartId: _react2["default"].PropTypes.number.isRequired
};

exports["default"] = Chart;
module.exports = exports["default"];