"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _EventHandler = require("./EventHandler");

var _EventHandler2 = _interopRequireDefault(_EventHandler);

var _CanvasContainer = require("./CanvasContainer");

var _CanvasContainer2 = _interopRequireDefault(_CanvasContainer);

var ChartCanvas = (function (_React$Component) {
	_inherits(ChartCanvas, _React$Component);

	function ChartCanvas() {
		_classCallCheck(this, ChartCanvas);

		_get(Object.getPrototypeOf(ChartCanvas.prototype), "constructor", this).call(this);
		this.getCanvases = this.getCanvases.bind(this);
	}

	_createClass(ChartCanvas, [{
		key: "getDimensions",
		value: function getDimensions(props) {
			return {
				height: props.height - props.margin.top - props.margin.bottom,
				width: props.width - props.margin.left - props.margin.right
			};
		}
	}, {
		key: "pushData",
		value: function pushData(array) {
			this.refs.chartContainer.pushData(array);
		}
	}, {
		key: "alterData",
		value: function alterData(array) {
			this.refs.chartContainer.alterData(array);
		}
	}, {
		key: "getDataInfo",
		value: function getDataInfo() {
			return this.refs.chartContainer.getDataInfo();
		}
	}, {
		key: "setViewRange",
		value: function setViewRange(start, end) {
			this.refs.chartContainer.setViewRange(start, end);
		}
	}, {
		key: "getCanvases",
		value: function getCanvases() {
			if (this.refs && this.refs.canvases) {
				return this.refs.canvases.getCanvasContexts();
			}
		}
	}, {
		key: "render",
		value: function render() {
			var dimensions = this.getDimensions(this.props);
			var style = "<![CDATA[\n\t\t\t\t\t\t.react-stockcharts-grabbing-cursor {\n\t\t\t\t\t\t\tcursor: grabbing;\n\t\t\t\t\t\t\tcursor: -moz-grabbing;\n\t\t\t\t\t\t\tcursor: -webkit-grabbing;\n\t\t\t\t\t\t}\n\t\t\t\t\t\t.react-stockcharts-crosshair-cursor {\n\t\t\t\t\t\t\tcursor: crosshair;\n\t\t\t\t\t\t}\n\t\t\t\t\t\t.react-stockcharts-toottip-hover {\n\t\t\t\t\t\t\tpointer-events: all;\n\t\t\t\t\t\t\tcursor: pointer;\n\t\t\t\t\t\t}\n\t\t\t\t\t]]>";
			var _props = this.props;
			var data = _props.data;
			var dataTransform = _props.dataTransform;
			var interval = _props.interval;
			var initialDisplay = _props.initialDisplay;
			var type = _props.type;
			var height = _props.height;
			var width = _props.width;
			var margin = _props.margin;
			var className = _props.className;
			var zIndex = _props.zIndex;

			return _react2["default"].createElement(
				"div",
				{ style: { position: "relative", height: height, width: width }, className: className },
				_react2["default"].createElement(_CanvasContainer2["default"], { ref: "canvases", width: width, height: height, type: this.props.type, zIndex: zIndex }),
				_react2["default"].createElement(
					"svg",
					{ width: width, height: height, style: { position: "absolute", zIndex: zIndex + 5 } },
					_react2["default"].createElement("style", { type: "text/css", dangerouslySetInnerHTML: { __html: style } }),
					_react2["default"].createElement(
						"defs",
						null,
						_react2["default"].createElement(
							"clipPath",
							{ id: "chart-area-clip" },
							_react2["default"].createElement("rect", { x: "0", y: "0", width: dimensions.width, height: dimensions.height })
						)
					),
					_react2["default"].createElement(
						"g",
						{ transform: "translate(" + (margin.left + 0.5) + ", " + (margin.top + 0.5) + ")" },
						_react2["default"].createElement(
							_EventHandler2["default"],
							{ ref: "chartContainer",
								rawData: data, dataTransform: dataTransform, interval: interval,
								initialDisplay: initialDisplay,
								dimensions: dimensions, type: type, margin: margin, canvasContexts: this.getCanvases },
							this.props.children
						)
					)
				)
			);
		}
	}]);

	return ChartCanvas;
})(_react2["default"].Component);

ChartCanvas.propTypes = {
	width: _react2["default"].PropTypes.number.isRequired,
	height: _react2["default"].PropTypes.number.isRequired,
	margin: _react2["default"].PropTypes.object,
	interval: _react2["default"].PropTypes.oneOf(["D", "W", "M"]).isRequired, // ,"m1", "m5", "m15", "W", "M"
	type: _react2["default"].PropTypes.oneOf(["svg", "hybrid"]).isRequired,
	data: _react2["default"].PropTypes.array.isRequired,
	initialDisplay: _react2["default"].PropTypes.number,
	dataTransform: _react2["default"].PropTypes.array.isRequired,
	className: _react2["default"].PropTypes.string,
	zIndex: _react2["default"].PropTypes.number,
	children: _react2["default"].PropTypes.node.isRequired
};

ChartCanvas.defaultProps = {
	margin: { top: 20, right: 30, bottom: 30, left: 80 },
	interval: "D",
	type: "hybrid",
	dataTransform: [],
	className: "react-stockchart",
	zIndex: 1
};

// initialDisplay: 30
exports["default"] = ChartCanvas;
module.exports = exports["default"];