"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _objectAssign = require("object-assign");

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _utilsUtils = require("./utils/utils");

// Cannot make this PureComponent because its children use some things from context
// and making this pure would stop its children from updating on state changes of EventHandler
// refer to https://github.com/facebook/react/issues/2517

var DataSeries = (function (_React$Component) {
	_inherits(DataSeries, _React$Component);

	function DataSeries() {
		_classCallCheck(this, DataSeries);

		_get(Object.getPrototypeOf(DataSeries.prototype), "constructor", this).apply(this, arguments);
	}

	_createClass(DataSeries, [{
		key: "getChildContext",
		value: function getChildContext() {
			var _this = this;

			var overlay = this.context.overlays.filter(function (each) {
				return each.id === _this.props.id;
			})[0];

			return {
				seriesId: this.props.id,
				yAccessor: overlay.yAccessor,
				indicator: overlay.indicator,
				stroke: overlay.stroke,
				fill: overlay.fill
			};
		}
	}, {
		key: "render",
		value: function render() {
			var _this2 = this;

			var children = _react2["default"].Children.map(this.props.children, function (child) {
				var newChild = (0, _utilsUtils.isReactVersion13)() ? _react2["default"].withContext(_this2.getChildContext(), function () {
					return _react2["default"].createElement(child.type, (0, _objectAssign2["default"])({ key: child.key, ref: child.ref }, child.props));
				}) : child;
				return newChild;
			});
			return _react2["default"].createElement(
				"g",
				{ style: { "clipPath": "url(#chart-area-clip)" } },
				children
			);
		}
	}]);

	return DataSeries;
})(_react2["default"].Component);

DataSeries.propTypes = {
	// type: React.PropTypes.oneOf(["sma", "ema"]),
	id: _react2["default"].PropTypes.number.isRequired,
	// stroke: React.PropTypes.string
	// xAccessor: React.PropTypes.func,
	yAccessor: _react2["default"].PropTypes.func,
	indicator: _react2["default"].PropTypes.func,
	options: _react2["default"].PropTypes.object,
	children: _react2["default"].PropTypes.node.isRequired
};
DataSeries.defaultProps = {
	namespace: "ReStock.DataSeries",
	compareBase: function compareBase(d) {
		return d.close;
	}
};
DataSeries.contextTypes = {
	overlays: _react2["default"].PropTypes.array.isRequired
};
DataSeries.childContextTypes = {
	seriesId: _react2["default"].PropTypes.number.isRequired,
	yAccessor: _react2["default"].PropTypes.func.isRequired,
	indicator: _react2["default"].PropTypes.func,
	stroke: _react2["default"].PropTypes.string,
	fill: _react2["default"].PropTypes.string
};

exports["default"] = DataSeries;
module.exports = exports["default"];