"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _d3 = require("d3");

var _d32 = _interopRequireDefault(_d3);

var _utilsUtils = require("./utils/utils");

var mousemove = "mousemove.pan",
    mouseup = "mouseup.pan";

function d3Window(node) {
	var d3win = node && (node.ownerDocument && node.ownerDocument.defaultView || node.document && node || node.defaultView);
	return d3win;
}

var EventCapture = (function (_React$Component) {
	_inherits(EventCapture, _React$Component);

	function EventCapture(props) {
		_classCallCheck(this, EventCapture);

		_get(Object.getPrototypeOf(EventCapture.prototype), "constructor", this).call(this, props);
		this.handleEnter = this.handleEnter.bind(this);
		this.handleLeave = this.handleLeave.bind(this);
		this.handleWheel = this.handleWheel.bind(this);
		this.handleMouseMove = this.handleMouseMove.bind(this);
		this.handleMouseDown = this.handleMouseDown.bind(this);
		this.handlePanEnd = this.handlePanEnd.bind(this);
		this.handlePan = this.handlePan.bind(this);
	}

	_createClass(EventCapture, [{
		key: "componentWillMount",
		value: function componentWillMount() {
			if (this.context.onFocus) this.context.onFocus(this.props.defaultFocus);
		}
	}, {
		key: "handleEnter",
		value: function handleEnter() {
			if (this.context.onMouseEnter) {
				this.context.onMouseEnter();
			}
		}
	}, {
		key: "handleLeave",
		value: function handleLeave() {
			if (this.context.onMouseLeave) {
				this.context.onMouseLeave();
			}
		}
	}, {
		key: "handleWheel",
		value: function handleWheel(e) {
			if (this.props.zoom && this.context.onZoom && this.context.focus) {
				e.stopPropagation();
				e.preventDefault();
				var zoomDir = e.deltaY > 0 ? this.props.zoomMultiplier : -this.props.zoomMultiplier;
				var newPos = (0, _utilsUtils.mousePosition)(e);
				this.context.onZoom(zoomDir, newPos);
				if (this.props.onZoom) {
					this.props.onZoom(e);
				}
			}
		}
	}, {
		key: "handleMouseMove",
		value: function handleMouseMove(e) {
			if (this.context.onMouseMove && this.props.mouseMove) {
				if (!this.context.panInProgress) {
					var newPos = (0, _utilsUtils.mousePosition)(e);
					this.context.onMouseMove(newPos, e);
				}
			}
		}
	}, {
		key: "handleMouseDown",
		value: function handleMouseDown(e) {
			var _this = this;

			var mouseEvent = e || _d32["default"].event;
			var _context = this.context;
			var onPanStart = _context.onPanStart;
			var deltaXY = _context.deltaXY;
			var focus = _context.focus;
			var onFocus = _context.onFocus;

			var chartData = this.context.chartData.filter(function (each) {
				return each.id === _this.props.mainChart;
			})[0];
			if (this.props.pan && onPanStart) {
				var mouseXY = (0, _utilsUtils.mousePosition)(mouseEvent);
				onPanStart(chartData.plot.scales.xScale.domain(), mouseXY);

				var dx = mouseEvent.pageX - mouseXY[0],
				    dy = mouseEvent.pageY - mouseXY[1];

				var captureDOM = (0, _utilsUtils.isReactVersion14)() ? this.refs.capture : _react2["default"].findDOMNode(this.refs.capture);

				var win = d3Window(captureDOM);
				_d32["default"].select(win).on(mousemove, this.handlePan).on(mouseup, this.handlePanEnd);

				deltaXY([dx, dy]);
			} else {
				if (!focus && onFocus) onFocus(true);
			}
			mouseEvent.preventDefault();
		}
	}, {
		key: "handleRightClick",
		value: function handleRightClick(e) {
			e.preventDefault();
			// console.log("RIGHT CLICK");
		}
	}, {
		key: "handlePan",
		value: function handlePan() {
			var _this2 = this;

			// console.log("handlePan")
			var e = _d32["default"].event;
			var deltaXY = this.context.deltaXY();
			var newPos = [e.pageX - deltaXY[0], e.pageY - deltaXY[1]];
			// console.log("moved from- ", startXY, " to ", newPos);
			if (this.props.pan && this.context.onPan) {
				var chartData = this.context.chartData.filter(function (each) {
					return each.id === _this2.props.mainChart;
				})[0];
				this.context.onPan(newPos, chartData.plot.scales.xScale.domain());
				if (this.props.onPan) {
					this.props.onPan(e);
				}
			}
		}
	}, {
		key: "handlePanEnd",
		value: function handlePanEnd() {
			var e = _d32["default"].event;
			var deltaXY = this.context.deltaXY();
			var newPos = [e.pageX - deltaXY[0], e.pageY - deltaXY[1]];

			var captureDOM = (0, _utilsUtils.isReactVersion14)() ? this.refs.capture : _react2["default"].findDOMNode(this.refs.capture);

			var win = d3Window(captureDOM);

			_d32["default"].select(win).on(mousemove, null).on(mouseup, null);
			if (this.props.pan && this.context.onPanEnd) {
				this.context.onPanEnd(newPos, e);
			}
			// e.preventDefault();
		}
	}, {
		key: "handleTouchStart",
		value: function handleTouchStart(e) {
			console.log("handleTouchStart", e);
		}
	}, {
		key: "handleTouchEnd",
		value: function handleTouchEnd(e) {
			console.log("handleTouchEnd", e);
		}
	}, {
		key: "handleTouchMove",
		value: function handleTouchMove(e) {
			console.log("handleTouchMove", e);
		}
	}, {
		key: "render",
		value: function render() {
			var className = this.context.panInProgress ? "react-stockcharts-grabbing-cursor" : "react-stockcharts-crosshair-cursor";

			return _react2["default"].createElement("rect", { ref: "capture",
				className: className,
				width: this.context.width, height: this.context.height, style: { opacity: 0 },
				onMouseEnter: this.handleEnter,
				onMouseLeave: this.handleLeave,
				onMouseMove: this.handleMouseMove,
				onWheel: this.handleWheel,
				onMouseDown: this.handleMouseDown,
				onContextMenu: this.handleRightClick,
				onTouchStart: this.handleTouchStart,
				onTouchEnd: this.handleTouchEnd,
				onTouchMove: this.handleTouchMove
			});
		}
	}]);

	return EventCapture;
})(_react2["default"].Component);

EventCapture.propTypes = {
	mainChart: _react2["default"].PropTypes.number.isRequired,
	mouseMove: _react2["default"].PropTypes.bool.isRequired,
	zoom: _react2["default"].PropTypes.bool.isRequired,
	zoomMultiplier: _react2["default"].PropTypes.number.isRequired,
	pan: _react2["default"].PropTypes.bool.isRequired,
	panSpeedMultiplier: _react2["default"].PropTypes.number.isRequired,
	defaultFocus: _react2["default"].PropTypes.bool.isRequired,

	onZoom: _react2["default"].PropTypes.func,
	onPan: _react2["default"].PropTypes.func
};

EventCapture.defaultProps = {
	namespace: "ReStock.EventCapture",
	mouseMove: false,
	zoom: false,
	zoomMultiplier: 1,
	pan: false,
	panSpeedMultiplier: 1,
	defaultFocus: false
};

EventCapture.contextTypes = {
	width: _react2["default"].PropTypes.number.isRequired,
	height: _react2["default"].PropTypes.number.isRequired,
	chartData: _react2["default"].PropTypes.array,
	onMouseMove: _react2["default"].PropTypes.func,
	onMouseEnter: _react2["default"].PropTypes.func,
	onMouseLeave: _react2["default"].PropTypes.func,
	onZoom: _react2["default"].PropTypes.func,
	onPanStart: _react2["default"].PropTypes.func,
	onPan: _react2["default"].PropTypes.func,
	onPanEnd: _react2["default"].PropTypes.func,
	panInProgress: _react2["default"].PropTypes.bool,
	focus: _react2["default"].PropTypes.bool.isRequired,
	onFocus: _react2["default"].PropTypes.func,
	deltaXY: _react2["default"].PropTypes.func
};

exports["default"] = EventCapture;
module.exports = exports["default"];