"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _objectAssign = require("object-assign");

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _utilsPureComponent = require("./utils/PureComponent");

var _utilsPureComponent2 = _interopRequireDefault(_utilsPureComponent);

var _utilsUtils = require("./utils/utils");

var _utilsChartDataUtil = require("./utils/ChartDataUtil");

var _transforms = require("./transforms");

var subscriptionCount = 0;

function getLongValue(value) {
	if (value instanceof Date) {
		return value.getTime();
	}
	return value;
}
function deepEquals(arr1, arr2) {
	if (arr1.length === arr2.length) {
		var result = true;
		arr1.forEach(function (each, i) {
			result = result && each.transform === arr2[i].transform && each.options === arr2[i].options;
		});
		return result;
	}
	return false;
}

var EventHandler = (function (_PureComponent) {
	_inherits(EventHandler, _PureComponent);

	function EventHandler(props, context) {
		_classCallCheck(this, EventHandler);

		_get(Object.getPrototypeOf(EventHandler.prototype), "constructor", this).call(this, props, context);
		this.handleMouseMove = this.handleMouseMove.bind(this);
		this.handleMouseEnter = this.handleMouseEnter.bind(this);
		this.handleMouseLeave = this.handleMouseLeave.bind(this);
		this.handleZoom = this.handleZoom.bind(this);
		this.handlePanStart = this.handlePanStart.bind(this);
		this.handlePan = this.handlePan.bind(this);
		this.handlePanEnd = this.handlePanEnd.bind(this);
		this.handleFocus = this.handleFocus.bind(this);
		this.deltaXY = this.deltaXY.bind(this);
		this.getCanvasContexts = this.getCanvasContexts.bind(this);
		this.pushCallbackForCanvasDraw = this.pushCallbackForCanvasDraw.bind(this);
		this.getAllCanvasDrawCallback = this.getAllCanvasDrawCallback.bind(this);
		this.subscribe = this.subscribe.bind(this);
		this.unsubscribe = this.unsubscribe.bind(this);

		this.subscriptions = [];
		this.canvasDrawCallbackList = [];
		// this.interactiveState = [];

		this.panHappened = false;
		// this.secretArray = [];
		this.state = {
			focus: false,
			currentItems: [],
			show: false,
			mouseXY: [0, 0],
			panInProgress: false,
			interactiveState: []
		};
	}

	_createClass(EventHandler, [{
		key: "deltaXY",
		value: function deltaXY(dxy) {
			if (dxy) {
				this.setState({
					deltaXY: dxy
				});
			} else {
				return this.state.deltaXY;
			}
		}
	}, {
		key: "getTransformedData",
		value: function getTransformedData(rawData, defaultDataTransform, dataTransform, interval) {
			var i = 0,
			    eachTransform,
			    options = {},
			    data = rawData;
			var transforms = defaultDataTransform.concat(dataTransform);
			for (i = 0; i < transforms.length; i++) {
				// console.log(transforms[i]);
				eachTransform = transforms[i].transform();
				options = (0, _objectAssign2["default"])({}, options, transforms[i].options);
				options = eachTransform.options(options);
				data = eachTransform(data, interval);
			}
			return {
				data: data,
				options: options
			};
		}
	}, {
		key: "componentWillMount",
		value: function componentWillMount() {
			// console.log("EventHandler.componentWillMount");
			var props = this.props;
			var initialDisplay = props.initialDisplay;
			var rawData = props.rawData;
			var defaultDataTransform = props.defaultDataTransform;
			var dataTransform = props.dataTransform;
			var interval = props.interval;
			var dimensions = props.dimensions;

			var transformedData = this.getTransformedData(rawData, defaultDataTransform, dataTransform, interval);

			var data = transformedData.data;
			var options = transformedData.options;

			var dataForInterval = data[interval];
			var mainChart = (0, _utilsChartDataUtil.getMainChart)(props.children);
			var beginIndex = Math.max(dataForInterval.length - initialDisplay, 0);
			var plotData = dataForInterval.slice(beginIndex);
			var chartConfig = (0, _utilsChartDataUtil.getChartDataConfig)(props, dimensions, options);

			var chart = chartConfig.filter(function (eachChart) {
				return eachChart.id === mainChart;
			})[0];

			var domainL = getLongValue(chart.config.xAccessor(plotData[0]));
			var domainR = getLongValue(chart.config.xAccessor(plotData[plotData.length - 1]));

			var dataToPlot = (0, _utilsChartDataUtil.getDataToPlotForDomain)(domainL, domainR, data, chart.config.width, chart.config.xAccessor);
			var updatePlotData = dataToPlot.data;

			var chartData = (0, _utilsChartDataUtil.getChartData)(props, dimensions, plotData, data, options);

			// if (dataToPlot.data.length < 10) return;

			// console.log("componentWillMount", chartData);
			this.setState({
				data: data,
				rawData: rawData,
				options: options,
				plotData: updatePlotData,
				chartData: chartData,
				interval: this.props.interval,
				mainChart: mainChart,
				currentCharts: [mainChart],
				initialRender: true
			});
		}
	}, {
		key: "componentWillReceiveProps",
		value: function componentWillReceiveProps(nextProps) {
			var _props = this.props;
			var prevData = _props.rawData;
			var prevDataTransform = _props.dataTransform;
			var nextData = nextProps.rawData;
			var nextDataTransform = nextProps.dataTransform;
			var dimensions = nextProps.dimensions;
			var initialDisplay = nextProps.initialDisplay;
			var defaultDataTransform = nextProps.defaultDataTransform;
			var intervalProp = nextProps.interval;
			var _state = this.state;
			var data = _state.data;
			var options = _state.options;
			var interval = _state.interval;
			var chartData = _state.chartData;
			var plotData = _state.plotData;
			var rawData = _state.rawData;

			var dataChanged = false;
			if (prevData !== nextData || !deepEquals(prevDataTransform, nextDataTransform)) {
				var transformedData = this.getTransformedData(nextData, defaultDataTransform, nextDataTransform, intervalProp);
				data = transformedData.data;
				options = transformedData.options;

				dataChanged = true;
				rawData = nextData;
			}

			var dataForInterval = data[interval];

			var mainChart = (0, _utilsChartDataUtil.getMainChart)(nextProps.children);
			var mainChartData = chartData.filter(function (each) {
				return each.id === mainChart;
			})[0];
			var xScale = mainChartData.plot.scales.xScale;

			var domainL,
			    domainR,
			    startDomain = xScale.domain();
			// console.log(dataPushed, lastItemVisible);

			if (dataChanged) {
				var beginIndex = Math.max(dataForInterval.length - initialDisplay, 0);
				var endIndex = dataForInterval.length;

				plotData = dataForInterval.slice(beginIndex, endIndex);
			} else {
				domainL = startDomain[0];
				domainR = startDomain[1];
			}

			// console.log(plotData[0], plotData[plotData.length - 1]);
			var newChartData = (0, _utilsChartDataUtil.getChartData)(nextProps, dimensions, plotData, data, options);
			var chart = newChartData.filter(function (eachChart) {
				return eachChart.id === mainChart;
			})[0];
			var _chart$config = chart.config;
			var xAccessor = _chart$config.xAccessor;
			var width = _chart$config.width;

			if (!domainL) {
				domainL = getLongValue(xAccessor(plotData[0]));
				domainR = getLongValue(xAccessor(plotData[plotData.length - 1]));
			}

			var dataToPlot = (0, _utilsChartDataUtil.getDataToPlotForDomain)(domainL, domainR, data, width, xAccessor);
			plotData = dataToPlot.data;

			newChartData = newChartData.map(function (eachChart) {
				var plot = (0, _utilsChartDataUtil.getChartPlotFor)(eachChart.config, eachChart.scaleType, plotData, domainL, domainR);
				return {
					id: eachChart.id,
					config: eachChart.config,
					scaleType: eachChart.scaleType,
					plot: plot
				};
			});

			var newCurrentItems = (0, _utilsChartDataUtil.getCurrentItems)(newChartData, this.state.mouseXY, plotData);

			this.clearBothCanvas(nextProps);
			this.clearInteractiveCanvas(nextProps);

			// console.log("componentWillReceiveProps");

			this.clearCanvasDrawCallbackList();

			this.setState({
				rawData: rawData,
				data: data,
				options: options,
				chartData: newChartData,
				plotData: plotData,
				currentItems: newCurrentItems,
				mainChart: mainChart,
				initialRender: false,
				canvases: null
			});
		}
	}, {
		key: "pushData",
		value: function pushData(array) {
			var _this = this;

			if (array === undefined || array === null || array.length === 0) return;

			var _props2 = this.props;
			var dataTransform = _props2.dataTransform;
			var defaultDataTransform = _props2.defaultDataTransform;
			var dimensions = _props2.dimensions;
			var _state2 = this.state;
			var rawData = _state2.rawData;
			var data = _state2.data;
			var interval = _state2.interval;
			var chartData = _state2.chartData;
			var plotData = _state2.plotData;
			var mainChart = _state2.mainChart;

			var newRawData = rawData.concat(array);
			var transformedData = this.getTransformedData(newRawData, defaultDataTransform, dataTransform, interval);

			var prevDataForInterval = data[interval];
			var dataForInterval = transformedData.data[interval];

			var mainChartData = chartData.filter(function (each) {
				return each.id === mainChart;
			})[0];
			var xAccessor = mainChartData.config.xAccessor;
			var xScale = mainChartData.plot.scales.xScale;

			var startDomain = xScale.domain();
			var domainL, domainR;

			var lastItemVisible = plotData[plotData.length - 1] === prevDataForInterval[prevDataForInterval.length - 1];

			var beginIndex, endIndex;
			if (lastItemVisible) {
				endIndex = dataForInterval.length;
				beginIndex = dataForInterval.length - plotData.length;
			} else {
				domainL = startDomain[0];
				domainR = startDomain[1];
				beginIndex = (0, _utilsUtils.getClosestItemIndexes)(dataForInterval, domainL, xAccessor).left;
				endIndex = beginIndex + plotData.length;
			}

			var newPlotData = dataForInterval.slice(beginIndex, endIndex);
			// console.log(newPlotData[newPlotData.length - 1]);

			if (lastItemVisible && domainL === undefined) {
				if (startDomain[1] > xAccessor(plotData[plotData.length - 1])) {
					domainL = startDomain[0] + (xAccessor(newPlotData[newPlotData.length - 1]) - xAccessor(plotData[plotData.length - 1]));
					domainR = startDomain[1] + (xAccessor(newPlotData[newPlotData.length - 1]) - xAccessor(plotData[plotData.length - 1]));
				}
			}

			var newChartData = (0, _utilsChartDataUtil.getChartData)(this.props, dimensions, newPlotData, transformedData.data, transformedData.options);

			if (domainL === undefined) {
				domainL = xAccessor(newPlotData[0]);
				domainR = xAccessor(newPlotData[newPlotData.length - 1]);
			}

			var l = 2,
			    i = 0,
			    speed = 16;

			var updateState = function updateState(L, R) {
				newChartData = newChartData.map(function (eachChart) {
					var plot = (0, _utilsChartDataUtil.getChartPlotFor)(eachChart.config, eachChart.scaleType, newPlotData, L, R);
					return {
						id: eachChart.id,
						config: eachChart.config,
						scaleType: eachChart.scaleType,
						plot: plot
					};
				});

				var newCurrentItems = (0, _utilsChartDataUtil.getCurrentItems)(newChartData, _this.state.mouseXY, newPlotData);

				_this.clearBothCanvas();
				_this.clearInteractiveCanvas();

				_this.clearCanvasDrawCallbackList();
				_this.setState({
					rawData: newRawData,
					data: transformedData.data,
					options: transformedData.options,
					chartData: newChartData,
					plotData: newPlotData,
					currentItems: newCurrentItems,
					canvases: null
				});
			};
			if (lastItemVisible) {

				var timeout = setInterval(function () {
					var dxL = (startDomain[0] - domainL) / l;
					var dxR = (startDomain[1] - domainR) / l;

					i++;

					var L = i === l ? domainL : startDomain[0] - dxL * i;
					var R = i === l ? domainR : startDomain[1] - dxR * i;
					// console.log(i, L, domainL, R, domainR);
					// console.log(startDomain[0], domainL, startDomain[0] - dxL * i, i);
					// console.log(startDomain[1], domainR, startDomain[1] - dxR * i, i);

					updateState(L, R);
					if (i === l) clearInterval(timeout);
				}, speed);
			} else {
				this.setState({
					rawData: newRawData,
					data: transformedData.data,
					options: transformedData.options
				});
			}
		}
	}, {
		key: "alterData",
		// chartData: newChartData,
		// plotData: newPlotData,
		// currentItems: newCurrentItems,
		// canvases: null,
		value: function alterData(newRawData) {
			if (newRawData === undefined || newRawData === null || newRawData.length === 0) return;

			var _props3 = this.props;
			var dataTransform = _props3.dataTransform;
			var defaultDataTransform = _props3.defaultDataTransform;
			var dimensions = _props3.dimensions;
			var _state3 = this.state;
			var rawData = _state3.rawData;
			var interval = _state3.interval;
			var chartData = _state3.chartData;
			var plotData = _state3.plotData;
			var mainChart = _state3.mainChart;

			if (rawData.length !== newRawData.length) {
				console.log(rawData.length, newRawData.length);
				throw Error("Have to update data of same length");
			}

			var transformedData = this.getTransformedData(newRawData, defaultDataTransform, dataTransform, interval);

			var dataForInterval = transformedData.data[interval];

			var mainChartData = chartData.filter(function (each) {
				return each.id === mainChart;
			})[0];
			var xAccessor = mainChartData.config.xAccessor;
			var xScale = mainChartData.plot.scales.xScale;

			var startDomain = xScale.domain();

			var left = xAccessor(plotData[0]);
			var beginIndex = (0, _utilsUtils.getClosestItemIndexes)(dataForInterval, left, xAccessor).left;
			var endIndex = beginIndex + plotData.length;

			var newPlotData = dataForInterval.slice(beginIndex, endIndex);

			var newChartData = (0, _utilsChartDataUtil.getChartData)(this.props, dimensions, newPlotData, transformedData.data, transformedData.options);

			newChartData = newChartData.map(function (eachChart) {
				var plot = (0, _utilsChartDataUtil.getChartPlotFor)(eachChart.config, eachChart.scaleType, newPlotData, startDomain[0], startDomain[1]);
				return {
					id: eachChart.id,
					config: eachChart.config,
					scaleType: eachChart.scaleType,
					plot: plot
				};
			});

			var newCurrentItems = (0, _utilsChartDataUtil.getCurrentItems)(newChartData, this.state.mouseXY, newPlotData);

			this.clearBothCanvas();
			this.clearInteractiveCanvas();

			// console.log(newPlotData.length);

			this.clearCanvasDrawCallbackList();

			this.setState({
				rawData: newRawData,
				data: transformedData.data,
				options: transformedData.options,
				chartData: newChartData,
				plotData: newPlotData,
				currentItems: newCurrentItems,
				canvases: null
			});
		}
	}, {
		key: "getDataInfo",
		value: function getDataInfo() {
			var interval = "D";
			var _state4 = this.state;
			var data = _state4.data;
			var plotData = _state4.plotData;
			var chartData = _state4.chartData;
			var mainChart = _state4.mainChart;

			var dataForInterval = data[interval];
			var mainChartData = chartData.filter(function (each) {
				return each.id === mainChart;
			})[0];
			var xAccessor = mainChartData.config.xAccessor;

			return {
				xAccessor: xAccessor,
				data: dataForInterval,
				fullData: {
					start: dataForInterval[0],
					end: dataForInterval[dataForInterval.length - 1]
				},
				viewData: {
					start: plotData[0],
					end: plotData[plotData.length - 1]
				}
			};
		}
	}, {
		key: "setViewRange",
		value: function setViewRange(domainL, domainR) {
			var _state5 = this.state;
			var data = _state5.data;
			var mainChart = _state5.mainChart;
			var chartData = _state5.chartData;
			var mouseXY = _state5.mouseXY;

			var chart = chartData.filter(function (eachChart) {
				return eachChart.id === mainChart;
			})[0];
			var dataToPlot = (0, _utilsChartDataUtil.getDataToPlotForDomain)(domainL, domainR, data, chart.config.width, chart.config.xAccessor);

			if (dataToPlot.data.length < 10) {
				console.warn("Ouch... too much zoom");
				return;
			}

			var newChartData = chartData.map(function (eachChart) {
				var plot = (0, _utilsChartDataUtil.getChartPlotFor)(eachChart.config, eachChart.scaleType, dataToPlot.data, domainL, domainR);
				return {
					id: eachChart.id,
					config: eachChart.config,
					scaleType: eachChart.scaleType,
					plot: plot
				};
			});

			var currentItems = (0, _utilsChartDataUtil.getCurrentItems)(newChartData, mouseXY, dataToPlot.data);

			this.clearBothCanvas();
			this.clearInteractiveCanvas();

			this.clearCanvasDrawCallbackList();
			this.setState({
				chartData: newChartData,
				plotData: dataToPlot.data,
				interval: dataToPlot.interval,
				currentItems: currentItems
			});
		}
	}, {
		key: "clearBothCanvas",
		value: function clearBothCanvas(props) {
			props = props || this.props;
			var canvases = props.canvasContexts();
			if (canvases && canvases.axes) {
				// console.log("CLEAR");
				this.clearCanvas([canvases.axes, canvases.mouseCoord]);
			}
		}
	}, {
		key: "clearInteractiveCanvas",
		value: function clearInteractiveCanvas(props) {
			props = props || this.props;
			var canvases = props.canvasContexts();
			if (canvases && canvases.interactive) {
				// console.error("CLEAR");
				this.clearCanvas([canvases.interactive]);
			}
		}
	}, {
		key: "clearCanvas",
		value: function clearCanvas(canvasList) {
			// console.log("CLEARING...", canvasList.length)
			canvasList.forEach(function (each) {
				// console.log(each.canvas.id);
				each.setTransform(1, 0, 0, 1, 0, 0);
				each.clearRect(-1, -1, each.canvas.width + 2, each.canvas.height + 2);
			});
		}
	}, {
		key: "getChildContext",
		value: function getChildContext() {
			return {
				plotData: this.state.plotData,
				chartData: this.state.chartData,
				currentItems: this.state.currentItems,
				mainChart: this.state.mainChart,
				show: this.state.show,
				mouseXY: this.state.mouseXY,
				interval: this.state.interval,
				currentCharts: this.state.currentCharts,
				width: this.props.dimensions.width,
				height: this.props.dimensions.height,
				chartCanvasType: this.props.type,
				dateAccessor: this.state.options.dateAccessor,

				margin: this.props.margin,
				dataTransform: this.props.dataTransform,
				interactiveState: this.state.interactiveState,

				callbackForCanvasDraw: this.pushCallbackForCanvasDraw,
				getAllCanvasDrawCallback: this.getAllCanvasDrawCallback,
				subscribe: this.subscribe,
				unsubscribe: this.unsubscribe,
				getCanvasContexts: this.getCanvasContexts,
				onMouseMove: this.handleMouseMove,
				onMouseEnter: this.handleMouseEnter,
				onMouseLeave: this.handleMouseLeave,
				onZoom: this.handleZoom,
				onPanStart: this.handlePanStart,
				onPan: this.handlePan,
				onPanEnd: this.handlePanEnd,
				onFocus: this.handleFocus,
				deltaXY: this.deltaXY,
				panInProgress: this.state.panInProgress,
				focus: this.state.focus
			};
		}
	}, {
		key: "pushCallbackForCanvasDraw",
		value: function pushCallbackForCanvasDraw(findThis, replaceWith) {
			var canvasDrawCallbackList = this.canvasDrawCallbackList;

			// console.log(findThis, canvasDrawCallbackList.length);
			if (replaceWith) {
				canvasDrawCallbackList.forEach(function (each, idx) {
					if (each === findThis) {
						canvasDrawCallbackList[idx] = replaceWith;
					}
				});
			} else {
				canvasDrawCallbackList.push(findThis);
			}
		}
	}, {
		key: "getAllCanvasDrawCallback",
		value: function getAllCanvasDrawCallback() {
			return this.canvasDrawCallbackList;
		}
	}, {
		key: "subscribe",
		value: function subscribe(forChart, eventType, callback) {
			subscriptionCount++;

			this.subscriptions.push({
				forChart: forChart,
				subscriptionId: subscriptionCount,
				eventType: eventType,
				callback: callback
			});
			return subscriptionCount;
		}
	}, {
		key: "unsubscribe",
		value: function unsubscribe(subscriptionId) {
			// console.log(subscriptionId);
			this.subscriptions = this.subscriptions.filter(function (each) {
				return each.subscriptionId === subscriptionId;
			});
		}
	}, {
		key: "handleMouseMove",
		value: function handleMouseMove(mouseXY, e) {
			var currentCharts = this.state.chartData.filter(function (chartData) {
				var top = chartData.config.origin[1];
				var bottom = top + chartData.config.height;
				return mouseXY[1] > top && mouseXY[1] < bottom;
			}).map(function (chartData) {
				return chartData.id;
			});
			var currentItems = (0, _utilsChartDataUtil.getCurrentItems)(this.state.chartData, mouseXY, this.state.plotData);

			var interactiveState = this.triggerCallback("mousemove", (0, _objectAssign2["default"])({}, this.state, { currentItems: currentItems, currentCharts: currentCharts }), this.state.interactiveState, e);

			var contexts = this.getCanvasContexts();

			if (contexts && contexts.mouseCoord) {
				this.clearCanvas([contexts.mouseCoord]);
			}
			// console.log(interactiveState === this.state.interactiveState);
			if (interactiveState !== this.state.interactiveState) this.clearInteractiveCanvas();

			this.setState({
				mouseXY: mouseXY,
				currentItems: currentItems,
				show: true,
				currentCharts: currentCharts,
				interactiveState: interactiveState
			});
		}
	}, {
		key: "getCanvasContexts",
		value: function getCanvasContexts() {
			// console.log(this.state.canvases, this.props.canvasContexts())
			return this.state.canvases || this.props.canvasContexts();
		}
	}, {
		key: "handleMouseEnter",
		value: function handleMouseEnter() {
			// if type === svg remove state.canvases
			// if type !== svg get canvases and set in state if state.canvases is not present already
			var _props4 = this.props;
			var type = _props4.type;
			var canvasContexts = _props4.canvasContexts;
			var canvases = this.state.canvases;

			if (type === "svg") {
				canvases = null;
			} else {
				canvases = canvasContexts();
			}
			this.setState({
				show: true,
				canvases: canvases
			});
		}
	}, {
		key: "handleMouseLeave",
		value: function handleMouseLeave() {
			var contexts = this.getCanvasContexts();

			if (contexts && contexts.mouseCoord) {
				this.clearCanvas([contexts.mouseCoord]);
			}

			this.setState({
				show: false
			});
		}
	}, {
		key: "handleZoom",
		value: function handleZoom(zoomDirection, mouseXY) {
			// console.log("zoomDirection ", zoomDirection, " mouseXY ", mouseXY);
			var _state6 = this.state;
			var data = _state6.data;
			var mainChart = _state6.mainChart;
			var chartData = _state6.chartData;
			var plotData = _state6.plotData;
			var interval = _state6.interval;

			var chart = chartData.filter(function (eachChart) {
				return eachChart.id === mainChart;
			})[0],
			    item = (0, _utilsChartDataUtil.getClosest)(plotData, mouseXY, chart),
			    xScale = chart.plot.scales.xScale,
			    domain = xScale.domain(),
			    centerX = chart.config.xAccessor(item),
			    leftX = centerX - domain[0],
			    rightX = domain[1] - centerX,
			    zoom = Math.pow(1 + Math.abs(zoomDirection) / 2, zoomDirection),
			    domainL = getLongValue(centerX) - leftX * zoom,
			    domainR = getLongValue(centerX) + rightX * zoom,
			    domainRange = Math.abs(domain[1] - domain[0]),
			    fullData = data[interval],
			    last = fullData[fullData.length - 1],
			    first = fullData[0];

			domainL = Math.max(getLongValue(chart.config.xAccessor(first)) - Math.floor(domainRange / 3), domainL);
			domainR = Math.min(getLongValue(chart.config.xAccessor(last)) + Math.floor(domainRange / 3), domainR);

			var dataToPlot = (0, _utilsChartDataUtil.getDataToPlotForDomain)(domainL, domainR, data, chart.config.width, chart.config.xAccessor);
			if (dataToPlot.data.length < 10) return;
			var newChartData = chartData.map(function (eachChart) {
				var plot = (0, _utilsChartDataUtil.getChartPlotFor)(eachChart.config, eachChart.scaleType, dataToPlot.data, domainL, domainR);
				return {
					id: eachChart.id,
					config: eachChart.config,
					scaleType: eachChart.scaleType,
					plot: plot
				};
			});

			var currentItems = (0, _utilsChartDataUtil.getCurrentItems)(newChartData, mouseXY, dataToPlot.data);

			this.clearBothCanvas();
			this.clearInteractiveCanvas();

			this.clearCanvasDrawCallbackList();
			this.setState({
				chartData: newChartData,
				plotData: dataToPlot.data,
				interval: dataToPlot.interval,
				currentItems: currentItems
			});
		}
	}, {
		key: "handlePanStart",
		value: function handlePanStart(panStartDomain, panOrigin) {
			// console.log("panStartDomain - ", panStartDomain, ", panOrigin - ", panOrigin);
			this.setState({
				panInProgress: true,
				panStartDomain: panStartDomain,
				panOrigin: panOrigin,
				focus: true
			});
			this.panHappened = false;
		}
	}, {
		key: "panHelper",
		value: function panHelper(mousePosition) {
			var _state7 = this.state;
			var data = _state7.data;
			var mainChart = _state7.mainChart;
			var chartData = _state7.chartData;
			var interval = _state7.interval;
			var panStartDomain = _state7.panStartDomain;
			var panOrigin = _state7.panOrigin;

			var chart = chartData.filter(function (eachChart) {
				return eachChart.id === mainChart;
			})[0],
			    domainRange = panStartDomain[1] - panStartDomain[0],
			    dataForInterval = data[interval],
			    last = dataForInterval[dataForInterval.length - 1],
			    first = dataForInterval[0],
			    dx = mousePosition[0] - panOrigin[0],
			    xAccessor = chart.config.xAccessor;

			// console.log("pan -- mouse move - ", mousePosition, " dragged by ", dx, " pixels");

			var domainStart = getLongValue(panStartDomain[0]) - dx / chart.config.width * domainRange;
			if (domainStart < getLongValue(xAccessor(first)) - Math.floor(domainRange / 3)) {
				domainStart = getLongValue(xAccessor(first)) - Math.floor(domainRange / 3);
			} else {
				domainStart = Math.min(getLongValue(xAccessor(last)) + Math.ceil(domainRange / 3), domainStart + domainRange) - domainRange;
			}
			var domainL = domainStart,
			    domainR = domainStart + domainRange;
			if (panStartDomain[0] instanceof Date) {
				domainL = new Date(domainL);
				domainR = new Date(domainR);
			}

			var beginIndex = (0, _utilsUtils.getClosestItemIndexes)(dataForInterval, domainL, xAccessor).left;
			var endIndex = (0, _utilsUtils.getClosestItemIndexes)(dataForInterval, domainR, xAccessor).right;

			var filteredData = dataForInterval.slice(beginIndex, endIndex);

			var newChartData = chartData.map(function (eachChart) {
				var plot = (0, _utilsChartDataUtil.getChartPlotFor)(eachChart.config, eachChart.scaleType, filteredData, domainL, domainR);
				return {
					id: eachChart.id,
					config: eachChart.config,
					scaleType: eachChart.scaleType,
					plot: plot
				};
			});
			var currentItems = (0, _utilsChartDataUtil.getCurrentItems)(newChartData, mousePosition, filteredData);

			var currentCharts = newChartData.filter(function (eachChartData) {
				var top = eachChartData.config.origin[1];
				var bottom = top + eachChartData.config.height;
				return mousePosition[1] > top && mousePosition[1] < bottom;
			}).map(function (eachChartData) {
				return eachChartData.id;
			});
			return {
				plotData: filteredData,
				// show: true,
				mouseXY: mousePosition,
				currentCharts: currentCharts,
				chartData: newChartData,
				currentItems: currentItems
			};
		}
	}, {
		key: "getCurrentCanvasContext",
		value: function getCurrentCanvasContext(canvasList, chartId) {
			var canvasContextList = canvasList.filter(function (each) {
				return parseInt(each.id, 10) === chartId;
			});
			var canvasContext = canvasContextList.length > 0 ? canvasContextList[0].context : undefined;
			return canvasContext;
		}
	}, {
		key: "handlePan",
		value: function handlePan(mousePosition, startDomain) {
			var _this2 = this;

			/* can also use plotData, use this if you want to pan and show only within that data set*/
			if (this.state.panStartDomain === null) {
				this.handlePanStart(startDomain, mousePosition);
			} else {

				this.panHappened = true;
				var state = this.panHelper(mousePosition);

				if (this.props.type !== "svg") {
					var _getCanvasContexts = this.getCanvasContexts();

					var axesCanvasContext = _getCanvasContexts.axes;
					var mouseContext = _getCanvasContexts.mouseCoord;
					var chartData = state.chartData;
					var plotData = state.plotData;
					var show = this.state.show;
					var canvasDrawCallbackList = this.canvasDrawCallbackList;

					requestAnimationFrame(function () {
						// this.clearCanvas([axesCanvasContext, mouseContext]);
						// this.clearCanvas([axesCanvasContext, mouseContext]);
						_this2.clearBothCanvas();
						_this2.clearInteractiveCanvas();

						// console.log(canvasDrawCallbackList.length)

						chartData.forEach(function (eachChart) {
							canvasDrawCallbackList.filter(function (each) {
								return eachChart.id === each.chartId;
							}).forEach(function (each) {
								var _eachChart$plot$scales = eachChart.plot.scales;
								var xScale = _eachChart$plot$scales.xScale;
								var yScale = _eachChart$plot$scales.yScale;

								var overlayPresent = eachChart.config.overlays.filter(function (eachOverlay) {
									return eachOverlay.id === each.seriesId;
								}).length > 0;
								/* .forEach(eachOverlay => {
        	// console.log("Do Stuff here", i);
        	var { xAccessor } = eachChart.config;
        	// xScale, yScale, plotData
        	each.draw(axesCanvasContext, xScale, yScale, plotData);
        }); */
								if (overlayPresent) {
									each.draw(axesCanvasContext, xScale, yScale, plotData);
								}

								if (each.type === "axis") {
									each.draw(axesCanvasContext, eachChart, xScale, yScale);
								}
							});
						});
						_this2.drawInteractive(state);
						canvasDrawCallbackList.filter(function (each) {
							return each.chartId === undefined;
						}).filter(function (each) {
							return each.type === "axis";
						}).forEach(function (each) {
							return each.draw(axesCanvasContext, chartData);
						});

						canvasDrawCallbackList.filter(function (each) {
							return each.type === "mouse";
						}).forEach(function (each) {
							return each.draw(mouseContext, show, state.mouseXY, state.currentCharts, state.chartData, state.currentItems);
						});

						canvasDrawCallbackList.filter(function (each) {
							return each.type === "currentcoordinate";
						}).forEach(function (each) {
							return each.draw(mouseContext, show, state.mouseXY, state.currentCharts, state.chartData, state.currentItems);
						});
					});
				} else {
					this.setState(state);
				}
			}
		}
	}, {
		key: "drawInteractive",
		value: function drawInteractive(_ref) {
			var plotData = _ref.plotData;
			var chartData = _ref.chartData;

			var _getCanvasContexts2 = this.getCanvasContexts();

			var interactive = _getCanvasContexts2.interactive;

			// console.log(interactive);
			this.canvasDrawCallbackList.filter(function (each) {
				return each.type === "interactive";
			}).forEach(function (each) {
				chartData.filter(function (eachChart) {
					return eachChart.id === each.chartId;
				}).forEach(function (eachChart) {
					each.draw(interactive, { plotData: plotData, chartData: eachChart });
					// console.log("DRAW");
				});
			});
		}
	}, {
		key: "clearCanvasDrawCallbackList",
		value: function clearCanvasDrawCallbackList() {
			this.canvasDrawCallbackList = [];
		}
	}, {
		key: "handlePanEnd",
		value: function handlePanEnd(mousePosition, e) {
			var state = this.panHelper(mousePosition);

			this.clearCanvasDrawCallbackList();

			var interactiveState = this.panHappened ? this.triggerCallback("panend", state, this.state.interactiveState, e) : this.triggerCallback("click", state, this.state.interactiveState, e);

			this.clearBothCanvas();
			if (interactiveState !== this.state.interactive) this.clearInteractiveCanvas();

			// console.log(interactiveState[0].interactive);
			this.setState((0, _objectAssign2["default"])({}, state, {
				show: this.state.show,
				panInProgress: false,
				panStartDomain: null,
				interactiveState: interactiveState
			}));
		}
	}, {
		key: "triggerCallback",
		value: function triggerCallback(eventType, state, interactiveState, event) {
			var plotData = state.plotData;
			var mouseXY = state.mouseXY;
			var currentCharts = state.currentCharts;
			var chartData = state.chartData;
			var currentItems = state.currentItems;

			var callbackList = this.subscriptions.filter(function (each) {
				return each.eventType === eventType;
			});
			var delta = callbackList.map(function (each) {
				// console.log(each);
				var singleChartData = chartData.filter(function (eachItem) {
					return eachItem.id === each.forChart;
				})[0];
				var singleCurrentItem = currentItems.filter(function (eachItem) {
					return eachItem.id === each.forChart;
				})[0];
				return {
					callback: each.callback,
					forChart: each.forChart,
					plotData: plotData,
					mouseXY: mouseXY,
					currentCharts: currentCharts,
					currentItem: singleCurrentItem.data,
					chartData: singleChartData
				};
			}).filter(function (each) {
				return each.currentCharts.indexOf(each.forChart) >= -1;
			}).map(function (each) {
				return each.callback({
					plotData: each.plotData,
					mouseXY: each.mouseXY,
					chartData: each.chartData,
					currentItem: each.currentItem
				}, event);
			});

			// console.log(delta.length);
			if (delta.length === 0) return interactiveState;

			var i = 0,
			    j = 0,
			    added = false;
			var newInteractiveState = interactiveState.slice(0);
			for (i = 0; i < delta.length; i++) {
				var each = delta[i];
				for (j = 0; j < newInteractiveState.length; j++) {
					if (each.id === newInteractiveState[j].id) {
						newInteractiveState[j] = each;
						added = true;
					}
				}
				if (!added) newInteractiveState.push(each);
				added = false;
			}
			return newInteractiveState;
		}
	}, {
		key: "handleFocus",
		value: function handleFocus(focus) {
			// console.log(focus);interactive
			this.setState({
				focus: focus
			});
		}
	}, {
		key: "render",
		value: function render() {
			var _this3 = this;

			var children = _react2["default"].Children.map(this.props.children, function (child) {
				var newChild = (0, _utilsUtils.isReactVersion13)() ? _react2["default"].withContext(_this3.getChildContext(), function () {
					return _react2["default"].createElement(child.type, (0, _objectAssign2["default"])({ key: child.key, ref: child.ref }, child.props));
				}) : child;

				return newChild;
			});
			return _react2["default"].createElement(
				"g",
				null,
				children
			);
		}
	}]);

	return EventHandler;
})(_utilsPureComponent2["default"]);

EventHandler.defaultProps = {
	defaultDataTransform: [{ transform: _transforms.DummyTransformer }]
};

EventHandler.childContextTypes = {
	plotData: _react2["default"].PropTypes.array,
	chartData: _react2["default"].PropTypes.array,
	currentItems: _react2["default"].PropTypes.array,
	show: _react2["default"].PropTypes.bool,
	mouseXY: _react2["default"].PropTypes.array,
	interval: _react2["default"].PropTypes.string,
	currentCharts: _react2["default"].PropTypes.array,
	mainChart: _react2["default"].PropTypes.number,
	width: _react2["default"].PropTypes.number.isRequired,
	height: _react2["default"].PropTypes.number.isRequired,
	chartCanvasType: _react2["default"].PropTypes.oneOf(["svg", "hybrid"]).isRequired,
	dateAccessor: _react2["default"].PropTypes.func,

	margin: _react2["default"].PropTypes.object.isRequired,
	dataTransform: _react2["default"].PropTypes.array,
	interactiveState: _react2["default"].PropTypes.array.isRequired,

	subscribe: _react2["default"].PropTypes.func,
	unsubscribe: _react2["default"].PropTypes.func,
	callbackForCanvasDraw: _react2["default"].PropTypes.func,
	getAllCanvasDrawCallback: _react2["default"].PropTypes.func,
	getCanvasContexts: _react2["default"].PropTypes.func,
	onMouseMove: _react2["default"].PropTypes.func,
	onMouseEnter: _react2["default"].PropTypes.func,
	onMouseLeave: _react2["default"].PropTypes.func,
	onZoom: _react2["default"].PropTypes.func,
	onPanStart: _react2["default"].PropTypes.func,
	onPan: _react2["default"].PropTypes.func,
	onPanEnd: _react2["default"].PropTypes.func,
	panInProgress: _react2["default"].PropTypes.bool.isRequired,
	focus: _react2["default"].PropTypes.bool.isRequired,
	onFocus: _react2["default"].PropTypes.func,
	deltaXY: _react2["default"].PropTypes.func
};

exports["default"] = EventHandler;
module.exports = exports["default"];