"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _AxisTicks = require("./AxisTicks");

var _AxisTicks2 = _interopRequireDefault(_AxisTicks);

var _AxisLine = require("./AxisLine");

var _AxisLine2 = _interopRequireDefault(_AxisLine);

var Axis = (function (_React$Component) {
	_inherits(Axis, _React$Component);

	function Axis(props) {
		_classCallCheck(this, Axis);

		_get(Object.getPrototypeOf(Axis.prototype), "constructor", this).call(this, props);
		this.drawOnCanvas = this.drawOnCanvas.bind(this);
	}

	_createClass(Axis, [{
		key: "componentWillMount",
		value: function componentWillMount() {
			this.componentWillReceiveProps(this.props, this.context);
		}
	}, {
		key: "componentWillReceiveProps",
		value: function componentWillReceiveProps(nextProps, nextContext) {
			var margin = nextContext.margin;
			var chartId = nextContext.chartId;
			var canvasOriginX = nextContext.canvasOriginX;
			var canvasOriginY = nextContext.canvasOriginY;

			var draw = Axis.drawOnCanvasStatic.bind(null, margin, nextProps, [canvasOriginX, canvasOriginY]);

			nextContext.callbackForCanvasDraw({
				chartId: chartId,
				type: "axis",
				draw: draw
			});
		}
	}, {
		key: "componentDidMount",
		value: function componentDidMount() {
			if (this.context.chartCanvasType !== "svg" && this.context.getCanvasContexts !== undefined) {
				var contexts = this.context.getCanvasContexts();
				if (contexts) this.drawOnCanvas(contexts.axes);
			}
		}
	}, {
		key: "componentDidUpdate",
		value: function componentDidUpdate() {
			this.componentDidMount();
		}
	}, {
		key: "drawOnCanvas",
		value: function drawOnCanvas(ctx) {
			var _context = this.context;
			var chartData = _context.chartData;
			var margin = _context.margin;
			var canvasOriginX = _context.canvasOriginX;
			var canvasOriginY = _context.canvasOriginY;
			var scale = this.props.scale;

			Axis.drawOnCanvasStatic(margin, this.props, [canvasOriginX, canvasOriginY], ctx, chartData, scale, scale);
		}
	}, {
		key: "render",
		value: function render() {
			if (this.context.chartCanvasType !== "svg") return null;

			var domain = this.props.showDomain ? _react2["default"].createElement(_AxisLine2["default"], this.props) : null;
			var ticks = this.props.showTicks ? _react2["default"].createElement(_AxisTicks2["default"], this.props) : null;
			var className = "";
			if (this.props.className) className = this.props.defaultClassName.concat(this.props.className);
			return _react2["default"].createElement(
				"g",
				{ className: className,
					transform: "translate(" + this.props.transform[0] + ", " + this.props.transform[1] + ")" },
				ticks,
				domain
			);
		}
	}]);

	return Axis;
})(_react2["default"].Component);

Axis.propTypes = {
	className: _react2["default"].PropTypes.string.isRequired,
	defaultClassName: _react2["default"].PropTypes.string.isRequired,
	transform: _react2["default"].PropTypes.arrayOf(Number).isRequired,
	orient: _react2["default"].PropTypes.oneOf(["top", "bottom", "left", "right"]).isRequired,
	innerTickSize: _react2["default"].PropTypes.number,
	outerTickSize: _react2["default"].PropTypes.number,
	tickFormat: _react2["default"].PropTypes.func,
	tickPadding: _react2["default"].PropTypes.number,
	tickSize: _react2["default"].PropTypes.number,
	ticks: _react2["default"].PropTypes.array,
	tickValues: _react2["default"].PropTypes.array,
	scale: _react2["default"].PropTypes.func.isRequired,
	showDomain: _react2["default"].PropTypes.bool.isRequired,
	showTicks: _react2["default"].PropTypes.bool.isRequired,
	fontFamily: _react2["default"].PropTypes.string,
	fontSize: _react2["default"].PropTypes.number.isRequired
};

Axis.defaultProps = {
	defaultClassName: "react-stockcharts-axis ",
	showDomain: true,
	showTicks: true,
	fontFamily: "Helvetica Neue, Helvetica, Arial, sans-serif",
	fontSize: 12
};

Axis.contextTypes = {
	getCanvasContexts: _react2["default"].PropTypes.func,
	chartCanvasType: _react2["default"].PropTypes.string,
	chartData: _react2["default"].PropTypes.object.isRequired,
	chartId: _react2["default"].PropTypes.number.isRequired,
	margin: _react2["default"].PropTypes.object.isRequired,
	canvasOriginX: _react2["default"].PropTypes.number,
	canvasOriginY: _react2["default"].PropTypes.number,
	// secretToSuperFastCanvasDraw: React.PropTypes.array.isRequired,
	callbackForCanvasDraw: _react2["default"].PropTypes.func.isRequired
};

Axis.drawOnCanvasStatic = function (margin, props, canvasOrigin, ctx, chartData, xScale, yScale) {
	var transform = props.transform;
	var showDomain = props.showDomain;
	var showTicks = props.showTicks;

	ctx.save();

	ctx.setTransform(1, 0, 0, 1, 0, 0);
	ctx.translate(canvasOrigin[0] + transform[0], canvasOrigin[1] + transform[1]);

	if (showDomain) _AxisLine2["default"].drawOnCanvasStatic(props, ctx, chartData, xScale, yScale);
	if (showTicks) _AxisTicks2["default"].drawOnCanvasStatic(props, ctx, chartData, xScale, yScale);

	ctx.restore();
};

exports["default"] = Axis;
module.exports = exports["default"];