"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _objectAssign = require("object-assign");

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _utilsUtils = require("../utils/utils");

function d3_scaleExtent(domain) {
	var start = domain[0],
	    stop = domain[domain.length - 1];
	return start < stop ? [start, stop] : [stop, start];
}

function d3_scaleRange(scale) {
	return scale.rangeExtent ? scale.rangeExtent() : d3_scaleExtent(scale.range());
}

var AxisLine = (function (_React$Component) {
	_inherits(AxisLine, _React$Component);

	function AxisLine() {
		_classCallCheck(this, AxisLine);

		_get(Object.getPrototypeOf(AxisLine.prototype), "constructor", this).apply(this, arguments);
	}

	_createClass(AxisLine, [{
		key: "render",
		value: function render() {
			var _props = this.props;
			var orient = _props.orient;
			var scale = _props.scale;
			var outerTickSize = _props.outerTickSize;
			var fill = _props.fill;
			var stroke = _props.stroke;
			var strokeWidth = _props.strokeWidth;
			var className = _props.className;
			var shapeRendering = _props.shapeRendering;
			var opacity = _props.opacity;

			var sign = orient === "top" || orient === "left" ? -1 : 1;

			var range = d3_scaleRange(scale);

			var d;

			if (orient === "bottom" || orient === "top") {
				d = "M" + range[0] + "," + sign * outerTickSize + "V0H" + range[1] + "V" + sign * outerTickSize;
			} else {
				d = "M" + sign * outerTickSize + "," + range[0] + "H0V" + range[1] + "H" + sign * outerTickSize;
			}

			return _react2["default"].createElement("path", {
				className: className,
				shapeRendering: shapeRendering,
				d: d,
				fill: fill,
				opacity: opacity,
				stroke: stroke,
				strokeWidth: strokeWidth });
		}
	}]);

	return AxisLine;
})(_react2["default"].Component);

AxisLine.propTypes = {
	className: _react2["default"].PropTypes.string,
	shapeRendering: _react2["default"].PropTypes.string,
	orient: _react2["default"].PropTypes.string.isRequired,
	scale: _react2["default"].PropTypes.func.isRequired,
	outerTickSize: _react2["default"].PropTypes.number,
	fill: _react2["default"].PropTypes.string,
	stroke: _react2["default"].PropTypes.string,
	strokeWidth: _react2["default"].PropTypes.number,
	opacity: _react2["default"].PropTypes.number
};

AxisLine.defaultProps = {
	className: "react-stockcharts-axis-line",
	shapeRendering: "crispEdges",
	outerTickSize: 6,
	fill: "none",
	stroke: "#000000",
	strokeWidth: 1,
	opacity: 1
};

AxisLine.drawOnCanvasStatic = function (props, ctx, chartData, xScale, yScale) {
	props = (0, _objectAssign2["default"])({}, AxisLine.defaultProps, props);

	var _props2 = props;
	var orient = _props2.orient;
	var outerTickSize = _props2.outerTickSize;
	var stroke = _props2.stroke;
	var strokeWidth = _props2.strokeWidth;
	var opacity = _props2.opacity;

	var sign = orient === "top" || orient === "left" ? -1 : 1;
	var xAxis = orient === "bottom" || orient === "top";

	var range = d3_scaleRange(xAxis ? xScale : yScale);

	ctx.lineWidth = strokeWidth;
	ctx.strokeStyle = (0, _utilsUtils.hexToRGBA)(stroke, opacity);

	ctx.beginPath();

	if (xAxis) {
		ctx.moveTo(range[0], sign * outerTickSize);
		ctx.lineTo(range[0], 0);
		ctx.lineTo(range[1], 0);
		ctx.lineTo(range[1], sign * outerTickSize);
	} else {
		ctx.moveTo(sign * outerTickSize, range[0]);
		ctx.lineTo(0, range[0]);
		ctx.lineTo(0, range[1]);
		ctx.lineTo(sign * outerTickSize, range[1]);
	}
	ctx.stroke();

	// ctx.strokeStyle = strokeStyle;
};

exports["default"] = AxisLine;
module.exports = exports["default"];