"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _Axis = require("./Axis");

var _Axis2 = _interopRequireDefault(_Axis);

var _utilsPureComponent = require("../utils/PureComponent");

var _utilsPureComponent2 = _interopRequireDefault(_utilsPureComponent);

var XAxis = (function (_PureComponent) {
	_inherits(XAxis, _PureComponent);

	function XAxis() {
		_classCallCheck(this, XAxis);

		_get(Object.getPrototypeOf(XAxis.prototype), "constructor", this).apply(this, arguments);
	}

	_createClass(XAxis, [{
		key: "render",
		value: function render() {
			var _props = this.props;
			var axisAt = _props.axisAt;
			var showTicks = _props.showTicks;
			var tickFormat = _props.tickFormat;
			var ticks = _props.ticks;

			var axisLocation;
			if (axisAt === "top") axisLocation = 0;else if (axisAt === "bottom") axisLocation = this.context.height;else if (axisAt === "middle") axisLocation = this.context.height / 2;else axisLocation = axisAt;

			if (tickFormat && this.context.xScale.isPolyLinear && this.context.xScale.isPolyLinear()) {
				console.warn("Cannot set tickFormat on a poly linear scale, ignoring tickFormat on XAxis");
				tickFormat = undefined;
			}

			if (ticks) ticks = [ticks];
			return _react2["default"].createElement(_Axis2["default"], _extends({}, this.props, {
				transform: [0, axisLocation],
				showTicks: showTicks, tickFormat: tickFormat, ticks: ticks,
				scale: this.context.xScale }));
		}
	}]);

	return XAxis;
})(_utilsPureComponent2["default"]);

XAxis.propTypes = {
	axisAt: _react2["default"].PropTypes.oneOfType([_react2["default"].PropTypes.oneOf(["top", "bottom", "middle"]), _react2["default"].PropTypes.number]).isRequired,
	orient: _react2["default"].PropTypes.oneOf(["top", "bottom"]).isRequired,
	innerTickSize: _react2["default"].PropTypes.number,
	outerTickSize: _react2["default"].PropTypes.number,
	tickFormat: _react2["default"].PropTypes.func,
	tickPadding: _react2["default"].PropTypes.number,
	tickSize: _react2["default"].PropTypes.number,
	ticks: _react2["default"].PropTypes.number,
	tickValues: _react2["default"].PropTypes.array,
	showTicks: _react2["default"].PropTypes.bool,
	className: _react2["default"].PropTypes.string
};
XAxis.defaultProps = {
	namespace: "ReStock.XAxis",
	showGrid: false,
	showTicks: true,
	className: "react-stockcharts-x-axis",
	ticks: 10
};

XAxis.contextTypes = {
	xScale: _react2["default"].PropTypes.func.isRequired,
	yScale: _react2["default"].PropTypes.func.isRequired,
	height: _react2["default"].PropTypes.number.isRequired,
	width: _react2["default"].PropTypes.number.isRequired
};

exports["default"] = XAxis;
module.exports = exports["default"];