"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _d3 = require("d3");

var _d32 = _interopRequireDefault(_d3);

var _Axis = require("./Axis");

var _Axis2 = _interopRequireDefault(_Axis);

var _utilsPureComponent = require("../utils/PureComponent");

var _utilsPureComponent2 = _interopRequireDefault(_utilsPureComponent);

var YAxis = (function (_PureComponent) {
	_inherits(YAxis, _PureComponent);

	function YAxis() {
		_classCallCheck(this, YAxis);

		_get(Object.getPrototypeOf(YAxis.prototype), "constructor", this).apply(this, arguments);
	}

	_createClass(YAxis, [{
		key: "render",
		value: function render() {
			var _props = this.props;
			var axisAt = _props.axisAt;
			var tickFormat = _props.tickFormat;
			var ticks = _props.ticks;
			var percentScale = _props.percentScale;
			var tickValues = _props.tickValues;
			var _context = this.context;
			var yScale = _context.yScale;
			var chartData = _context.chartData;

			if (percentScale) yScale = yScale.copy().domain([0, 1]);

			tickValues = tickValues || chartData.config.yTicks;

			var axisLocation;

			if (axisAt === "left") axisLocation = 0;else if (axisAt === "right") axisLocation = this.context.width;else if (axisAt === "middle") axisLocation = this.context.width / 2;else axisLocation = axisAt;

			if (this.context.compareSeries.length > 0) {
				tickFormat = _d32["default"].format(".0%");
			}

			return _react2["default"].createElement(_Axis2["default"], _extends({}, this.props, {
				transform: [axisLocation, 0],
				tickFormat: tickFormat, ticks: [ticks], tickValues: tickValues,
				scale: yScale }));
		}
	}]);

	return YAxis;
})(_utilsPureComponent2["default"]);

YAxis.propTypes = {
	axisAt: _react2["default"].PropTypes.oneOfType([_react2["default"].PropTypes.oneOf(["left", "right", "middle"]), _react2["default"].PropTypes.number]).isRequired,
	orient: _react2["default"].PropTypes.oneOf(["left", "right"]).isRequired,
	innerTickSize: _react2["default"].PropTypes.number,
	outerTickSize: _react2["default"].PropTypes.number,
	tickFormat: _react2["default"].PropTypes.func,
	tickPadding: _react2["default"].PropTypes.number,
	tickSize: _react2["default"].PropTypes.number,
	ticks: _react2["default"].PropTypes.number,
	tickValues: _react2["default"].PropTypes.array,
	percentScale: _react2["default"].PropTypes.bool,
	showTicks: _react2["default"].PropTypes.bool,
	showDomain: _react2["default"].PropTypes.bool,
	className: _react2["default"].PropTypes.string
};
YAxis.defaultProps = {
	namespace: "ReStock.YAxis",
	showGrid: false,
	showDomain: false,
	className: "react-stockcharts-y-axis",
	ticks: 10
};
YAxis.contextTypes = {
	chartData: _react2["default"].PropTypes.object.isRequired,
	xScale: _react2["default"].PropTypes.func.isRequired,
	yScale: _react2["default"].PropTypes.func.isRequired,
	width: _react2["default"].PropTypes.number.isRequired,
	compareSeries: _react2["default"].PropTypes.array.isRequired
};

exports["default"] = YAxis;
module.exports = exports["default"];