"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _pure = require("../pure");

var _pure2 = _interopRequireDefault(_pure);

var CurrentCoordinate = (function (_React$Component) {
	_inherits(CurrentCoordinate, _React$Component);

	function CurrentCoordinate() {
		_classCallCheck(this, CurrentCoordinate);

		_get(Object.getPrototypeOf(CurrentCoordinate.prototype), "constructor", this).apply(this, arguments);
	}

	_createClass(CurrentCoordinate, [{
		key: "componentDidMount",
		value: function componentDidMount() {
			var _props = this.props;
			var chartCanvasType = _props.chartCanvasType;
			var getCanvasContexts = _props.getCanvasContexts;

			if (chartCanvasType !== "svg" && getCanvasContexts !== undefined) {
				var contexts = getCanvasContexts();
				if (contexts) CurrentCoordinate.drawOnCanvas(contexts.mouseCoord, this.props);
			}
		}
	}, {
		key: "componentDidUpdate",
		value: function componentDidUpdate() {
			this.componentDidMount();
		}
	}, {
		key: "componentWillMount",
		value: function componentWillMount() {
			this.componentWillReceiveProps(this.props);
		}
	}, {
		key: "componentWillReceiveProps",
		value: function componentWillReceiveProps(nextProps) {
			var draw = CurrentCoordinate.drawOnCanvasStatic.bind(null, nextProps);

			var forChart = nextProps.forChart;
			var forCompareSeries = nextProps.forCompareSeries;
			var forDataSeries = nextProps.forDataSeries;

			var temp = nextProps.getAllCanvasDrawCallback().filter(function (each) {
				return each.type === "currentcoordinate" && each.forChart === forChart && each.forDataSeries === forDataSeries;
			}).filter(function (each) {
				return each.forCompareSeries === forCompareSeries;
			});

			if (temp.length === 0) {
				nextProps.callbackForCanvasDraw({
					type: "currentcoordinate",
					forChart: forChart,
					forDataSeries: forDataSeries,
					forCompareSeries: forCompareSeries,
					draw: draw
				});
			} else {
				nextProps.callbackForCanvasDraw(temp[0], {
					type: "currentcoordinate",
					forChart: forChart,
					forDataSeries: forDataSeries,
					forCompareSeries: forCompareSeries,
					draw: draw
				});
			}
		}
	}, {
		key: "render",
		value: function render() {
			var className = this.props.className;
			var _props2 = this.props;
			var chartCanvasType = _props2.chartCanvasType;
			var show = _props2.show;
			var chartData = _props2.chartData;
			var currentItems = _props2.currentItems;

			if (chartCanvasType !== "svg") return null;

			var circle = CurrentCoordinate.helper(this.props, show, chartData, currentItems);

			if (!circle) return null;

			return _react2["default"].createElement("circle", { className: className, cx: circle.x, cy: circle.y, r: circle.r, fill: circle.fill });
		}
	}]);

	return CurrentCoordinate;
})(_react2["default"].Component);

CurrentCoordinate.propTypes = {
	forChart: _react2["default"].PropTypes.number.isRequired,
	forDataSeries: _react2["default"].PropTypes.number.isRequired,
	forCompareSeries: _react2["default"].PropTypes.number,
	yAccessor: _react2["default"].PropTypes.func,
	r: _react2["default"].PropTypes.number.isRequired,
	className: _react2["default"].PropTypes.string,

	chartCanvasType: _react2["default"].PropTypes.string,
	getCanvasContexts: _react2["default"].PropTypes.func,
	show: _react2["default"].PropTypes.bool,
	chartData: _react2["default"].PropTypes.array,
	currentItems: _react2["default"].PropTypes.array
};

CurrentCoordinate.defaultProps = {
	r: 3,
	className: "react-stockcharts-current-coordinate"
};

CurrentCoordinate.drawOnCanvas = function (canvasContext, props) {
	var mouseXY = props.mouseXY;
	var currentCharts = props.currentCharts;
	var chartData = props.chartData;
	var currentItems = props.currentItems;
	var show = props.show;

	CurrentCoordinate.drawOnCanvasStatic(props, canvasContext, show, mouseXY, currentCharts, chartData, currentItems);
};

CurrentCoordinate.drawOnCanvasStatic = function (props, ctx, show, mouseXY, currentCharts, chartData, currentItems) {
	var margin = props.margin;

	var circle = CurrentCoordinate.helper(props, show, chartData, currentItems);

	if (!circle) return null;

	var originX = 0.5 + margin.left;
	var originY = 0.5 + margin.top;

	ctx.save();

	ctx.setTransform(1, 0, 0, 1, 0, 0);
	ctx.translate(originX, originY);

	ctx.fillStyle = circle.fill;
	ctx.beginPath();
	ctx.arc(circle.x, circle.y, circle.r, 0, 2 * Math.PI, false);
	ctx.fill();
	// CurrentCoordinate.drawOnCanvasStatic(ctx, pointer);
	ctx.restore();
};

CurrentCoordinate.helper = function (props, show, chartData, currentItems) {
	var forChart = props.forChart;
	var forCompareSeries = props.forCompareSeries;
	var forDataSeries = props.forDataSeries;
	var r = props.r;

	var chartData = chartData.filter(function (each) {
		return each.id === forChart;
	})[0];
	var currentItem = currentItems.filter(function (each) {
		return each.id === forChart;
	})[0];
	var item = currentItem ? currentItem.data : undefined;
	var fill = "black";

	if (!show || item === undefined) return null;
	var yAccessor;

	if (forCompareSeries !== undefined) {
		var compSeries = chartData.config.compareSeries.filter(function (each) {
			return each.id === forCompareSeries;
		});

		if (compSeries.length !== 1) {
			console.warn("Unique compareSeries with id={%s} not found", forCompareSeries);
			throw new Error("Unique compareSeries not found");
		}
		fill = compSeries[0].stroke;
		yAccessor = compSeries[0].percentYAccessor;
	} else if (forDataSeries !== undefined) {
		var overlays = chartData.config.overlays.filter(function (each) {
			return each.id === forDataSeries;
		});

		if (overlays.length !== 1) {
			console.warn("Unique DataSeries with id={%s} not found", forDataSeries);
			throw new Error("Unique DataSeries not found");
		}

		fill = overlays[0].stroke;

		yAccessor = overlays[0].yAccessor;
	}

	var xValue = chartData.config.xAccessor(item);
	var yValue = yAccessor(item);

	if (yValue === undefined) return null;

	var x = Math.round(chartData.plot.scales.xScale(xValue)) + chartData.config.origin[0];
	var y = Math.round(chartData.plot.scales.yScale(yValue)) + chartData.config.origin[1];

	return { x: x, y: y, r: r, fill: fill };
};

exports["default"] = (0, _pure2["default"])(CurrentCoordinate, {
	show: _react2["default"].PropTypes.bool.isRequired,
	currentItems: _react2["default"].PropTypes.array.isRequired,
	chartData: _react2["default"].PropTypes.array.isRequired,

	getCanvasContexts: _react2["default"].PropTypes.func,
	margin: _react2["default"].PropTypes.object.isRequired,
	callbackForCanvasDraw: _react2["default"].PropTypes.func.isRequired,
	getAllCanvasDrawCallback: _react2["default"].PropTypes.func,
	chartCanvasType: _react2["default"].PropTypes.string.isRequired
});
module.exports = exports["default"];