"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _d3 = require("d3");

var _d32 = _interopRequireDefault(_d3);

var _EdgeCoordinate = require("./EdgeCoordinate");

var _EdgeCoordinate2 = _interopRequireDefault(_EdgeCoordinate);

var _utilsPureComponent = require("../utils/PureComponent");

var _utilsPureComponent2 = _interopRequireDefault(_utilsPureComponent);

var _utilsUtils = require("../utils/utils");

var _utilsChartDataUtil = require("../utils/ChartDataUtil");

var EdgeIndicator = (function (_PureComponent) {
	_inherits(EdgeIndicator, _PureComponent);

	function EdgeIndicator(props, context) {
		_classCallCheck(this, EdgeIndicator);

		_get(Object.getPrototypeOf(EdgeIndicator.prototype), "constructor", this).call(this, props, context);
		this.drawOnCanvas = this.drawOnCanvas.bind(this);
	}

	_createClass(EdgeIndicator, [{
		key: "componentDidMount",
		value: function componentDidMount() {
			var _context = this.context;
			var chartCanvasType = _context.chartCanvasType;
			var getCanvasContexts = _context.getCanvasContexts;

			if (chartCanvasType !== "svg" && getCanvasContexts !== undefined) {
				var contexts = getCanvasContexts();
				if (contexts) this.drawOnCanvas(contexts.axes);
			}
		}
	}, {
		key: "componentDidUpdate",
		value: function componentDidUpdate() {
			this.componentDidMount();
		}
	}, {
		key: "componentWillMount",
		value: function componentWillMount() {
			this.componentWillReceiveProps(this.props, this.context);
		}
	}, {
		key: "componentWillReceiveProps",
		value: function componentWillReceiveProps(nextProps, nextContext) {
			var margin = nextContext.margin;
			var width = nextContext.width;

			var draw = EdgeIndicator.drawOnCanvasStatic.bind(null, margin, nextProps, width);

			nextContext.callbackForCanvasDraw({
				type: "axis",
				draw: draw
			});
		}
	}, {
		key: "drawOnCanvas",
		value: function drawOnCanvas(ctx) {
			var _context2 = this.context;
			var chartData = _context2.chartData;
			var margin = _context2.margin;
			var width = _context2.width;

			EdgeIndicator.drawOnCanvasStatic(margin, this.props, width, ctx, chartData);
		}
	}, {
		key: "render",
		value: function render() {
			if (this.context.chartCanvasType !== "svg") return null;

			var _context3 = this.context;
			var width = _context3.width;
			var chartData = _context3.chartData;

			var edge = EdgeIndicator.helper(this.props, width, chartData);

			if (edge === undefined) return null;
			return _react2["default"].createElement(_EdgeCoordinate2["default"], {
				type: edge.type,
				className: "react-stockcharts-edge-coordinate",
				fill: edge.fill,
				show: edge.show,
				x1: edge.x1,
				y1: edge.y1,
				x2: edge.x2,
				y2: edge.y2,
				coordinate: edge.coordinate,
				edgeAt: edge.edgeAt,
				orient: edge.orient });
		}
	}]);

	return EdgeIndicator;
})(_utilsPureComponent2["default"]);

EdgeIndicator.contextTypes = {
	width: _react2["default"].PropTypes.number.isRequired,
	chartData: _react2["default"].PropTypes.array.isRequired,
	getCanvasContexts: _react2["default"].PropTypes.func,
	chartCanvasType: _react2["default"].PropTypes.string,
	margin: _react2["default"].PropTypes.object.isRequired,
	// secretToSuperFastCanvasDraw: React.PropTypes.array.isRequired,
	callbackForCanvasDraw: _react2["default"].PropTypes.func.isRequired
};

EdgeIndicator.propTypes = {
	type: _react2["default"].PropTypes.oneOf(["horizontal"]).isRequired,
	className: _react2["default"].PropTypes.string,
	fill: _react2["default"].PropTypes.string,
	defaultFill: _react2["default"].PropTypes.string,
	itemType: _react2["default"].PropTypes.oneOf(["first", "last", "current"]).isRequired,
	orient: _react2["default"].PropTypes.oneOf(["left", "right"]),
	edgeAt: _react2["default"].PropTypes.oneOf(["left", "right"]),
	forChart: _react2["default"].PropTypes.number.isRequired,
	forDataSeries: _react2["default"].PropTypes.number.isRequired,
	displayFormat: _react2["default"].PropTypes.func.isRequired

};

EdgeIndicator.defaultProps = {
	type: "horizontal",
	orient: "left",
	edgeAt: "left",
	displayFormat: _utilsUtils.displayNumberFormat,
	yAxisPad: 5,
	namespace: "ReStock.EdgeIndicator",
	defaultFill: "#0f0f0f"
};

EdgeIndicator.drawOnCanvasStatic = function (margin, props, width, ctx, chartDataArray) {
	var edge = EdgeIndicator.helper(props, width, chartDataArray);

	if (edge === undefined) return null;

	var originX = margin.left;
	var originY = margin.top;
	ctx.save();

	ctx.setTransform(1, 0, 0, 1, 0, 0);
	ctx.translate(originX, originY);

	_EdgeCoordinate2["default"].drawOnCanvasStatic(ctx, edge);
	ctx.restore();
};

EdgeIndicator.helper = function (props, width, chartData) {
	var edgeType = props.type;
	var displayFormat = props.displayFormat;
	var forChart = props.forChart;
	var forDataSeries = props.forDataSeries;
	var itemType = props.itemType;
	var edgeAt = props.edgeAt;
	var yAxisPad = props.yAxisPad;
	var orient = props.orient;
	var fill = props.fill;
	var defaultFill = props.defaultFill;

	var currentChartData = (0, _utilsChartDataUtil.getChartDataForChartNew)(chartData, forChart);
	// var currentItem = ChartDataUtil.getCurrentItemForChartNew(currentItems, forChart);
	var edge = null,
	    item,
	    yAccessor;
	// console.log(chartData.config.compareSeries.length);
	var displayFormat = currentChartData.config.compareSeries.length > 0 ? _d32["default"].format(".0%") : displayFormat;

	if (forDataSeries !== undefined && currentChartData.config.overlays.length > 0 && currentChartData.plot.overlayValues.length > 0) {

		var overlay = currentChartData.config.overlays.filter(function (eachOverlay) {
			return eachOverlay.id === forDataSeries;
		});
		var overlayValue = currentChartData.plot.overlayValues.filter(function (eachOverlayValue) {
			return eachOverlayValue.id === forDataSeries;
		});

		item = itemType === "first" ? overlayValue[0].first : overlayValue[0].last;

		yAccessor = overlay[0].yAccessor;

		if (item !== undefined) {
			var yValue = yAccessor(item),
			    xValue = currentChartData.config.xAccessor(item);
			var x1 = Math.round(currentChartData.plot.scales.xScale(xValue)),
			    y1 = Math.round(currentChartData.plot.scales.yScale(yValue));

			var stroke = overlay[0].stroke || fill;
			// console.log(forChart, forDataSeries, stroke, fill, defaultFill);
			if (!stroke) console.error("EdgeIndicator forChart=" + forChart + " forDataSeries=" + forDataSeries + " " + "is not a derived indicator, so a fill color is not auto assigned. Add a fill attribute to specify the color");

			stroke = stroke || defaultFill;

			var edgeX = edgeAt === "left" ? 0 - yAxisPad : width + yAxisPad;

			edge = {
				type: edgeType,
				fill: stroke,
				show: true,
				x1: x1 + currentChartData.config.origin[0],
				y1: y1 + currentChartData.config.origin[1],
				x2: edgeX + currentChartData.config.origin[0],
				y2: y1 + currentChartData.config.origin[1],
				coordinate: displayFormat(yValue),
				edgeAt: edgeX,
				orient: orient,
				chartOrigin: currentChartData.config.origin
			};
		}
	}
	return edge;
};

exports["default"] = EdgeIndicator;
module.exports = exports["default"];