"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _pure = require("../pure");

var _pure2 = _interopRequireDefault(_pure);

var _CrossHair = require("./CrossHair");

var _CrossHair2 = _interopRequireDefault(_CrossHair);

var _utilsUtils = require("../utils/utils");

var MouseCoordinates = (function (_React$Component) {
	_inherits(MouseCoordinates, _React$Component);

	function MouseCoordinates() {
		_classCallCheck(this, MouseCoordinates);

		_get(Object.getPrototypeOf(MouseCoordinates.prototype), "constructor", this).apply(this, arguments);
	}

	_createClass(MouseCoordinates, [{
		key: "componentDidMount",
		value: function componentDidMount() {
			var _props = this.props;
			var chartCanvasType = _props.chartCanvasType;
			var getCanvasContexts = _props.getCanvasContexts;

			if (chartCanvasType !== "svg" && getCanvasContexts !== undefined) {
				var contexts = getCanvasContexts();
				if (contexts) MouseCoordinates.drawOnCanvas(contexts.mouseCoord, this.props);
			}
		}
	}, {
		key: "componentDidUpdate",
		value: function componentDidUpdate() {
			this.componentDidMount();
		}
	}, {
		key: "componentWillMount",
		value: function componentWillMount() {
			this.componentWillReceiveProps(this.props, this.props);
		}
	}, {
		key: "componentWillReceiveProps",
		value: function componentWillReceiveProps(nextProps) {
			var draw = MouseCoordinates.drawOnCanvasStatic.bind(null, nextProps);

			var temp = nextProps.getAllCanvasDrawCallback().filter(function (each) {
				return each.type === "mouse";
			});
			if (temp.length === 0) {
				nextProps.callbackForCanvasDraw({
					type: "mouse",
					draw: draw
				});
			} else {
				nextProps.callbackForCanvasDraw(temp[0], {
					type: "mouse",
					draw: draw
				});
			}
		}
	}, {
		key: "render",
		value: function render() {
			var _props2 = this.props;
			var chartCanvasType = _props2.chartCanvasType;
			var mouseXY = _props2.mouseXY;
			var currentCharts = _props2.currentCharts;
			var chartData = _props2.chartData;
			var currentItems = _props2.currentItems;
			var show = _props2.show;
			var _props3 = this.props;
			var stroke = _props3.stroke;
			var opacity = _props3.opacity;
			var textStroke = _props3.textStroke;
			var textBGFill = _props3.textBGFill;
			var textBGopacity = _props3.textBGopacity;
			var fontFamily = _props3.fontFamily;
			var fontSize = _props3.fontSize;

			if (chartCanvasType !== "svg") return null;

			var pointer = MouseCoordinates.helper(this.props, show, mouseXY, currentCharts, chartData, currentItems);

			if (!pointer) return null;

			return _react2["default"].createElement(_CrossHair2["default"], { height: pointer.height, width: pointer.width, mouseXY: pointer.mouseXY,
				xDisplayValue: pointer.xDisplayValue, edges: pointer.edges,
				stroke: stroke, opacity: opacity, textStroke: textStroke,
				textBGFill: textBGFill, textBGopacity: textBGopacity,
				fontFamily: fontFamily, fontSize: fontSize });
		}
	}]);

	return MouseCoordinates;
})(_react2["default"].Component);

MouseCoordinates.propTypes = {
	xDisplayFormat: _react2["default"].PropTypes.func.isRequired,
	yDisplayFormat: _react2["default"].PropTypes.func.isRequired,
	type: _react2["default"].PropTypes.oneOf(["crosshair"]).isRequired,

	chartCanvasType: _react2["default"].PropTypes.string,
	getCanvasContexts: _react2["default"].PropTypes.func,
	mouseXY: _react2["default"].PropTypes.array,
	currentCharts: _react2["default"].PropTypes.array,
	chartData: _react2["default"].PropTypes.array,
	currentItems: _react2["default"].PropTypes.array,
	show: _react2["default"].PropTypes.bool,
	stroke: _react2["default"].PropTypes.string,
	opacity: _react2["default"].PropTypes.number,
	textStroke: _react2["default"].PropTypes.string,
	textBGFill: _react2["default"].PropTypes.string,
	textBGopacity: _react2["default"].PropTypes.number,
	fontFamily: _react2["default"].PropTypes.string,
	fontSize: _react2["default"].PropTypes.number
};

MouseCoordinates.defaultProps = {
	// show: false,
	snapX: true,
	type: "crosshair",
	xDisplayFormat: _utilsUtils.displayDateFormat,
	yDisplayFormat: _utilsUtils.displayNumberFormat,
	stroke: "#000000",
	opacity: 0.2,
	textStroke: "#ffffff",
	textBGFill: "#8a8a8a",
	textBGopacity: 1,
	fontFamily: "Helvetica Neue, Helvetica, Arial, sans-serif",
	fontSize: 13

};

// fill: "",
// opacity: 1,
// textFill: "white",
// var { fill, opacity, fontFamily, fontSize, textFill } = props;

MouseCoordinates.drawOnCanvas = function (canvasContext, props) {
	var mouseXY = props.mouseXY;
	var currentCharts = props.currentCharts;
	var chartData = props.chartData;
	var currentItems = props.currentItems;
	var show = props.show;

	MouseCoordinates.drawOnCanvasStatic(props, canvasContext, show, mouseXY, currentCharts, chartData, currentItems);
};
MouseCoordinates.drawOnCanvasStatic = function (props, ctx, show, mouseXY, currentCharts, chartData, currentItems) {
	var margin = props.margin;

	var pointer = MouseCoordinates.helper(props, show, mouseXY, currentCharts, chartData, currentItems);

	// console.log("HERE", show);
	if (!pointer) return null;

	var originX = 0.5 + margin.left;
	var originY = 0.5 + margin.top;

	ctx.save();

	ctx.setTransform(1, 0, 0, 1, 0, 0);
	ctx.translate(originX, originY);

	_CrossHair2["default"].drawOnCanvasStatic(ctx, pointer);
	ctx.restore();
};

MouseCoordinates.helper = function (props, show, mouseXY, currentCharts, chartData, currentItems) {
	if (!show) return;
	var mainChart = props.mainChart;
	var dateAccessor = props.dateAccessor;
	var height = props.height;
	var width = props.width;
	var snapX = props.snapX;
	var xDisplayFormat = props.xDisplayFormat;

	var edges = chartData.filter(function (eachChartData) {
		return currentCharts.indexOf(eachChartData.id) > -1;
	}).map(function (each) {
		var yDisplayFormat = each.config.compareSeries.length > 0 ? function (d) {
			return (Math.round(d * 10000) / 100).toFixed(2) + "%";
		} : each.config.mouseCoordinates.format;
		var mouseY = mouseXY[1] - each.config.origin[1];
		var yValue = each.plot.scales.yScale.invert(mouseY);
		return {
			id: each.id,
			at: each.config.mouseCoordinates.at,
			yValue: yValue,
			yDisplayFormat: yDisplayFormat
		};
	}).filter(function (each) {
		return each.at !== undefined;
	}).filter(function (each) {
		return each.yDisplayFormat !== undefined;
	}).map(function (each) {
		each.yDisplayValue = each.yDisplayFormat(each.yValue);
		return each;
	});

	var singleChartData = chartData.filter(function (eachChartData) {
		return eachChartData.id === mainChart;
	})[0];
	// console.log(props, show, mouseXY, currentCharts, chartData, currentItems);

	// var yDisplayFormat = singleChartData.config.compareSeries.length > 0 ? (d) => (Math.round(d * 10000) / 100).toFixed(2) + "%" : this.props.yDisplayFormat;

	var item = currentItems.filter(function (eachItem) {
		return eachItem.id === mainChart;
	})[0]; // ChartDataUtil.getCurrentItemForChart(this.props, this.context);
	if (item === undefined) return null;
	item = item.data;
	// console.log(singleChartData, item);
	var xValue = singleChartData.config.xAccessor(item);

	var xDisplayValue = dateAccessor === undefined ? xValue : dateAccessor(item);

	// var yValue = singleChartData.plot.scales.yScale.invert(mouseXY[1]);
	if (xValue === undefined) return null;
	var x = snapX ? Math.round(singleChartData.plot.scales.xScale(xValue)) : mouseXY[0];
	var y = mouseXY[1];
	var stroke = props.stroke;
	var opacity = props.opacity;
	var textStroke = props.textStroke;
	var textBGFill = props.textBGFill;
	var textBGopacity = props.textBGopacity;
	var fontFamily = props.fontFamily;
	var fontSize = props.fontSize;

	return { height: height, width: width, mouseXY: [x, y], xDisplayValue: xDisplayFormat(xDisplayValue), edges: edges,
		stroke: stroke, opacity: opacity, textStroke: textStroke, textBGFill: textBGFill, textBGopacity: textBGopacity, fontFamily: fontFamily, fontSize: fontSize };
};

// export default MouseCoordinates;
exports["default"] = (0, _pure2["default"])(MouseCoordinates, {
	width: _react2["default"].PropTypes.number.isRequired,
	height: _react2["default"].PropTypes.number.isRequired,
	mainChart: _react2["default"].PropTypes.number.isRequired,
	show: _react2["default"].PropTypes.bool,
	mouseXY: _react2["default"].PropTypes.array,
	dateAccessor: _react2["default"].PropTypes.func,
	chartData: _react2["default"].PropTypes.array.isRequired,
	currentItems: _react2["default"].PropTypes.array.isRequired,
	currentCharts: _react2["default"].PropTypes.array.isRequired,
	getCanvasContexts: _react2["default"].PropTypes.func,
	margin: _react2["default"].PropTypes.object.isRequired,
	// secretToSuperFastCanvasDraw: React.PropTypes.array.isRequired,
	callbackForCanvasDraw: _react2["default"].PropTypes.func.isRequired,
	getAllCanvasDrawCallback: _react2["default"].PropTypes.func,
	chartCanvasType: _react2["default"].PropTypes.string.isRequired
});
module.exports = exports["default"];