"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _objectAssign = require("object-assign");

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _utilsMovingAverageCalculator = require("../utils/MovingAverageCalculator");

var MACalculator = _interopRequireWildcard(_utilsMovingAverageCalculator);

var _defaultOptions = require("./defaultOptions");

function BollingerBandIndicator(options, chartProps, dataSeriesProps) {

	var prefix = "chart_" + chartProps.id;
	var key = "overlay_" + dataSeriesProps.id;

	var settings = (0, _objectAssign2["default"])({}, _defaultOptions.BollingerBand, options);

	function indicator() {}
	indicator.options = function () {
		return settings;
	};
	indicator.calculate = function (data) {
		var period = settings.period;

		var ma = settings.movingAverageType === "sma" ? MACalculator.calculateSMANew : MACalculator.calculateEMANew;
		var getter = function getter(d) {
			return d[settings.source];
		};
		var setter = MACalculator.setter.bind(null, [prefix, key], "middle");
		var newData = ma(data, period, getter, setter);

		// console.log(period, newData.slice(0, 20));

		newData.map(function (each, i) {
			return newData.slice(i - period + 1, i + 1);
		}).filter(function (array) {
			return array.length === period && array.length > 0;
		}).map(function (array) {
			return {
				array: array,
				mean: array[array.length - 1][prefix][key].middle
			};
		}).forEach(function (meanAndArray) {
			var averageOfDeviationSquared = meanAndArray.array.map(getter).map(function (val) {
				return val - meanAndArray.mean;
			}).map(function (val) {
				return val * val;
			}).reduce(function (a, b) {
				return a + b;
			}) / meanAndArray.array.length;
			var standardDev = Math.sqrt(averageOfDeviationSquared);
			var item = meanAndArray.array[meanAndArray.array.length - 1][prefix][key];
			item.top = item.middle + settings.multiplier * standardDev;
			item.bottom = item.middle - settings.multiplier * standardDev;
			// console.log(meanAndArray.array[meanAndArray.array.length - 1]);
		});
		// console.log(newData[newData.length - 1]);
		return newData;
	};
	indicator.yAccessor = function () {
		return function (d) {
			// console.log(d[prefix][key]);
			if (d && d[prefix]) return d[prefix][key];
		};
	};
	indicator.isBollingerBand = function () {
		return true;
	};
	return indicator;
}

exports["default"] = BollingerBandIndicator;
module.exports = exports["default"];