"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

var _utilsMovingAverageCalculator = require("../utils/MovingAverageCalculator");

var MACalculator = _interopRequireWildcard(_utilsMovingAverageCalculator);

var _objectAssign = require("object-assign");

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _utilsUtils = require("../utils/utils");

var _defaultOptions = require("./defaultOptions");

function EMAIndicator(options, chartProps, dataSeriesProps) {

	var prefix = "chart_" + chartProps.id;
	var key = "overlay_" + dataSeriesProps.id;

	if (options.pluck) options.source = options.pluck;

	var settings = (0, _objectAssign2["default"])({}, _defaultOptions.EMA, options);
	if (!settings.stroke) settings.stroke = (0, _utilsUtils.overlayColors)(dataSeriesProps.id);

	function indicator() {}
	indicator.options = function () {
		return settings;
	};
	indicator.stroke = function () {
		return settings.stroke;
	};
	indicator.calculate = function (data) {

		var setter = MACalculator.setter.bind(null, [prefix], key);
		var source = settings.source;

		var newData = MACalculator.calculateEMANew(data, settings.period, function (d) {
			return d[source];
		}, setter);
		// console.log(settings.period, newData[newData.length - 3]);

		return newData;
	};
	indicator.yAccessor = function () {
		return function (d) {
			if (d && d[prefix]) return d[prefix][key];
		};
	};
	indicator.tooltipLabel = function () {
		return "EMA (" + settings.period + ")";
	};
	indicator.isMovingAverage = function () {
		return true;
	};
	return indicator;
}

exports["default"] = EMAIndicator;
module.exports = exports["default"];