"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _objectAssign = require("object-assign");

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _utilsMovingAverageCalculator = require("../utils/MovingAverageCalculator");

var MACalculator = _interopRequireWildcard(_utilsMovingAverageCalculator);

var _defaultOptions = require("./defaultOptions");

function FullStochasticOscillator(options, chartProps, dataSeriesProps) {

	var prefix = "chart_" + chartProps.id;
	var key = "overlay_" + dataSeriesProps.id;

	var settings = (0, _objectAssign2["default"])({}, _defaultOptions.FullStochasticOscillator, options);

	function indicator() {}
	indicator.options = function () {
		return settings;
	};
	indicator.calculate = function (data) {
		var arr, highAndLow, ohlc;

		var setter = function setter(setKey, d, value) {
			if (d[prefix] === undefined) d[prefix] = {};
			if (d[prefix][key] === undefined) d[prefix][key] = {};
			d[prefix][key][setKey] = value;
			return d;
		};

		for (var i = settings.period - 1; i < data.length; i++) {
			arr = data.slice(i - settings.period + 1, i + 1);
			highAndLow = arr.map(settings.ohlc).map(function (ohlc) {
				return [ohlc.high, ohlc.low];
			}).reduce(function (a, b) {
				return [Math.max(a[0], b[0]), Math.min(a[1], b[1])];
			});
			ohlc = settings.ohlc(data[i]);

			var oscilator = (ohlc.close - highAndLow[1]) / (highAndLow[0] - highAndLow[1]) * 100;

			setter("stochasticOscillatorBase", data[i], oscilator);
		}

		var newData = MACalculator.calculateSMANew(data.slice(settings.period), settings.K, function (d) {
			return d[prefix][key].stochasticOscillatorBase;
		}, setter.bind(null, "K"));

		newData = MACalculator.calculateSMANew(newData.slice(settings.period), settings.D, function (d) {
			return d[prefix][key].K;
		}, setter.bind(null, "D"));

		// console.log(newData[newData.length - 1]);
		return newData;
	};
	indicator.yAccessor = function () {
		return function (d) {
			if (d && d[prefix] && d[prefix][key]) {
				return { K: d[prefix][key].K, D: d[prefix][key].D };
				// return d[prefix][key].K;
			}
		};
	};
	indicator.domain = function () {
		return [0, 100];
	};
	indicator.yTicks = function () {
		return [settings.overSold, 50, settings.overBought];
	};
	indicator.isStochastic = function () {
		return true;
	};
	return indicator;
}

exports["default"] = FullStochasticOscillator;
module.exports = exports["default"];