"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _objectAssign = require("object-assign");

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _utilsMovingAverageCalculator = require("../utils/MovingAverageCalculator");

var MACalculator = _interopRequireWildcard(_utilsMovingAverageCalculator);

var _defaultOptions = require("./defaultOptions");

function MACDIndicator(options, chartProps, dataSeriesProps) {

	var prefix = "chart_" + chartProps.id;
	var key = "overlay_" + dataSeriesProps.id;

	var settings = (0, _objectAssign2["default"])({}, _defaultOptions.MACD, options);

	function indicator() {}
	indicator.options = function () {
		return settings;
	};
	indicator.calculate = function (data) {
		// console.log(prefix, options);
		var fastKey = "ema" + settings.fast;
		var slowKey = "ema" + settings.slow;
		var source = settings.source;

		var setter = function setter(setKey, d, value) {
			if (d[prefix] === undefined) d[prefix] = {};
			if (d[prefix][key] === undefined) d[prefix][key] = {};
			d[prefix][key][setKey] = value;
			return d;
		};
		var getter = function getter(d) {
			return d[source];
		};

		var newData = MACalculator.calculateEMANew(data, settings.fast, getter, setter.bind(null, fastKey));
		newData = MACalculator.calculateEMANew(newData, settings.slow, getter, setter.bind(null, slowKey));

		newData.forEach(function (each) {
			if (each[prefix]) {
				if (each[prefix][key][slowKey] && each[prefix][key][fastKey]) {
					// each[prefix][key] = {};
					each[prefix][key].MACDLine = each[prefix][key][fastKey] - each[prefix][key][slowKey];
				}
			}
		});
		newData = MACalculator.calculateEMANew(newData.slice(settings.slow), settings.signal, function (d) {
			return d[prefix][key].MACDLine;
		}, setter.bind(null, "signalLine"));

		newData.forEach(function (each) {
			if (each[prefix] && each[prefix][key]) {
				if (each[prefix][key].MACDLine && each[prefix][key].signalLine) {
					each[prefix][key].histogram = each[prefix][key].MACDLine - each[prefix][key].signalLine;
				}
			}
		});

		// console.table(newData);
		// console.log(newData[newData.length - 3]);
		return newData;
	};
	indicator.yAccessor = function () {
		return function (d) {
			if (d && d[prefix] && d[prefix][key]) {
				return { MACDLine: d[prefix][key].MACDLine, signalLine: d[prefix][key].signalLine, histogram: d[prefix][key].histogram };
			}
		};
	};
	indicator.isMACD = function () {
		return true;
	};
	return indicator;
}

exports["default"] = MACDIndicator;
module.exports = exports["default"];