"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});
var BollingerBand = {
	period: 20,
	source: "close", // "high", "low", "open", "close"
	multiplier: 2,
	movingAverageType: "sma"
};

exports.BollingerBand = BollingerBand;
var MACD = {
	fast: 12,
	slow: 26,
	signal: 9,
	source: "close", // "high", "low", "open", "close"
	fill: {
		histogram: "#4682B4"
	},
	stroke: {
		MACDLine: "#FF0000",
		signalLine: "#00F300"
	}
};

exports.MACD = MACD;
var FullStochasticOscillator = {
	period: 12,
	K: 3,
	D: 3,
	ohlc: function ohlc(d) {
		return { open: d.open, high: d.high, low: d.low, close: d.close };
	},
	stroke: {
		D: "#00F300",
		K: "#FF0000"
	},
	overSold: 80,
	overBought: 20
};

exports.FullStochasticOscillator = FullStochasticOscillator;
var RSI = {
	period: 14,
	source: "close", // "high", "low", "open", "close"
	overSold: 70,
	overBought: 30
};

exports.RSI = RSI;
var EMA = {
	source: "close", // "high", "low", "open", "close"
	period: 10
};

exports.EMA = EMA;
var SMA = {
	source: "close", // "high", "low", "open", "close"
	period: 10
};
exports.SMA = SMA;