"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _objectAssign = require("object-assign");

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _makeInteractive = require("./makeInteractive");

var _makeInteractive2 = _interopRequireDefault(_makeInteractive);

var _utilsUtilsJs = require("../utils/utils.js");

var Brush = (function (_React$Component) {
	_inherits(Brush, _React$Component);

	function Brush(props) {
		_classCallCheck(this, Brush);

		_get(Object.getPrototypeOf(Brush.prototype), "constructor", this).call(this, props);
		this.onMousemove = this.onMousemove.bind(this);
		this.onClick = this.onClick.bind(this);
	}

	_createClass(Brush, [{
		key: "onMousemove",
		value: function onMousemove(chartId, xAccessor, interactive, _ref /* , e */) {
			var currentItem = _ref.currentItem;
			var enabled = this.props.enabled;
			var startX = interactive.startX;

			if (enabled && startX) {
				var xValue = xAccessor(currentItem);
				return (0, _objectAssign2["default"])({}, interactive, {
					tempEndX: xValue
				});
			}
			return interactive;
		}
	}, {
		key: "onClick",
		value: function onClick(chartId, xAccessor, interactive, _ref2, e) {
			var mouseXY = _ref2.mouseXY;
			var currentItem = _ref2.currentItem;
			var currentChartstriggerCallback = _ref2.currentChartstriggerCallback;
			var chartData = _ref2.chartData;
			var _props = this.props;
			var enabled = _props.enabled;
			var onBrush = _props.onBrush;

			if (enabled) {
				var startX = interactive.startX;

				var xValue = xAccessor(currentItem);

				if (startX) {
					var brushCoords = (0, _objectAssign2["default"])({}, interactive, {
						startX: null,
						tempEndX: null,
						startItem: null
					});
					setTimeout(function () {
						onBrush([interactive.startX, xValue], [interactive.startItem, currentItem]);
					}, 20);

					return brushCoords;
				} else if (e.button === 0) {
					return (0, _objectAssign2["default"])({}, interactive, {
						startX: xValue,
						startItem: currentItem,
						tempEndX: null
					});
				}
			}
			// brush: null,
			return interactive;
		}
	}, {
		key: "render",
		value: function render() {
			var _props2 = this.props;
			var chartCanvasType = _props2.chartCanvasType;
			var chartData = _props2.chartData;
			var plotData = _props2.plotData;
			var xAccessor = _props2.xAccessor;
			var interactive = _props2.interactive;
			var enabled = _props2.enabled;
			var _props3 = this.props;
			var fill = _props3.fill;
			var stroke = _props3.stroke;
			var opacity = _props3.opacity;

			if (chartCanvasType !== "svg") return null;

			var startX = interactive.startX;
			var tempEndX = interactive.tempEndX;

			if (enabled && startX && tempEndX) {
				var brush = [startX, tempEndX];
				var brush = Brush.helper(plotData, xAccessor, chartData, brush);
				return _react2["default"].createElement("rect", _extends({}, brush, { fill: fill, stroke: stroke, fillOpacity: opacity }));
			}
			return null;
		}
	}]);

	return Brush;
})(_react2["default"].Component);

Brush.drawOnCanvas = function (context, props, interactive, ctx, _ref3) {
	var plotData = _ref3.plotData;
	var chartData = _ref3.chartData;
	var startX = interactive.startX;
	var tempEndX = interactive.tempEndX;
	var enabled = props.enabled;
	var stroke = props.stroke;
	var opacity = props.opacity;
	var fill = props.fill;

	if (enabled && startX && tempEndX) {
		var brush = [startX, tempEndX];

		var xAccessor = context.xAccessor;

		var rect = Brush.helper(plotData, xAccessor, chartData, brush);

		// console.log("DRAWING", enabled, rect);

		ctx.strokeStyle = stroke;
		ctx.fillStyle = (0, _utilsUtilsJs.hexToRGBA)(fill, opacity);
		ctx.beginPath();
		ctx.rect(rect.x, rect.y, rect.width, rect.height);
		ctx.stroke();
		ctx.fill();
	}
};

Brush.helper = function (plotData, xAccessor, chartData, brush) {
	var xScale = chartData.plot.scales.xScale;

	var left = Math.min(brush[0], brush[1]);
	var right = Math.max(brush[0], brush[1]);

	var x = xScale(left);
	var width = xScale(right) - xScale(left);

	// console.log(chartData);
	return {
		x: x,
		y: 0,
		width: width,
		height: chartData.config.height
	};
};

Brush.propTypes = {
	enabled: _react2["default"].PropTypes.bool.isRequired,
	onBrush: _react2["default"].PropTypes.func.isRequired,

	chartCanvasType: _react2["default"].PropTypes.string,
	chartData: _react2["default"].PropTypes.object,
	plotData: _react2["default"].PropTypes.array,
	xAccessor: _react2["default"].PropTypes.func,
	interactive: _react2["default"].PropTypes.object,
	stroke: _react2["default"].PropTypes.string,
	fill: _react2["default"].PropTypes.string,
	opacity: _react2["default"].PropTypes.number
};

Brush.defaultProps = {
	stroke: "#000000",
	opacity: 0.3,
	fill: "#3h3h3h",
	onBrush: function onBrush(e) {
		console.log(e);
	}
};

exports["default"] = (0, _makeInteractive2["default"])(Brush, ["click", "mousemove"], {});
module.exports = exports["default"];