"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _objectAssign = require("object-assign");

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _makeInteractive = require("./makeInteractive");

var _makeInteractive2 = _interopRequireDefault(_makeInteractive);

var _utilsUtilsJs = require("../utils/utils.js");

var FibonacciRetracement = (function (_React$Component) {
	_inherits(FibonacciRetracement, _React$Component);

	function FibonacciRetracement(props) {
		_classCallCheck(this, FibonacciRetracement);

		_get(Object.getPrototypeOf(FibonacciRetracement.prototype), "constructor", this).call(this, props);
		this.onMousemove = this.onMousemove.bind(this);
		this.onClick = this.onClick.bind(this);
	}

	_createClass(FibonacciRetracement, [{
		key: "removeIndicator",
		value: function removeIndicator(chartId, xAccessor, interactive) {
			var start = interactive.start;
			var retracements = interactive.retracements;

			if (start) {
				return (0, _objectAssign2["default"])({}, interactive, { start: null, tempEnd: null });
			} else {
				return (0, _objectAssign2["default"])({}, interactive, { retracements: retracements.slice(0, retracements.length - 1) });
			}
		}
	}, {
		key: "onMousemove",
		value: function onMousemove(chartId, xAccessor, interactive, _ref /* , e */) {
			var mouseXY = _ref.mouseXY;
			var currentItem = _ref.currentItem;
			var /* currentCharts, */chartData = _ref.chartData;
			var enabled = this.props.enabled;

			if (enabled) {
				var yScale = chartData.plot.scales.yScale;

				var yValue = yScale.invert(mouseXY[1]);
				var xValue = xAccessor(currentItem);

				if (interactive.start) {
					return (0, _objectAssign2["default"])({}, interactive, {
						tempEnd: [xValue, yValue]
					});
				}
			}
			return interactive;
		}
	}, {
		key: "onClick",
		value: function onClick(chartId, xAccessor, interactive, _ref2, e) {
			var mouseXY = _ref2.mouseXY;
			var currentItem = _ref2.currentItem;
			var currentChartstriggerCallback = _ref2.currentChartstriggerCallback;
			var chartData = _ref2.chartData;
			var enabled = this.props.enabled;

			if (enabled) {
				var start = interactive.start;
				var retracements = interactive.retracements;
				var yScale = chartData.plot.scales.yScale;

				var yValue = yScale.invert(mouseXY[1]);
				var xValue = xAccessor(currentItem);

				if (start) {
					return (0, _objectAssign2["default"])({}, interactive, {
						start: null,
						tempEnd: null,
						retracements: retracements.concat({ start: start, end: [xValue, yValue] })
					});
				} else if (e.button === 0) {
					return (0, _objectAssign2["default"])({}, interactive, {
						start: [xValue, yValue],
						tempEnd: null
					});
				}
			}
			return interactive;
		}
	}, {
		key: "render",
		value: function render() {
			var _props = this.props;
			var chartCanvasType = _props.chartCanvasType;
			var chartData = _props.chartData;
			var plotData = _props.plotData;
			var xAccessor = _props.xAccessor;
			var interactive = _props.interactive;
			var width = _props.width;
			var _props2 = this.props;
			var stroke = _props2.stroke;
			var opacity = _props2.opacity;
			var fontFamily = _props2.fontFamily;
			var fontSize = _props2.fontSize;
			var fontStroke = _props2.fontStroke;

			if (chartCanvasType !== "svg") return null;

			var yScale = chartData.plot.scales.yScale;

			var retracements = FibonacciRetracement.helper(plotData, xAccessor, interactive, chartData);

			return _react2["default"].createElement(
				"g",
				null,
				retracements.map(function (eachRetracement, idx) {
					var dir = eachRetracement[0].y1 > eachRetracement[eachRetracement.length - 1].y1 ? 3 : -1.3;
					return _react2["default"].createElement(
						"g",
						{ key: idx },
						eachRetracement.map(function (line, i) {
							var text = line.y.toFixed(2) + " (" + line.percent.toFixed(2) + "%)";

							return _react2["default"].createElement(
								"g",
								{ key: i },
								_react2["default"].createElement("line", {
									x1: 0, y1: yScale(line.y), x2: width, y2: yScale(line.y),
									stroke: stroke, opacity: opacity }),
								_react2["default"].createElement(
									"text",
									{ x: 10, y: yScale(line.y) + dir * 4,
										fontFamily: fontFamily, fontSize: fontSize, fill: fontStroke },
									text
								)
							);
						})
					);
				})
			);
		}
	}]);

	return FibonacciRetracement;
})(_react2["default"].Component);

FibonacciRetracement.drawOnCanvas = function (context, props, interactive, ctx, _ref3) {
	var plotData = _ref3.plotData;
	var chartData = _ref3.chartData;
	var xAccessor = context.xAccessor;
	var width = context.width;
	var yScale = chartData.plot.scales.yScale;
	var fontSize = props.fontSize;
	var fontFamily = props.fontFamily;
	var fontStroke = props.fontStroke;

	var lines = FibonacciRetracement.helper(plotData, xAccessor, interactive, chartData);

	ctx.strokeStyle = (0, _utilsUtilsJs.hexToRGBA)(props.stroke, props.opacity);
	ctx.font = fontSize + "px " + fontFamily;
	ctx.fillStyle = fontStroke;

	lines.forEach(function (retracements) {
		var dir = retracements[0].y1 > retracements[retracements.length - 1].y1 ? 3 : -1.3;

		retracements.forEach(function (each) {
			ctx.beginPath();
			ctx.moveTo(0, yScale(each.y));
			ctx.lineTo(width, yScale(each.y));

			var text = each.y.toFixed(2) + " (" + each.percent.toFixed(2) + "%)";
			ctx.fillText(text, 10, yScale(each.y) + dir * 4);

			ctx.stroke();
		});
	});
};

FibonacciRetracement.helper = function (plotData, xAccessor, interactive /* , chartData */) {
	var retracements = interactive.retracements;
	var start = interactive.start;
	var tempEnd = interactive.tempEnd;

	var temp = retracements;

	if (start && tempEnd) {
		temp = temp.concat({ start: start, end: tempEnd });
	}
	var lines = temp.map(function (each) {
		return generateLine(each.start, each.end, xAccessor, plotData);
	});

	return lines;
};

function generateLine(start, end /* , xAccessor, plotData */) {
	var dy = end[1] - start[1];
	return [100, 61.8, 50, 38.2, 23.6, 0].map(function (each) {
		return { percent: each, y: end[1] - each / 100 * dy };
	});
}

FibonacciRetracement.propTypes = {
	snap: _react2["default"].PropTypes.bool.isRequired,
	enabled: _react2["default"].PropTypes.bool.isRequired,
	snapTo: _react2["default"].PropTypes.func,
	fontFamily: _react2["default"].PropTypes.string.isRequired,
	fontSize: _react2["default"].PropTypes.number.isRequired,
	chartCanvasType: _react2["default"].PropTypes.string,
	chartData: _react2["default"].PropTypes.object,
	plotData: _react2["default"].PropTypes.array,
	xAccessor: _react2["default"].PropTypes.func,
	interactive: _react2["default"].PropTypes.object,
	width: _react2["default"].PropTypes.number,
	stroke: _react2["default"].PropTypes.string,
	opacity: _react2["default"].PropTypes.number,
	fontStroke: _react2["default"].PropTypes.string
};

FibonacciRetracement.defaultProps = {
	snap: true,
	enabled: true,
	stroke: "#000000",
	opacity: 0.4,
	fontFamily: "Helvetica Neue, Helvetica, Arial, sans-serif",
	fontSize: 10,
	fontStroke: "#000000"
};

exports["default"] = (0, _makeInteractive2["default"])(FibonacciRetracement, ["click", "mousemove"], { retracements: [] });
module.exports = exports["default"];