"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _objectAssign = require("object-assign");

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _makeInteractive = require("./makeInteractive");

var _makeInteractive2 = _interopRequireDefault(_makeInteractive);

var _utilsUtilsJs = require("../utils/utils.js");

function getYValue(values, currentValue) {
	var diff = values.map(function (each) {
		return each - currentValue;
	}).reduce(function (diff1, diff2) {
		return Math.abs(diff1) < Math.abs(diff2) ? diff1 : diff2;
	});
	return currentValue + diff;
}

var TrendLine = (function (_React$Component) {
	_inherits(TrendLine, _React$Component);

	function TrendLine(props) {
		_classCallCheck(this, TrendLine);

		_get(Object.getPrototypeOf(TrendLine.prototype), "constructor", this).call(this, props);
		this.onMousemove = this.onMousemove.bind(this);
		this.onClick = this.onClick.bind(this);
	}

	_createClass(TrendLine, [{
		key: "removeIndicator",
		value: function removeIndicator(chartId, xAccessor, interactive) {
			var trends = interactive.trends;
			var start = interactive.start;

			if (start) {
				return (0, _objectAssign2["default"])({}, interactive, { start: null });
			} else {
				return (0, _objectAssign2["default"])({}, interactive, { trends: trends.slice(0, trends.length - 1) });
			}
		}
	}, {
		key: "onMousemove",
		value: function onMousemove(chartId, xAccessor, interactive, _ref, e) {
			var mouseXY = _ref.mouseXY;
			var currentItem = _ref.currentItem;
			var currentCharts = _ref.currentCharts;
			var chartData = _ref.chartData;
			var _props = this.props;
			var enabled = _props.enabled;
			var snapTo = _props.snapTo;
			var snap = _props.snap;
			var shouldDisableSnap = _props.shouldDisableSnap;

			if (enabled) {
				var yScale = chartData.plot.scales.yScale;

				var yValue = snap && !shouldDisableSnap(e) ? getYValue(snapTo(currentItem), yScale.invert(mouseXY[1])) : yScale.invert(mouseXY[1]);
				var xValue = xAccessor(currentItem);

				if (interactive.start) {
					return (0, _objectAssign2["default"])({}, interactive, {
						tempEnd: [xValue, yValue],
						currentPos: [xValue, yValue]
					});
				} else {
					return (0, _objectAssign2["default"])({}, interactive, {
						currentPos: [xValue, yValue]
					});
				}
			}
			return interactive;
		}
	}, {
		key: "onClick",
		value: function onClick(chartId, xAccessor, interactive, _ref2, e) {
			var mouseXY = _ref2.mouseXY;
			var currentItem = _ref2.currentItem;
			var currentChartstriggerCallback = _ref2.currentChartstriggerCallback;
			var chartData = _ref2.chartData;
			var _props2 = this.props;
			var enabled = _props2.enabled;
			var snapTo = _props2.snapTo;
			var snap = _props2.snap;
			var shouldDisableSnap = _props2.shouldDisableSnap;

			if (enabled) {
				var start = interactive.start;
				var trends = interactive.trends;
				var yScale = chartData.plot.scales.yScale;

				var yValue = snap && !shouldDisableSnap(e) ? getYValue(snapTo(currentItem), yScale.invert(mouseXY[1])) : yScale.invert(mouseXY[1]);
				var xValue = xAccessor(currentItem);
				if (start) {
					return (0, _objectAssign2["default"])({}, interactive, {
						start: null,
						trends: trends.concat({ start: start, end: [xValue, yValue] })
					});
				} else if (e.button === 0) {
					return (0, _objectAssign2["default"])({}, interactive, {
						start: [xValue, yValue]
					});
				}
			}
			return interactive;
		}
	}, {
		key: "render",
		value: function render() {
			var _props3 = this.props;
			var chartCanvasType = _props3.chartCanvasType;
			var chartData = _props3.chartData;
			var plotData = _props3.plotData;
			var xAccessor = _props3.xAccessor;
			var interactive = _props3.interactive;
			var enabled = _props3.enabled;

			if (chartCanvasType !== "svg") return null;

			var _chartData$plot$scales = chartData.plot.scales;
			var xScale = _chartData$plot$scales.xScale;
			var yScale = _chartData$plot$scales.yScale;
			var currentPos = interactive.currentPos;
			var _props4 = this.props;
			var currentPositionStroke = _props4.currentPositionStroke;
			var currentPositionStrokeWidth = _props4.currentPositionStrokeWidth;
			var currentPositionOpacity = _props4.currentPositionOpacity;
			var currentPositionRadius = _props4.currentPositionRadius;
			var _props5 = this.props;
			var stroke = _props5.stroke;
			var opacity = _props5.opacity;

			var circle = currentPos && enabled ? _react2["default"].createElement("circle", { cx: xScale(currentPos[0]), cy: yScale(currentPos[1]),
				stroke: currentPositionStroke,
				opacity: currentPositionOpacity,
				fill: "none",
				strokeWidth: currentPositionStrokeWidth,
				r: currentPositionRadius }) : null;

			var lines = TrendLine.helper(plotData, xAccessor, interactive, chartData);
			return _react2["default"].createElement(
				"g",
				null,
				circle,
				lines.map(function (coords, idx) {
					return _react2["default"].createElement("line", { key: idx, stroke: stroke, opacity: opacity, x1: xScale(coords.x1), y1: yScale(coords.y1),
						x2: xScale(coords.x2), y2: yScale(coords.y2) });
				})
			);
		}
	}]);

	return TrendLine;
})(_react2["default"].Component);

TrendLine.drawOnCanvas = function (context, props, interactive, ctx, _ref3) {
	var plotData = _ref3.plotData;
	var chartData = _ref3.chartData;
	var currentPos = interactive.currentPos;
	var xAccessor = context.xAccessor;

	var lines = TrendLine.helper(plotData, xAccessor, interactive, chartData);

	var _chartData$plot$scales2 = chartData.plot.scales;
	var xScale = _chartData$plot$scales2.xScale;
	var yScale = _chartData$plot$scales2.yScale;
	var enabled = props.enabled;
	var currentPositionStroke = props.currentPositionStroke;
	var currentPositionStrokeWidth = props.currentPositionStrokeWidth;
	var currentPositionOpacity = props.currentPositionOpacity;
	var currentPositionRadius = props.currentPositionRadius;

	if (currentPos && enabled) {
		ctx.strokeStyle = (0, _utilsUtilsJs.hexToRGBA)(currentPositionStroke, currentPositionOpacity);
		ctx.lineWidth = currentPositionStrokeWidth;
		ctx.beginPath();
		ctx.arc(xScale(currentPos[0]), yScale(currentPos[1]), currentPositionRadius, 0, 2 * Math.PI, false);
		ctx.stroke();
	}
	ctx.lineWidth = 1;
	ctx.strokeStyle = (0, _utilsUtilsJs.hexToRGBA)(props.stroke, props.opacity);

	lines.forEach(function (each) {
		ctx.beginPath();
		ctx.moveTo(xScale(each.x1), yScale(each.y1));
		ctx.lineTo(xScale(each.x2), yScale(each.y2));
		// console.log(each);
		ctx.stroke();
	});
};

TrendLine.helper = function (plotData, xAccessor, interactive /* , chartData */) {
	var currentPos = interactive.currentPos;
	var start = interactive.start;
	var trends = interactive.trends;

	var temp = trends;
	if (start && currentPos) {
		temp = temp.concat({ start: start, end: currentPos });
	}
	var lines = temp.filter(function (each) {
		return each.start[0] !== each.end[0];
	}).map(function (each) {
		return generateLine(each.start, each.end, xAccessor, plotData);
	});

	return lines;
};

function generateLine(start, end, xAccessor, plotData) {
	/* if (end[0] - start[0] === 0) {
 	// vertical line
 	throw new Error("Trendline cannot be a vertical line")
 } */
	var m /* slope */ = (end[1] - start[1]) / (end[0] - start[0]);
	var b /* y intercept */ = -1 * m * end[0] + end[1];
	// y = m * x + b
	var x1 = xAccessor(plotData[0]);
	var y1 = m * x1 + b;

	var x2 = xAccessor(plotData[plotData.length - 1]);
	var y2 = m * x2 + b;
	return { x1: x1, y1: y1, x2: x2, y2: y2 };
}

TrendLine.propTypes = {
	snap: _react2["default"].PropTypes.bool.isRequired,
	enabled: _react2["default"].PropTypes.bool.isRequired,
	snapTo: _react2["default"].PropTypes.func,
	shouldDisableSnap: _react2["default"].PropTypes.func.isRequired,
	chartCanvasType: _react2["default"].PropTypes.string,
	chartData: _react2["default"].PropTypes.object,
	plotData: _react2["default"].PropTypes.array,
	xAccessor: _react2["default"].PropTypes.func,
	interactive: _react2["default"].PropTypes.object,
	currentPositionStroke: _react2["default"].PropTypes.string,
	currentPositionStrokeWidth: _react2["default"].PropTypes.number,
	currentPositionOpacity: _react2["default"].PropTypes.number,
	currentPositionRadius: _react2["default"].PropTypes.number,
	stroke: _react2["default"].PropTypes.string,
	opacity: _react2["default"].PropTypes.number
};

TrendLine.defaultProps = {
	stroke: "#000000",
	opacity: 0.7,
	shouldDisableSnap: function shouldDisableSnap(e) {
		return e.button === 2 || e.shiftKey;
	},
	currentPositionStroke: "#000000",
	currentPositionOpacity: 1,
	currentPositionStrokeWidth: 3,
	currentPositionRadius: 4
};

exports["default"] = (0, _makeInteractive2["default"])(TrendLine, ["click", "mousemove"], { trends: [] });
module.exports = exports["default"];