"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x2, _x3, _x4) { var _again = true; _function: while (_again) { var object = _x2, property = _x3, receiver = _x4; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x2 = parent; _x3 = property; _x4 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

exports["default"] = makeInteractive;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _objectAssign = require("object-assign");

var _objectAssign2 = _interopRequireDefault(_objectAssign);

function getDisplayName(Series) {
	var name = Series.displayName || Series.name || "Series";
	return name;
}

function capitalizeFirst(str) {
	return str.charAt(0).toUpperCase() + str.substring(1);
}

function makeInteractive(InteractiveComponent, subscription, initialState) {
	if (subscription === undefined) subscription = [];
	var reDrawOnPan = arguments.length <= 3 || arguments[3] === undefined ? true : arguments[3];

	var InteractiveComponentWrapper = (function (_React$Component) {
		_inherits(InteractiveComponentWrapper, _React$Component);

		function InteractiveComponentWrapper(props, context) {
			var _this = this;

			_classCallCheck(this, InteractiveComponentWrapper);

			_get(Object.getPrototypeOf(InteractiveComponentWrapper.prototype), "constructor", this).call(this, props, context);
			this.subscription = this.subscription.bind(this);
			var subscribe = context.subscribe;
			var chartId = context.chartId;

			this.subscriptionIds = subscription.map(function (each) {
				return subscribe(chartId, each, _this.subscription.bind(_this, each));
			});
		}

		_createClass(InteractiveComponentWrapper, [{
			key: "getInteractiveState",
			value: function getInteractiveState(props, context) {
				var interactiveState = context.interactiveState;

				var state = interactiveState.filter(function (each) {
					return each.id === props.id;
				});
				var response = { interactive: initialState };
				if (state.length > 0) {
					response = state[0];
				}
				// console.log(interactiveState, response.interactive, this.props.id);
				return response;
			}
		}, {
			key: "subscription",
			value: function subscription(event, arg, e) {
				// console.log("HIJOHJ");
				var _context = this.context;
				var chartId = _context.chartId;
				var xAccessor = _context.xAccessor;
				var _props = this.props;
				var shouldRemoveLastIndicator = _props.shouldRemoveLastIndicator;
				var enabled = _props.enabled;

				var _getInteractiveState = this.getInteractiveState(this.props, this.context);

				var interactive = _getInteractiveState.interactive;

				var interactiveState = interactive;
				if (event === "click" && shouldRemoveLastIndicator(e)) {
					if (enabled && this.refs.interactive.removeIndicator) {
						interactiveState = this.refs.interactive.removeIndicator(chartId, xAccessor, interactive, arg, e);
					}
					return {
						id: this.props.id,
						interactive: interactiveState
					};
				} else {
					var handler = this.refs.interactive["on" + capitalizeFirst(event)];
					if (enabled) {
						interactiveState = handler(chartId, xAccessor, interactive, arg, e);
					}

					if (interactiveState === interactive) return false;
					return {
						id: this.props.id,
						interactive: interactiveState
					};
				}
			}
		}, {
			key: "componentDidMount",
			value: function componentDidMount() {
				this.componentDidUpdate();
			}
		}, {
			key: "componentDidUpdate",
			value: function componentDidUpdate() {
				// console.log("Update");
				var callback = InteractiveComponent.drawOnCanvas;

				if (callback) {
					var _context2 = this.context;
					var getCanvasContexts = _context2.getCanvasContexts;
					var chartCanvasType = _context2.chartCanvasType;
					var plotData = _context2.plotData;
					var chartData = _context2.chartData;

					if (chartCanvasType !== "svg") {

						var contexts = getCanvasContexts();
						var defaultProps = InteractiveComponent.defaultProps;

						var props = (0, _objectAssign2["default"])({}, defaultProps, this.props);

						var _getInteractiveState2 = this.getInteractiveState(this.props, this.context);

						var interactive = _getInteractiveState2.interactive;

						// console.log(interactive);
						if (contexts) {
							InteractiveComponentWrapper.drawOnCanvas(callback, this.context, props, interactive, contexts.interactive, { plotData: plotData, chartData: chartData });
						}
					}
				}
			}
		}, {
			key: "componentWillMount",
			value: function componentWillMount() {
				this.componentWillReceiveProps(this.props, this.context);
			}
		}, {
			key: "componentWillReceiveProps",
			value: function componentWillReceiveProps(nextProps, nextContext) {
				// var nextContext = this.context;
				// var nextProps = this.props;

				var chartId = nextContext.chartId;
				var getAllCanvasDrawCallback = nextContext.getAllCanvasDrawCallback;
				var callbackForCanvasDraw = nextContext.callbackForCanvasDraw;

				var callback = InteractiveComponent.drawOnCanvas;

				if (reDrawOnPan && callback) {
					var defaultProps = InteractiveComponent.defaultProps;

					var props = (0, _objectAssign2["default"])({}, defaultProps, nextProps);

					var draw = InteractiveComponentWrapper.drawOnCanvas.bind(null, callback, nextContext, props, this.getInteractiveState(nextProps, nextContext).interactive);

					var temp = getAllCanvasDrawCallback().filter(function (each) {
						return each.type === "interactive";
					}).filter(function (each) {
						return each.id === nextProps.id;
					}).filter(function (each) {
						return each.chartId === chartId;
					});
					if (temp.length === 0) {
						callbackForCanvasDraw({
							type: "interactive",
							chartId: chartId,
							id: nextProps.id,
							draw: draw
						});
					} else {
						callbackForCanvasDraw(temp[0], {
							type: "interactive",
							chartId: chartId,
							id: nextProps.id,
							draw: draw
						});
					}
				}
			}
		}, {
			key: "componentWillUnmount",
			value: function componentWillUnmount() {
				var unsubscribe = this.context.unsubscribe;

				this.subscriptionIds.forEach(function (each) {
					unsubscribe(each);
				});
			}
		}, {
			key: "render",
			value: function render() {
				var _getInteractiveState3 = this.getInteractiveState(this.props, this.context);

				var interactive = _getInteractiveState3.interactive;

				return _react2["default"].createElement(InteractiveComponent, _extends({ ref: "interactive" }, this.context, this.props, { interactive: interactive }));
			}
		}]);

		return InteractiveComponentWrapper;
	})(_react2["default"].Component);

	InteractiveComponentWrapper.displayName = getDisplayName(InteractiveComponent);

	InteractiveComponentWrapper.drawOnCanvas = function (callback, context, props, interactiveState, ctx, chartContext) {
		// console.log(context, props, interactiveState);
		var canvasOriginX = context.canvasOriginX;
		var canvasOriginY = context.canvasOriginY;
		var width = context.width;
		var height = context.height;

		ctx.save();

		ctx.setTransform(1, 0, 0, 1, 0, 0);
		ctx.translate(canvasOriginX, canvasOriginY);

		ctx.beginPath();
		ctx.rect(-1, -1, width + 1, height + 1);
		ctx.clip();

		if (callback) {
			callback(context, props, interactiveState, ctx, chartContext);
		}

		ctx.restore();
	};

	InteractiveComponentWrapper.propTypes = {
		id: _react2["default"].PropTypes.number.isRequired,
		shouldRemoveLastIndicator: _react2["default"].PropTypes.func.isRequired,
		enabled: _react2["default"].PropTypes.bool.isRequired
	};

	InteractiveComponentWrapper.defaultProps = {
		shouldRemoveLastIndicator: function shouldRemoveLastIndicator(e) {
			return e.button === 2 && e.ctrlKey;
		}
	};
	InteractiveComponentWrapper.contextTypes = {
		chartId: _react2["default"].PropTypes.number.isRequired,
		interactiveState: _react2["default"].PropTypes.array.isRequired,
		getCanvasContexts: _react2["default"].PropTypes.func,
		callbackForCanvasDraw: _react2["default"].PropTypes.func.isRequired,
		getAllCanvasDrawCallback: _react2["default"].PropTypes.func,
		chartCanvasType: _react2["default"].PropTypes.string.isRequired,
		subscribe: _react2["default"].PropTypes.func.isRequired,
		unsubscribe: _react2["default"].PropTypes.func.isRequired,
		plotData: _react2["default"].PropTypes.array.isRequired,
		xAccessor: _react2["default"].PropTypes.func.isRequired,
		chartData: _react2["default"].PropTypes.object.isRequired,
		canvasOriginX: _react2["default"].PropTypes.number,
		canvasOriginY: _react2["default"].PropTypes.number,
		height: _react2["default"].PropTypes.number.isRequired,
		width: _react2["default"].PropTypes.number.isRequired
	};

	return InteractiveComponentWrapper;
}

exports["default"] = makeInteractive;
module.exports = exports["default"];