"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _d3 = require("d3");

var _d32 = _interopRequireDefault(_d3);

var _wrap = require("./wrap");

var _wrap2 = _interopRequireDefault(_wrap);

var _utilsUtils = require("../utils/utils");

var Area = (function (_React$Component) {
	_inherits(Area, _React$Component);

	function Area() {
		_classCallCheck(this, Area);

		_get(Object.getPrototypeOf(Area.prototype), "constructor", this).apply(this, arguments);
	}

	_createClass(Area, [{
		key: "render",
		value: function render() {
			var props = this.props;
			var stroke = props.stroke;
			var fill = props.fill;
			var className = props.className;
			var opacity = props.opacity;

			className = className.concat(stroke !== undefined ? "" : " line-stroke");
			return _react2["default"].createElement("path", { d: Area.getArea(props), stroke: stroke, fill: fill, className: className, opacity: opacity });
		}
	}]);

	return Area;
})(_react2["default"].Component);

;

Area.propTypes = {
	className: _react2["default"].PropTypes.string,
	xScale: _react2["default"].PropTypes.func.isRequired,
	yScale: _react2["default"].PropTypes.func.isRequired,
	xAccessor: _react2["default"].PropTypes.func.isRequired,
	yAccessor: _react2["default"].PropTypes.func.isRequired,
	plotData: _react2["default"].PropTypes.array.isRequired,
	stroke: _react2["default"].PropTypes.string,
	fill: _react2["default"].PropTypes.string,
	opacity: _react2["default"].PropTypes.number,
	base: _react2["default"].PropTypes.func
};

Area.defaultProps = {
	className: "line ",
	fill: "none",
	opacity: 1
};
Area.getArea = function (props) {
	var plotData = props.plotData;
	var xScale = props.xScale;
	var yScale = props.yScale;
	var xAccessor = props.xAccessor;
	var yAccessor = props.yAccessor;
	var base = props.base;

	var height = yScale.range()[0];
	if (base === undefined) base = function () {
		return height - 1;
	};

	var areaSeries = _d32["default"].svg.area().defined(function (d) {
		return yAccessor(d) !== undefined;
	}).x(function (d) {
		return xScale(xAccessor(d));
	}).y0(base.bind(null, yScale)).y1(function (d) {
		return yScale(yAccessor(d));
	});

	// console.log("HERE", yAccessor(plotData[0]));
	return areaSeries(plotData);
};

Area.drawOnCanvas = function (props, ctx, xScale, yScale, plotData) {
	var xAccessor = props.xAccessor;
	var yAccessor = props.yAccessor;
	var fill = props.fill;
	var stroke = props.stroke;
	var opacity = props.opacity;
	var base = props.base;

	var begin = true;
	var height = yScale.range()[0];
	var newBase = base === undefined ? function () {
		return height - 1;
	} : base;

	ctx.fillStyle = (0, _utilsUtils.hexToRGBA)(fill, opacity);
	ctx.strokeStyle = stroke;
	// ctx.globalAlpha = opacity;

	plotData.forEach(function (d) {
		if (yAccessor(d) !== undefined) {
			if (begin) {
				ctx.beginPath();
				begin = false;
				var x = ~ ~(0.5 + xScale(xAccessor(d)));
				var y = ~ ~(0.5 + yScale(yAccessor(d)));

				ctx.moveTo(x, newBase(yScale, d));
				ctx.lineTo(x, y);
			}
			ctx.lineTo(xScale(xAccessor(d)), yScale(yAccessor(d)));
		}
	});

	var last = plotData[plotData.length - 1];
	ctx.lineTo(xScale(xAccessor(last)), newBase(yScale, last));

	if (base !== undefined) {
		plotData.slice().reverse().forEach(function (d) {
			if (yAccessor(d) !== undefined) {
				ctx.lineTo(xScale(xAccessor(d)), base(yScale, d));
			}
		});
	}
	ctx.closePath();
	ctx.fill();
};

exports["default"] = (0, _wrap2["default"])(Area);
module.exports = exports["default"];