"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _wrap = require("./wrap");

var _wrap2 = _interopRequireDefault(_wrap);

var _utilsUtils = require("../utils/utils");

var CandlestickSeries = (function (_React$Component) {
	_inherits(CandlestickSeries, _React$Component);

	function CandlestickSeries() {
		_classCallCheck(this, CandlestickSeries);

		_get(Object.getPrototypeOf(CandlestickSeries.prototype), "constructor", this).apply(this, arguments);
	}

	_createClass(CandlestickSeries, [{
		key: "render",
		value: function render() {
			var _props = this.props;
			var className = _props.className;
			var wickClassName = _props.wickClassName;
			var candleClassName = _props.candleClassName;

			return _react2["default"].createElement(
				"g",
				{ className: className },
				_react2["default"].createElement(
					"g",
					{ className: wickClassName, key: "wicks" },
					CandlestickSeries.getWicksSVG(this.props)
				),
				_react2["default"].createElement(
					"g",
					{ className: candleClassName, key: "candles" },
					CandlestickSeries.getCandlesSVG(this.props)
				)
			);
		}
	}]);

	return CandlestickSeries;
})(_react2["default"].Component);

CandlestickSeries.propTypes = {
	className: _react2["default"].PropTypes.string,
	wickClassName: _react2["default"].PropTypes.string,
	candleClassName: _react2["default"].PropTypes.string,
	classNames: _react2["default"].PropTypes.shape({
		up: _react2["default"].PropTypes.string,
		down: _react2["default"].PropTypes.string
	}),
	widthRatio: _react2["default"].PropTypes.number.isRequired,
	stroke: _react2["default"].PropTypes.shape({
		up: _react2["default"].PropTypes.string,
		down: _react2["default"].PropTypes.string
	}),
	fill: _react2["default"].PropTypes.shape({
		up: _react2["default"].PropTypes.string,
		down: _react2["default"].PropTypes.string
	}),
	xAccessor: _react2["default"].PropTypes.func,
	yAccessor: _react2["default"].PropTypes.func,
	xScale: _react2["default"].PropTypes.func,
	yScale: _react2["default"].PropTypes.func,
	compareSeries: _react2["default"].PropTypes.array,
	plotData: _react2["default"].PropTypes.array
};

CandlestickSeries.defaultProps = {
	className: "react-stockcharts-candlestick",
	wickClassName: "react-stockcharts-candlestick-wick",
	candleClassName: "react-stockcharts-candlestick-candle",
	classNames: {
		up: "up",
		down: "down"
	},
	widthRatio: 0.5,
	stroke: {
		up: "none",
		down: "none"
	},
	wickStroke: {
		up: "#000000", // "#6BA583"
		down: "#000000" // "red"
	},
	fill: {
		up: "#6BA583",
		down: "#FF0000"
	},
	opacity: 1
};

CandlestickSeries.getWicksSVG = function (props) {

	/* eslint-disable react/prop-types */
	var xAccessor = props.xAccessor;
	var yAccessor = props.yAccessor;
	var xScale = props.xScale;
	var yScale = props.yScale;
	var compareSeries = props.compareSeries;
	var plotData = props.plotData;

	/* eslint-disable react/prop-types */

	var wickData = CandlestickSeries.getWickData(props, xAccessor, yAccessor, xScale, yScale, compareSeries, plotData);
	var wicks = wickData.map(function (d, idx) {
		return _react2["default"].createElement("line", { key: idx,
			className: d.className, stroke: d.stroke, style: { shapeRendering: "crispEdges" },
			x1: d.x1, y1: d.y1,
			x2: d.x2, y2: d.y2 });
	});
	return wicks;
};
CandlestickSeries.getCandlesSVG = function (props) {
	var xAccessor = props.xAccessor;
	var yAccessor = props.yAccessor;
	var xScale = props.xScale;
	var yScale = props.yScale;
	var compareSeries = props.compareSeries;
	var plotData = props.plotData;

	var candleData = CandlestickSeries.getCandleData(props, xAccessor, yAccessor, xScale, yScale, compareSeries, plotData);
	var candles = candleData.map(function (d, idx) {
		if (d.width < 0) return _react2["default"].createElement("line", { className: d.className, key: idx, x1: d.x, y1: d.y, x2: d.x, y2: d.y + d.height, stroke: d.fill });else if (d.height === 0) return _react2["default"].createElement("line", { key: idx, x1: d.x, y1: d.y, x2: d.x + d.width, y2: d.y + d.height, stroke: d.fill });
		return _react2["default"].createElement("rect", { className: d.className, key: idx, x: d.x, y: d.y, width: d.width, height: d.height, fill: d.fill, stroke: d.stroke });
	});
	return candles;
};

CandlestickSeries.yAccessor = function (d) {
	return { open: d.open, high: d.high, low: d.low, close: d.close };
};

CandlestickSeries.drawOnCanvas = function (props, ctx, xScale, yScale, plotData) {
	var compareSeries = props.compareSeries;
	var xAccessor = props.xAccessor;
	var yAccessor = props.yAccessor;
	var wickStroke = props.wickStroke;
	var fill = props.fill;
	var opacity = props.opacity;

	var wickData = CandlestickSeries.getWickData(props, xAccessor, yAccessor, xScale, yScale, compareSeries, plotData);
	var each,
	    group = { up: [], down: [] };

	for (var i = 0; i < wickData.length; i++) {
		each = wickData[i];
		if (each.direction >= 0) {
			group.up.push(each);
		} else {
			group.down.push(each);
		}
	};
	ctx.strokeStyle = wickStroke.up;
	group.up.forEach(function (d) {
		ctx.beginPath();
		ctx.moveTo(d.x1, d.y1);
		ctx.lineTo(d.x2, d.y2);
		ctx.stroke();
	});
	ctx.strokeStyle = wickStroke.down;
	group.down.forEach(function (d) {
		ctx.beginPath();
		ctx.moveTo(d.x1, d.y1);
		ctx.lineTo(d.x2, d.y2);
		ctx.stroke();
	});
	var candleData = CandlestickSeries.getCandleData(props, xAccessor, yAccessor, xScale, yScale, compareSeries, plotData);

	group = { up: [], down: [] };

	for (var i = 0; i < candleData.length; i++) {
		each = candleData[i];
		if (each.direction >= 0) {
			group.up.push(each);
		} else {
			group.down.push(each);
		}
	};

	ctx.fillStyle = (0, _utilsUtils.hexToRGBA)(fill.up, opacity);
	group.up.forEach(function (d) {
		if (d.width < 0) {
			// <line className={d.className} key={idx} x1={d.x} y1={d.y} x2={d.x} y2={d.y + d.height}/>
			ctx.beginPath();
			ctx.moveTo(d.x, d.y);
			ctx.lineTo(d.x, d.y + d.height);
			ctx.stroke();
		} else if (d.height === 0) {
			// <line key={idx} x1={d.x} y1={d.y} x2={d.x + d.width} y2={d.y + d.height} />
			ctx.beginPath();
			ctx.moveTo(d.x, d.y);
			ctx.lineTo(d.x + d.width, d.y + d.height);
			ctx.stroke();
		} else {
			ctx.beginPath();
			ctx.rect(d.x, d.y, d.width, d.height);
			ctx.closePath();
			ctx.fill();
		}
	});

	ctx.fillStyle = (0, _utilsUtils.hexToRGBA)(fill.down, opacity);
	group.down.forEach(function (d) {
		if (d.width < 0) {
			// <line className={d.className} key={idx} x1={d.x} y1={d.y} x2={d.x} y2={d.y + d.height}/>
			ctx.beginPath();
			ctx.moveTo(d.x, d.y);
			ctx.lineTo(d.x, d.y + d.height);
			ctx.stroke();
		} else if (d.height === 0) {
			// <line key={idx} x1={d.x} y1={d.y} x2={d.x + d.width} y2={d.y + d.height} />
			ctx.beginPath();
			ctx.moveTo(d.x, d.y);
			ctx.lineTo(d.x + d.width, d.y + d.height);
			ctx.stroke();
		} else {
			ctx.beginPath();
			ctx.rect(d.x, d.y, d.width, d.height);
			ctx.closePath();
			ctx.fill();
		}
	});
	// ctx.fillStyle = fillStyle;
};

CandlestickSeries.getWickData = function (props, xAccessor, yAccessor, xScale, yScale, compareSeries, plotData) {
	var isCompareSeries = compareSeries.length > 0;

	var classNames = props.classNames;
	var wickStroke = props.wickStroke;

	var wickData = plotData.filter(function (d) {
		return d.close !== undefined;
	}).map(function (d) {
		// console.log(yAccessor);
		var ohlc = isCompareSeries ? yAccessor(d.compare) : yAccessor(d);

		var x1 = Math.round(xScale(xAccessor(d))),
		    y1 = yScale(ohlc.high),
		    x2 = x1,
		    y2 = yScale(ohlc.low),
		    className = ohlc.open <= ohlc.close ? classNames.up : classNames.down;

		return {
			x1: x1,
			y1: y1,
			x2: x2,
			y2: y2,
			className: className,
			direction: ohlc.close - ohlc.open,
			stroke: ohlc.open <= ohlc.close ? wickStroke.up : wickStroke.down
		};
	});
	return wickData;
};

CandlestickSeries.getCandleData = function (props, xAccessor, yAccessor, xScale, yScale, compareSeries, plotData) {
	var isCompareSeries = compareSeries.length > 0;

	var classNames = props.classNames;
	var fill = props.fill;
	var stroke = props.stroke;
	var widthRatio = props.widthRatio;

	var width = xScale(xAccessor(plotData[plotData.length - 1])) - xScale(xAccessor(plotData[0]));
	var cw = width / (plotData.length - 1) * widthRatio;
	var candleWidth = Math.round(cw); // Math.floor(cw) % 2 === 0 ? Math.floor(cw) : Math.round(cw);
	var candles = plotData.filter(function (d) {
		return d.close !== undefined;
	}).map(function (d) {
		var ohlc = isCompareSeries ? yAccessor(d.compare) : yAccessor(d);
		var x = Math.round(xScale(xAccessor(d))) - (candleWidth === 1 ? 0 : 0.5 * candleWidth),
		    y = yScale(Math.max(ohlc.open, ohlc.close)),
		    height = Math.abs(yScale(ohlc.open) - yScale(ohlc.close)),
		    className = ohlc.open <= ohlc.close ? classNames.up : classNames.down;
		return {
			// type: "line"
			x: x,
			y: y,
			height: height,
			width: candleWidth,
			className: className,
			fill: ohlc.open <= ohlc.close ? fill.up : fill.down,
			stroke: ohlc.open <= ohlc.close ? stroke.up : stroke.down,
			direction: ohlc.close - ohlc.open
		};
	});
	return candles;
};

exports["default"] = (0, _wrap2["default"])(CandlestickSeries);
module.exports = exports["default"];