"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _wrap = require("./wrap");

var _wrap2 = _interopRequireDefault(_wrap);

var _utilsUtils = require("../utils/utils");

var HistogramSeries = (function (_React$Component) {
	_inherits(HistogramSeries, _React$Component);

	function HistogramSeries() {
		_classCallCheck(this, HistogramSeries);

		_get(Object.getPrototypeOf(HistogramSeries.prototype), "constructor", this).apply(this, arguments);
	}

	_createClass(HistogramSeries, [{
		key: "render",
		value: function render() {
			var props = this.props;

			return _react2["default"].createElement(
				"g",
				{ className: "histogram" },
				HistogramSeries.getBarsSVG(props)
			);
		}
	}]);

	return HistogramSeries;
})(_react2["default"].Component);

HistogramSeries.propTypes = {
	baseAt: _react2["default"].PropTypes.oneOfType([_react2["default"].PropTypes.oneOf(["top", "bottom", "middle"]), _react2["default"].PropTypes.number, _react2["default"].PropTypes.func]).isRequired,
	direction: _react2["default"].PropTypes.oneOf(["up", "down"]).isRequired,
	stroke: _react2["default"].PropTypes.bool.isRequired,
	widthRatio: _react2["default"].PropTypes.number.isRequired,
	opacity: _react2["default"].PropTypes.number.isRequired,
	fill: _react2["default"].PropTypes.oneOfType([_react2["default"].PropTypes.func, _react2["default"].PropTypes.string]).isRequired,
	className: _react2["default"].PropTypes.oneOfType([_react2["default"].PropTypes.func, _react2["default"].PropTypes.string]).isRequired,
	xAccessor: _react2["default"].PropTypes.func,
	yAccessor: _react2["default"].PropTypes.func,
	xScale: _react2["default"].PropTypes.func,
	yScale: _react2["default"].PropTypes.func,
	plotData: _react2["default"].PropTypes.array
};

HistogramSeries.defaultProps = {
	baseAt: "bottom",
	direction: "up",
	className: "bar",
	stroke: false,
	fill: "#4682B4",
	opacity: 1,
	widthRatio: 0.5
};

HistogramSeries.drawOnCanvas = function (props, ctx, xScale, yScale, plotData) {
	var xAccessor = props.xAccessor;
	var yAccessor = props.yAccessor;
	var stroke = props.stroke;

	var bars = HistogramSeries.getBars(props, xAccessor, yAccessor, xScale, yScale, plotData);

	var each,
	    group = {};
	for (var i = 0; i < bars.length; i++) {
		each = bars[i];
		if (each.x !== undefined) {
			if (group[each.fill] === undefined) {
				group[each.fill] = [];
			}
			group[each.fill].push(each);
		}
	};

	Object.keys(group).forEach(function (key) {
		if (group[key][0].barWidth < 1) {
			ctx.strokeStyle = key;
		} else {
			ctx.strokeStyle = key;
			ctx.fillStyle = (0, _utilsUtils.hexToRGBA)(key, props.opacity);
		}
		group[key].forEach(function (d) {
			if (d.barWidth < 1) {
				/* <line key={idx} className={d.className}
    			stroke={stroke}
    			fill={fill}
    			x1={d.x} y1={d.y}
    			x2={d.x} y2={d.y + d.height} />*/
				ctx.beginPath();
				ctx.moveTo(d.x, d.y);
				ctx.lineTo(d.x, d.y + d.height);
				ctx.stroke();
			} else {
				/* <rect key={idx} className={d.className}
    		stroke={stroke}
    		fill={fill}
    		x={d.x}
    		y={d.y}
    		width={d.barWidth}
    		height={d.height} /> */
				ctx.beginPath();
				ctx.rect(d.x, d.y, d.barWidth, d.height);
				ctx.fill();
				if (stroke) ctx.stroke();
			}
		});
	});
};

HistogramSeries.getBarsSVG = function (props) {

	/* eslint-disable react/prop-types */
	var xAccessor = props.xAccessor;
	var yAccessor = props.yAccessor;
	var xScale = props.xScale;
	var yScale = props.yScale;
	var plotData = props.plotData;

	/* eslint-disable react/prop-types */

	var bars = HistogramSeries.getBars(props, xAccessor, yAccessor, xScale, yScale, plotData);

	return bars.map(function (d, idx) {
		if (d.barWidth <= 1) {
			return _react2["default"].createElement("line", { key: idx, className: d.className,
				stroke: d.fill,
				x1: d.x, y1: d.y,
				x2: d.x, y2: d.y + d.height });
		}
		return _react2["default"].createElement("rect", { key: idx, className: d.className,
			stroke: d.stroke,
			fill: d.fill,
			x: d.x,
			y: d.y,
			width: d.barWidth,
			fillOpacity: props.opacity,
			height: d.height });
	});
};

HistogramSeries.getBars = function (props, xAccessor, yAccessor, xScale, yScale, plotData) {
	var baseAt = props.baseAt;
	var direction = props.direction;
	var className = props.className;
	var fill = props.fill;
	var stroke = props.stroke;
	var widthRatio = props.widthRatio;

	var base = baseAt === "top" ? 0 : baseAt === "bottom" ? yScale.range()[0] : baseAt === "middle" ? (yScale.range()[0] + yScale.range()[1]) / 2 : baseAt;

	var dir = direction === "up" ? -1 : 1;

	var getClassName = function getClassName() {
		return className;
	};
	if (typeof className === "function") {
		getClassName = className;
	}

	var getFill = function getFill() {
		return fill;
	};
	if (typeof fill === "function") {
		getFill = fill;
	}

	var width = xScale(xAccessor(plotData[plotData.length - 1])) - xScale(xAccessor(plotData[0]));
	var barWidth = Math.round(width / (plotData.length - 1) * widthRatio);

	var bars = plotData.filter(function (d) {
		return yAccessor(d) !== undefined;
	}).map(function (d) {
		var yValue = yAccessor(d);
		var x = Math.round(xScale(xAccessor(d))) - (barWidth === 1 ? 0 : 0.5 * barWidth),
		   
		// var x = (xScale(xAccessor(d))) - 0.5 * barWidth,
		className = getClassName(d),
		    y,
		    height;

		var newBase = base;
		if (typeof base === "function") {
			newBase = base(xScale, yScale, d);
		}

		if (dir > 0) {
			y = newBase;
			height = yScale.range()[0] - yScale(yValue);
		} else {
			y = yScale(yValue);
			height = newBase - y;
		}

		if (height < 0) {
			y = newBase;
			height = -height;
		}
		return {
			barWidth: barWidth,
			height: height,
			x: x,
			y: y,
			className: className,
			stroke: stroke ? getFill(d) : "none",
			fill: getFill(d)
		};
	});
	return bars;
};

exports["default"] = (0, _wrap2["default"])(HistogramSeries);
module.exports = exports["default"];