"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _d3 = require("d3");

var _d32 = _interopRequireDefault(_d3);

var _wrap = require("./wrap");

var _wrap2 = _interopRequireDefault(_wrap);

var KagiSeries = (function (_React$Component) {
	_inherits(KagiSeries, _React$Component);

	function KagiSeries() {
		_classCallCheck(this, KagiSeries);

		_get(Object.getPrototypeOf(KagiSeries.prototype), "constructor", this).apply(this, arguments);
	}

	_createClass(KagiSeries, [{
		key: "render",
		value: function render() {
			var props = this.props;
			var className = props.className;
			var stroke = props.stroke;
			var fill = props.fill;
			var strokeWidth = props.strokeWidth;
			var xAccessor = props.xAccessor;
			var xScale = props.xScale;
			var yScale = props.yScale;
			var plotData = props.plotData;

			var paths = KagiSeries.helper(plotData, xAccessor).map(function (each, i) {
				var dataSeries = _d32["default"].svg.line().x(function (item) {
					return xScale(item[0]);
				}).y(function (item) {
					return yScale(item[1]);
				}).interpolate("step-before");
				return _react2["default"].createElement("path", { key: i, d: dataSeries(each.plot), className: each.type,
					stroke: stroke[each.type], fill: fill[each.type], strokeWidth: strokeWidth });
			});
			return _react2["default"].createElement(
				"g",
				{ className: className },
				paths
			);
		}
	}]);

	return KagiSeries;
})(_react2["default"].Component);

KagiSeries.defaultProps = {
	className: "react-stockcharts-kagi",
	strokeWidth: 2,
	stroke: {
		yang: "#6BA583",
		yin: "#E60000"
	},
	fill: {
		yang: "none",
		yin: "none"
	},
	currentValueStroke: "#000000"
};

KagiSeries.yAccessor = function (d) {
	return { open: d.open, high: d.high, low: d.low, close: d.close };
};

KagiSeries.drawOnCanvas = function (props, ctx, xScale, yScale, plotData) {
	var xAccessor = props.xAccessor;
	var stroke = props.stroke;
	var strokeWidth = props.strokeWidth;
	var currentValueStroke = props.currentValueStroke;

	var begin = true;

	var paths = KagiSeries.helper(plotData, xAccessor);

	paths.forEach(function (each) {
		ctx.strokeStyle = stroke[each.type];
		ctx.lineWidth = strokeWidth;

		ctx.beginPath();
		var prevX;
		each.plot.forEach(function (d) {
			var x = xScale(d[0]);
			var y = yScale(d[1]);

			if (begin) {
				ctx.moveTo(x, y);
				begin = false;
			} else {
				if (prevX !== undefined) {
					ctx.lineTo(prevX, y);
				}
				ctx.lineTo(x, y);
			}
			prevX = x;
			// console.log(d);
		});
		ctx.stroke();
	});
	var lastPlot = paths[paths.length - 1].plot;
	var last = lastPlot[lastPlot.length - 1];
	ctx.beginPath();
	// ctx.strokeStyle = "black";
	ctx.lineWidth = 1;

	var x = xScale(last[0]);
	var y1 = yScale(last[2]);
	var y2 = yScale(last[3]);

	// console.log(last, x, y);
	ctx.moveTo(x, y1);
	ctx.lineTo(x + 10, y1);
	ctx.stroke();

	ctx.beginPath();
	ctx.strokeStyle = currentValueStroke;
	ctx.moveTo(x - 10, y2);
	ctx.lineTo(x, y2);
	ctx.stroke();
};

KagiSeries.helper = function (plotData, xAccessor) {
	var kagiLine = [];
	var kagi = {};
	var d = plotData[0];
	var idx = xAccessor(d);

	for (var i = 0; i < plotData.length; i++) {
		d = plotData[i];

		if (d.close === undefined) continue;
		if (kagi.type === undefined) kagi.type = d.startAs;
		if (kagi.plot === undefined) kagi.plot = [];

		idx = xAccessor(d);
		kagi.plot.push([idx, d.open]);

		if (d.changeTo !== undefined) {
			kagi.plot.push([idx, d.changePoint]);
			kagi.added = true;
			kagiLine.push(kagi);

			kagi = {
				type: d.changeTo,
				plot: [],
				added: false
			};
			kagi.plot.push([idx, d.changePoint]);
		}
	}

	if (!kagi.added) {
		kagi.plot.push([idx, d.close, d.current, d.reverseAt]);
		kagiLine.push(kagi);
	}

	// console.log(d.reverseAt);

	return kagiLine;
};

exports["default"] = (0, _wrap2["default"])(KagiSeries);
module.exports = exports["default"];