"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _d3 = require("d3");

var _d32 = _interopRequireDefault(_d3);

var _wrap = require("./wrap");

var _wrap2 = _interopRequireDefault(_wrap);

var Line = (function (_React$Component) {
	_inherits(Line, _React$Component);

	function Line() {
		_classCallCheck(this, Line);

		_get(Object.getPrototypeOf(Line.prototype), "constructor", this).apply(this, arguments);
	}

	_createClass(Line, [{
		key: "render",
		value: function render() {
			var _props = this.props;
			var stroke = _props.stroke;
			var fill = _props.fill;
			var className = _props.className;

			className = className.concat(stroke ? "" : " line-stroke");
			return _react2["default"].createElement("path", { d: Line.getPath(this.props), stroke: stroke, fill: fill, className: className });
		}
	}]);

	return Line;
})(_react2["default"].Component);

Line.propTypes = {
	className: _react2["default"].PropTypes.string,
	xScale: _react2["default"].PropTypes.func.isRequired,
	yScale: _react2["default"].PropTypes.func.isRequired,
	xAccessor: _react2["default"].PropTypes.func.isRequired,
	yAccessor: _react2["default"].PropTypes.func.isRequired,
	plotData: _react2["default"].PropTypes.array.isRequired,
	stroke: _react2["default"].PropTypes.string,
	fill: _react2["default"].PropTypes.string
};

Line.defaultProps = {
	className: "line ",
	fill: "none",
	stroke: "black"
};

Line.getPath = function (props) {
	var plotData = props.plotData;
	var xScale = props.xScale;
	var yScale = props.yScale;
	var xAccessor = props.xAccessor;
	var yAccessor = props.yAccessor;

	var dataSeries = _d32["default"].svg.line().defined(function (d) {
		return yAccessor(d) !== undefined;
	}).x(function (d) {
		return xScale(xAccessor(d));
	}).y(function (d) {
		return yScale(yAccessor(d));
	});
	return dataSeries(plotData);
};

Line.drawOnCanvas = function (props, ctx, xScale, yScale, plotData) {
	var xAccessor = props.xAccessor;
	var yAccessor = props.yAccessor;
	var stroke = props.stroke;

	ctx.strokeStyle = stroke;
	ctx.beginPath();

	var begin = true;
	plotData.forEach(function (d) {
		if (yAccessor(d) === undefined) {
			ctx.stroke();
			ctx.beginPath();
			begin = true;
		} else {
			if (begin) {
				begin = false;
				var x = ~ ~(0.5 + xScale(xAccessor(d)));
				var y = ~ ~(0.5 + yScale(yAccessor(d)));

				ctx.moveTo(x, y);
			}
			ctx.lineTo(xScale(xAccessor(d)), yScale(yAccessor(d)));
		}
	});
	ctx.stroke();
};

exports["default"] = (0, _wrap2["default"])(Line);
module.exports = exports["default"];