"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _HistogramSeries = require("./HistogramSeries");

var _HistogramSeries2 = _interopRequireDefault(_HistogramSeries);

var _Line = require("./Line");

var _Line2 = _interopRequireDefault(_Line);

var _StraightLine = require("./StraightLine");

var _StraightLine2 = _interopRequireDefault(_StraightLine);

var _wrap = require("./wrap");

var _wrap2 = _interopRequireDefault(_wrap);

var MACDSeries = (function (_React$Component) {
	_inherits(MACDSeries, _React$Component);

	function MACDSeries(props) {
		_classCallCheck(this, MACDSeries);

		_get(Object.getPrototypeOf(MACDSeries.prototype), "constructor", this).call(this, props);
		this.yAccessorForMACDLine = this.yAccessorForMACDLine.bind(this);
		this.yAccessorForSignalLine = this.yAccessorForSignalLine.bind(this);
		this.yAccessorForHistogram = this.yAccessorForHistogram.bind(this);
		this.yAccessorForHistogramBase = this.yAccessorForHistogramBase.bind(this);
	}

	_createClass(MACDSeries, [{
		key: "yAccessorForMACDLine",
		value: function yAccessorForMACDLine(d) {
			var yAccessor = this.props.yAccessor;

			return yAccessor(d) && yAccessor(d).MACDLine;
		}
	}, {
		key: "yAccessorForSignalLine",
		value: function yAccessorForSignalLine(d) {
			var yAccessor = this.props.yAccessor;

			return yAccessor(d) && yAccessor(d).signalLine;
		}
	}, {
		key: "yAccessorForHistogram",
		value: function yAccessorForHistogram(d) {
			var yAccessor = this.props.yAccessor;

			return yAccessor(d) && yAccessor(d).histogram;
		}
	}, {
		key: "yAccessorForHistogramBase",
		value: function yAccessorForHistogramBase(xScale, yScale /* , d */) {
			return yScale(0);
		}
	}, {
		key: "render",
		value: function render() {
			var _props = this.props;
			var className = _props.className;
			var indicator = _props.indicator;
			var xScale = _props.xScale;
			var yScale = _props.yScale;
			var xAccessor = _props.xAccessor;
			var plotData = _props.plotData;
			var type = _props.type;
			var opacity = _props.opacity;
			var histogramStroke = _props.histogramStroke;

			var options = indicator.options();

			return _react2["default"].createElement(
				"g",
				{ className: className },
				_react2["default"].createElement(_Line2["default"], {
					xScale: xScale, yScale: yScale,
					xAccessor: xAccessor, yAccessor: this.yAccessorForMACDLine,
					plotData: plotData,
					stroke: options.stroke.MACDLine, fill: "none",
					type: type }),
				_react2["default"].createElement(_Line2["default"], {
					xScale: xScale, yScale: yScale,
					xAccessor: xAccessor, yAccessor: this.yAccessorForSignalLine,
					plotData: plotData,
					stroke: options.stroke.signalLine, fill: "none",
					type: type }),
				_react2["default"].createElement(_HistogramSeries2["default"], {
					baseAt: this.yAccessorForHistogramBase,
					className: "macd-histogram",
					stroke: histogramStroke, fill: options.fill.histogram, opacity: opacity,
					yAccessor: this.yAccessorForHistogram }),
				MACDSeries.getHorizontalLine(this.props)
			);
		}
	}]);

	return MACDSeries;
})(_react2["default"].Component);

MACDSeries.getHorizontalLine = function (props) {

	/* eslint-disable react/prop-types */
	var xScale = props.xScale;
	var yScale = props.yScale;
	var xAccessor = props.xAccessor;
	var yAccessor = props.yAccessor;
	var plotData = props.plotData;
	var type = props.type;
	var zeroLineStroke = props.zeroLineStroke;
	var zeroLineOpacity = props.zeroLineOpacity;

	/* eslint-enable react/prop-types */

	return _react2["default"].createElement(_StraightLine2["default"], {
		stroke: zeroLineStroke, opacity: zeroLineOpacity, type: type,
		xScale: xScale, yScale: yScale,
		xAccessor: xAccessor, yAccessor: yAccessor,
		plotData: plotData,
		yValue: 0 });
};

MACDSeries.childContextTypes = {
	yAccessor: _react2["default"].PropTypes.func.isRequired
};

MACDSeries.propTypes = {
	className: _react2["default"].PropTypes.string,
	xScale: _react2["default"].PropTypes.func,
	yScale: _react2["default"].PropTypes.func,
	xAccessor: _react2["default"].PropTypes.func,
	yAccessor: _react2["default"].PropTypes.func,
	plotData: _react2["default"].PropTypes.array,
	type: _react2["default"].PropTypes.string,
	opacity: _react2["default"].PropTypes.number,
	histogramStroke: _react2["default"].PropTypes.bool,
	indicator: _react2["default"].PropTypes.func.isRequired
};

MACDSeries.defaultProps = {
	className: "react-stockcharts-macd-series",
	zeroLineStroke: "#000000",
	zeroLineOpacity: 0.3,
	opacity: 0.6,
	histogramStroke: false
};

exports["default"] = (0, _wrap2["default"])(MACDSeries);
module.exports = exports["default"];