"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _objectAssign = require("object-assign");

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _pure = require("../pure");

var _pure2 = _interopRequireDefault(_pure);

function getDisplayName(Series) {
	var name = Series.displayName || Series.name || "Series";
	return name;
}

function wrap(WrappedSeries) {
	var BaseCanvasSeries = (function (_React$Component) {
		_inherits(BaseCanvasSeries, _React$Component);

		function BaseCanvasSeries() {
			_classCallCheck(this, BaseCanvasSeries);

			_get(Object.getPrototypeOf(BaseCanvasSeries.prototype), "constructor", this).apply(this, arguments);
		}

		_createClass(BaseCanvasSeries, [{
			key: "componentDidMount",
			value: function componentDidMount() {
				var callback = WrappedSeries.drawOnCanvas;
				if (callback) {
					var chartCanvasType = this.context.chartCanvasType;
					var getCanvasContexts = this.props.getCanvasContexts;

					if (chartCanvasType !== "svg" && getCanvasContexts !== undefined) {
						var contexts = getCanvasContexts();
						var defaultProps = WrappedSeries.defaultProps;

						var props = (0, _objectAssign2["default"])({}, defaultProps, this.props);
						if (contexts) BaseCanvasSeries.baseReStockDrawOnCanvasHelper(contexts.axes, props, callback);
					}
				}
			}
		}, {
			key: "componentDidUpdate",
			value: function componentDidUpdate() {
				this.componentDidMount();
			}
		}, {
			key: "componentWillMount",
			value: function componentWillMount() {
				this.componentWillReceiveProps(this.props);
			}
		}, {
			key: "componentWillReceiveProps",
			value: function componentWillReceiveProps(nextProps) {
				var callback = WrappedSeries.drawOnCanvas;
				if (callback) {
					var canvasOriginX = nextProps.canvasOriginX;
					var canvasOriginY = nextProps.canvasOriginY;
					var height = nextProps.height;
					var width = nextProps.width;
					var compareSeries = nextProps.compareSeries;
					var indicator = nextProps.indicator;
					var xAccessor = nextProps.xAccessor;
					var yAccessor = nextProps.yAccessor;
					var seriesId = nextProps.seriesId;
					var chartId = nextProps.chartId;

					var canvasOrigin = [canvasOriginX, canvasOriginY];

					var defaultProps = WrappedSeries.defaultProps;

					var props = (0, _objectAssign2["default"])({}, defaultProps, nextProps);

					var draw = BaseCanvasSeries.baseReStockDrawOnCanvas.bind(null, props, callback, canvasOrigin, height, width, compareSeries, indicator, xAccessor, yAccessor);

					nextProps.callbackForCanvasDraw({
						chartId: chartId,
						seriesId: seriesId,
						draw: draw
					});
				}
			}
		}, {
			key: "render",
			value: function render() {
				var callback = WrappedSeries.drawOnCanvas;
				var chartCanvasType = this.props.chartCanvasType;

				if (chartCanvasType !== "svg" && callback !== undefined) return null;

				return _react2["default"].createElement(WrappedSeries, _extends({ ref: "wrappedSeries"
				}, this.props));
			}
		}]);

		return BaseCanvasSeries;
	})(_react2["default"].Component);

	;

	/*
 	var { type, height, width, compareSeries, indicator, xAccessor,
 		yAccessor, xScale, yScale, plotData, stroke, fill } = this.props;
 	// var { defaultProps } = WrappedSeries;
 		// console.log(this.props);
 			{...defaultProps}
 		type={type}
 		height={height} width={width}
 		compareSeries={compareSeries}
 		indicator={indicator}
 		xAccessor={xAccessor} yAccessor={yAccessor}
 		xScale={xScale} yScale={yScale}
 		stroke={stroke} fill={fill}
 		plotData={plotData}
 */

	BaseCanvasSeries.displayName = "wrap(" + getDisplayName(WrappedSeries) + ")";

	BaseCanvasSeries.baseReStockDrawOnCanvasHelper = function (canvasContext, props, callback) {
		var height = props.height;
		var width = props.width;
		var compareSeries = props.compareSeries;
		var indicator = props.indicator;
		var xAccessor = props.xAccessor;
		var yAccessor = props.yAccessor;
		var xScale = props.xScale;
		var yScale = props.yScale;
		var plotData = props.plotData;
		var canvasOriginX = props.canvasOriginX;
		var canvasOriginY = props.canvasOriginY;

		var canvasOrigin = [canvasOriginX, canvasOriginY];

		BaseCanvasSeries.baseReStockDrawOnCanvas(props, callback, canvasOrigin, height, width, compareSeries, indicator, xAccessor, yAccessor, canvasContext, xScale, yScale, plotData);
	};

	BaseCanvasSeries.baseReStockDrawOnCanvas = function (props, callback, canvasOrigin, height, width, compareSeries, indicator, xAccessor, yAccessor, ctx, xScale, yScale, plotData) {

		ctx.save();

		ctx.setTransform(1, 0, 0, 1, 0, 0);
		ctx.translate(canvasOrigin[0], canvasOrigin[1]);

		ctx.beginPath();
		ctx.rect(-1, -1, width + 1, height + 1);
		ctx.clip();

		// console.log(canvasOrigin, width, height);

		// console.log("HERE");
		if (callback) {
			var newProps = (0, _objectAssign2["default"])({}, { height: height, width: width, compareSeries: compareSeries, indicator: indicator, xAccessor: xAccessor, yAccessor: yAccessor }, props);
			callback(newProps, ctx, xScale, yScale, plotData);
		}

		ctx.restore();
	};

	/* Object.keys(WrappedSeries)
 	.filter((key) => key !== "propTypes")
 	.filter(key => key !== "defaultProps")
 	.filter(key => key !== "displayName")
 	.filter(key => key !== "contextTypes")
 	.filter(key => key !== "childContextTypes")
 	.forEach(key => BaseCanvasSeries[key] = WrappedSeries[key]);*/

	BaseCanvasSeries.yAccessor = WrappedSeries.yAccessor;
	BaseCanvasSeries.defaultProps = WrappedSeries.defaultProps;

	BaseCanvasSeries.propTypes = {
		getCanvasContexts: _react2["default"].PropTypes.func,
		chartCanvasType: _react2["default"].PropTypes.string
	};

	// console.log(Object.keys(BaseCanvasSeries))
	return (0, _pure2["default"])(BaseCanvasSeries, {
		getCanvasContexts: _react2["default"].PropTypes.func,
		canvasOriginX: _react2["default"].PropTypes.number,
		canvasOriginY: _react2["default"].PropTypes.number,
		height: _react2["default"].PropTypes.number.isRequired,
		width: _react2["default"].PropTypes.number.isRequired,
		callbackForCanvasDraw: _react2["default"].PropTypes.func.isRequired,
		chartId: _react2["default"].PropTypes.number.isRequired,
		seriesId: _react2["default"].PropTypes.number.isRequired,
		stroke: _react2["default"].PropTypes.string,
		fill: _react2["default"].PropTypes.string,

		chartCanvasType: _react2["default"].PropTypes.string,
		indicator: _react2["default"].PropTypes.func,
		xScale: _react2["default"].PropTypes.func.isRequired,
		yScale: _react2["default"].PropTypes.func.isRequired,
		xAccessor: _react2["default"].PropTypes.func.isRequired,
		yAccessor: _react2["default"].PropTypes.func.isRequired,
		compareSeries: _react2["default"].PropTypes.array.isRequired,
		plotData: _react2["default"].PropTypes.array.isRequired
	});
}

exports["default"] = wrap;
module.exports = exports["default"];